<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Staffing - ASPPL';
// $pageDescription = 'Staffing ASPPL - Associated Search Professionals Pvt Ltd';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'staffing';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';
?>
    <!-- main-area -->
    <main class="main-area fix">


        <!-- breadcrumb-area -->
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">Staffing</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/index">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">Staffing</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

        <!-- blog-details-area -->
        <style>
    /* --- Modern Styles for Cards & Grid --- */
    .section-spacing {
        margin-top: 50px;
    }

    /* Common Card Style */
    .modern-card {
        background: #ffffff;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
        display: flex;
        flex-direction: column; /* Changed to column for better text flow */
        height: 100%;
        border: 1px solid rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease-in-out;
    }

    .modern-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 30px rgba(13, 110, 253, 0.15);
        border-color: rgba(13, 110, 253, 0.3);
    }

    /* Header area of the card (Icon + Title) */
    .card-header-flex {
        display: flex;
        align-items: center;
        margin-bottom: 15px;
    }

    .icon-wrapper {
        width: 50px;
        height: 50px;
        background: rgba(13, 110, 253, 0.1);
        color: #0d6efd;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        margin-right: 15px;
        flex-shrink: 0;
        transition: all 0.3s ease;
    }

    .modern-card:hover .icon-wrapper {
        background: #0d6efd;
        color: #fff;
    }

    .card-title {
        font-weight: 700;
        font-size: 16px;
        color: #2c3e50;
        margin: 0;
        line-height: 1.3;
    }

    /* Content area of the card */
    .card-text {
        font-size: 14px;
        color: #555;
        line-height: 1.6;
        margin-bottom: 0;
    }

    /* Contact Box Style */
    .contact-box {
        background: #f8f9fa;
        border-left: 5px solid #0d6efd;
        padding: 20px;
        margin-top: 40px;
        border-radius: 4px;
    }

    /* Grid Gutter Utility */
    .gy-4 {
        --bs-gutter-y: 1.5rem;
    }
</style>

<section class="blog__details-area section-py-130">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="blog__details-wrap">
                    
                    <div class="blog__details-content">
                        <h2 class="title">About Associated Staffing Pvt Ltd. (ASPL)</h2>
                        
                        <p><strong>Associated Staffing Pvt Ltd. (short form: ASPL)</strong> is the group company of Associated Search Professionals Pvt Ltd. (ASPPL), it caters to the Temp staffing needs of the clients.</p>
                        
                        <p><strong>ASPL Services:</strong> ASPL provides a range of temp staffing services (mostly white-collar jobs) across Junior, Middle and senior professionals on short term or long-term contract with clients.</p>

                        <p>Typically contract ranging from 06 months to 2 or 3 years as per the client needs, across departments like sales, marketing, operations, corporate functions like HR, Finance, legal etc., where candidates can work on ASPL payroll and full time with the client.</p>

                        <p>Since the current business scenario demands workforce flexibility to meet fluctuating demands, such as seasonal rushes or short-term projects, hiring temps is also more cost-effective. It can reduce labor costs and administrative tasks, and allows businesses to access specialized skills on a project-by-project basis without long-term commitment. Additionally, using temporary staff serves as a low-risk way to evaluate a candidate before making a permanent hire.</p>

                        <p>
                            <strong>Industries we serve:</strong> ASPL serve a wide spectrum of industries, with a strong presence in Manufacturing, Healthcare, IT, Retail and Finance Services.<br>
                            <strong>Locations:</strong> ASPL have Office presence across Bangalore, Chennai, Mumbai and Delhi NCR.<br>
                            <strong>Certification:</strong> ASPL is ISO 9001:2008 certified and Registered under MSME.
                        </p>

                        <div class="blog__details-inner">
                            <div class="row align-items-center">
                                <div class="col-46 order-0 order-lg-2">
                                    <div class="blog__details-inner-thumb">
                                        <img src="assets/img/images/services/process-flow-01.jpg" alt="process-flow">
                                    </div>
                                </div>
                                <div class="col-54">
                                    <div class="blog__details-inner-content">
                                        <h4 class="title">Why Associated Staffing (ASPL) for Contract?</h4> <br>
                                        
                                        <ul class="list-wrap about__list-item-two">
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>Quality just-in-time staff for all requirements</li>
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>Domain-specialist consultants with first-hand experience and knowledge of the sectors they represent</li>
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>Tailored solutions based on specific client requirements</li>
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>Nation-wide presence</li>
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>End-to-end back end support for clients</li>
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>Online HR-MIS access for clients and associates</li>
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>Highly cost effective staffing solutions</li>
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>Headcount flexibility</li>
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>Statutory compliance</li>
                                            <li><div class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none"><path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" /></svg></div>Strong database of candidates</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="section-spacing">
                            <h4 class="title">Our strengths (Roles can be outsourced):</h4>
                            <p class="mb-4"><strong>Junior | Middle | Senior Management staffs across functions as follows:</strong></p>
                            
                            <div class="row gy-4">
                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-user-graduate"></i></div>
                                            <h5 class="card-title">Freshly Trained Engineers and support staffs</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-desktop"></i></div>
                                            <h5 class="card-title">IT support staffs, hardware, admin, support services</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-briefcase"></i></div>
                                            <h5 class="card-title">Accounts/HR, Admin and Support staffs</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-truck-loading"></i></div>
                                            <h5 class="card-title">Supply chain – Stores/ warehouse / Logistics / shipping</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-cogs"></i></div>
                                            <h5 class="card-title">Operations/ Manufacturing/ Maintenance O&M</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-bullhorn"></i></div>
                                            <h5 class="card-title">Field Sales /Marketing/ CustomerSupport</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-40">
                             <h4 class="title">Our Platform/software:</h4>
                             <p>We have both cloud based and Off line based licensed payroll software’s.</p>
                        </div>

                        <div class="section-spacing">
                            <h4 class="title">Our Operational Standards & Commitments:</h4>
                            <p class="mb-4">We maintain high standards of compliance, transparency, and employee care.</p>

                            <div class="row gy-4">
                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-balance-scale"></i></div>
                                            <h5 class="card-title">Legal & Statutory Compliances</h5>
                                        </div>
                                        <p class="card-text">Compliant as per ESI, PF, PT, TDS, Labour Laws, Bonus Act, Minimum Wages Act etc.</p>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-heartbeat"></i></div>
                                            <h5 class="card-title">Medical Insurance</h5>
                                        </div>
                                        <p class="card-text">We adopt this as per the client policy; shall vary from client to client.</p>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-user-shield"></i></div>
                                            <h5 class="card-title">Confidentiality of Payroll</h5>
                                        </div>
                                        <p class="card-text">Protected firewall server, limited manual access, everything is Automated. All Data is maintained properly, highly protected and can be retrieved even after 10+ years.</p>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-headset"></i></div>
                                            <h5 class="card-title">Customer Support</h5>
                                        </div>
                                        <p class="card-text">Specially assigned customer support executive for each client. Addressing issues Just in Time. Every ticket raised by customers / staffed employees shall be addressed within 24 Hours.</p>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-eye"></i></div>
                                            <h5 class="card-title">Process Transparency</h5>
                                        </div>
                                        <p class="card-text">Our entire process shall be highly transparent: Separate user name and password can be created and provided to every employee and client. They can access their payroll information anytime.</p>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-chalkboard-teacher"></i></div>
                                            <h5 class="card-title">Training & Coaching</h5>
                                        </div>
                                        <p class="card-text">All our staffed resources shall be provided special training on communication, behaviour, attire etiquette etc on need basis. We engage employees periodically to increase bonding and retention.</p>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-handshake"></i></div>
                                            <h5 class="card-title">Staff Retention</h5>
                                        </div>
                                        <p class="card-text">ASPL temp staffing employees have low Job Change index and high stability in their career; it helps us to maintain good reputation for ‘less attrition’ among its clients.</p>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-umbrella"></i></div>
                                            <h5 class="card-title">Insurance & Other Benefits</h5>
                                        </div>
                                        <p class="card-text">While working for the client, all expenses towards insurance and other benefits are to be decided by the client and ASPL adopts the client policy and instructions.</p>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-4">
                                    <div class="modern-card">
                                        <div class="card-header-flex">
                                            <div class="icon-wrapper"><i class="fas fa-file-contract"></i></div>
                                            <h5 class="card-title">HR & Leave Policies</h5>
                                        </div>
                                        <p class="card-text">HR Policy, Leave Policy, Working Hours, Uniform, Shift Operations, also Benefits like Canteen, Transport etc. are as per the client policy.</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!--<div class="contact-box">-->
                        <!--    <h5 class="title mb-0">For more details reach us at <a href="mailto:staffing@asppl.in" style="color: #0d6efd;">“staffing@asppl.in”</a></h5>-->
                        <!--</div>-->

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
        <!-- blog-details-area-end -->
        
       <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:staffing@asppl.in">staffing@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->

    </main>
    <!-- main-area-end -->
    
    <style>
    .blog__details-inner-thumb {
        height: 100%;
        overflow: visible !important;
    }

    .blog__details-inner-thumb img {
        width: 100%;
        height: 100%;
        object-fit: contain !important; /* Prevents cropping */
        object-position: center;
        display: block;
    }
</style>

<?php
include 'includes/footer.php';
?>
