<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Recruitment Process Outsourcing - ASPPL';
// $pageDescription = 'Recruitment Process Outsourcing ASPPL - Associated Search Professionals Pvt Ltd';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'rpo';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';
?>
   <!-- main-area -->
    <main class="main-area fix">


        <!-- breadcrumb-area -->
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">RPO (Recruitment Process Outsourcing)</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/index">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">RPO (Recruitment Process Outsourcing)</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

        <!-- services-details-area -->
        <div class="services__details-area-four section-py-130">
            <div class="container">
                <!--<div class="services__details-content-four">-->
                <!--    <div class="row">-->
                <!--        <div class="col-lg-5">-->
                <!--            <h2 class="title">Service <span>Overview</span></h2>-->
                <!--        </div>-->
                <!--        <div class="col-lg-7">-->
                <!--            <p>Investment planning is a strategic process designed to help individuals and businesses achieve their financial goals by effectively managing resources. This project focuses on developing a robust investment strategy tailored to the unique objectives, risk tolerance, and time horizons of clients. The key goal is to create a roadmap that maximizes returns while minimizing risks, ensuring financial security and growth.</p>-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
                <div class="services__details-thumb-four">
                    <img src="assets/img/services/Business-case-rpo.png" alt="img">
                </div>
            </div>
        </div>
        <!-- services-details-area-end -->

        <!-- section-divider -->
        <!--<div class="container">-->
        <!--    <div class="section__divider"></div>-->
        <!--</div>-->
        <!-- section-divider-end -->

<!-- faq-area -->
<section class="faq__area section-pb-130">
  <style>
    /* Icon + paragraph layout used across all accordion bodies */
    .icon-paragraph {
      display: flex;
      align-items: flex-start; /* align icon with top of text */
      gap: 12px;
      margin-bottom: 14px;
    }

    .icon-paragraph .icon {
      line-height: 0;     /* remove svg baseline gap */
      display: flex;
      align-items: center;
      justify-content: center;
      min-width: 18px;    /* reserve space for icon */
      color: #0b3b4b;     /* icon color — change if needed */
    }

    .icon-paragraph p {
      margin: 0;
      color: #2f3a40;
      font-size: 16px;
      line-height: 1.8;
    }

    /* optional accordion spacing tweak to match screenshots */
    .accordion .accordion-body { padding-top: 20px; padding-bottom: 24px; }
  </style>

  <div class="container">
    <div class="row align-items-center justify-content-center">
      <div class="col-lg-12">
        <div class="faq__wrap">
          <div class="accordion" id="accordionExample">

            <!-- 01. Project Based RPO -->
            <div class="accordion-item">
              <h2 class="accordion-header" id="headingOne">
                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                  01. Project Based RPO
                </button>
              </h2>

              <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                <div class="accordion-body">

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>The engagement is guided by a timeline for a particular number of positions or for a specific project; the timeline shall vary as per the duration of the project or number of people to be hired.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>A dedicated team of consultants are assigned to each client based on the service requirement.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>One member from this team will physically function from the client office while the rest support the requirements from the nearest ASPPL facility.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>There is an assigned point of escalation and operations lead in-charge of each client — this is apart from the resource that is physically accessible to the client each day.</p>
                  </div>

                </div>
              </div>
            </div>

            <!-- 02. Turnkey RPO -->
            <div class="accordion-item">
              <h2 class="accordion-header" id="headingTwo">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                  02. Turnkey RPO
                </button>
              </h2>

              <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                <div class="accordion-body">

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>In this model, ASPPL shall study, plan and execute the total recruitment solutions for clients on a turnkey basis;</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>It starts with assessment/study of the existing workforce, identifying talent gaps, preparing role descriptions for each role/position across all levels (white collar, Junior–Mid–Senior) and deputing a team of recruiters at the client office to handle recruitment end-to-end.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Time period shall vary from 6 months to 2 years.</p>
                  </div>

                </div>
              </div>
            </div>

            <!-- 03. Best Circumstances For Using A Project Based RPO -->
            <div class="accordion-item">
              <h2 class="accordion-header" id="headingThree">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                  03. Best Circumstances For Using A Project Based RPO
                </button>
              </h2>

              <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                <div class="accordion-body">

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>When clients have emergency hiring for a certain duration for more than 5+ positions.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>For niche skills / challenging fulfillment.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>If hiring managers are always under frequent travel causing delays in conducting interviews/shortlisting.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Positions are open for a long time and unable to get filled.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Already circulated to too many consultants, either no response or 'junk' response.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Client has no time to do preliminary interviews or pre-screening of profiles.</p>
                  </div>

                </div>
              </div>
            </div>

            <!-- 04. Best Circumstances For Using A Turnkey RPO -->
            <div class="accordion-item">
              <h2 class="accordion-header" id="headingFour">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                  04. Best Circumstances For Using A Turnkey RPO
                </button>
              </h2>

              <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                <div class="accordion-body">

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Client has enough resources (manpower & orders), but still goals are not achieved.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>If the client feels manpower rationalisation needs to be achieved.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>If the client has constant and consistent need to hire talent throughout the year and wants to reduce fixed & variable costs associated with recruitment.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>If role descriptions are not clear and there is no proper structure in the organization.</p>
                  </div>

                </div>
              </div>
            </div>

            <!-- 05. RPO -->
            <div class="accordion-item">
              <h2 class="accordion-header" id="headingFive">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                  05. RPO
                </button>
              </h2>

              <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#accordionExample">
                <div class="accordion-body">

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Unbiased talent management and hiring.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Recruitment process development and planning.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Optimizing internal resources for better use and growth.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Access to a team of professional recruiters.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Scale recruitment capacity up or down on demand.</p>
                  </div>

                </div>
              </div>
            </div>

            <!-- 06. Methodology -->
            <div class="accordion-item">
              <h2 class="accordion-header" id="headingSix">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                  06. METHODOLOGY?
                </button>
              </h2>

              <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#accordionExample">
                <div class="accordion-body">

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>ASPPL can assign a team of people comprising of –</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Project Leader – Delivery Operations</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>SPOC at Client office for 'day to day' Delivery Support.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Additional delivery team at ASPPL office managed by the Project Leader.</p>
                  </div>

                </div>
              </div>
            </div>

            <!-- Delivery Operations (expanded content from screenshot) -->
            <div class="accordion-item">
              <h2 class="accordion-header" id="headingSeven">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                  Delivery Operations
                </button>
              </h2>

              <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven" data-bs-parent="#accordionExample">
                <div class="accordion-body">

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Our SPOC who is deputed at Client’s office shall communicate with all stakeholders with the support of HR and understand all their recruitment needs.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Our SPOC can translate the details captured from the stakeholders (hiring managers) in the form of JD and discuss with the project leader and internal delivery team.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Project leader shall identify and establish search priorities; he shall determine the skills, knowledge and abilities required, offering insight and fresh perspectives on how clients can think about their needs.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>The project leader shall draw a search target plan by researching into companies and sectors to find those with relevant skill-sets and qualifications.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Project leader shall design & implement master tracker, sourcing strategy and assessment questionnaire among the team and thereby kick start the sourcing / hunting process.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Project team shall send the prospective list of pre-screened candidate resumes to SPOC and SPOC submits all the resumes 'position wise' to the hiring managers directly or route it through HR as per the protocol defined by the client.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Hiring Manager shall further screen the profiles as per his preference and provide the shortlisted candidate names to SPOC.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>SPOC in turn shall work with the internal project team to organize / schedule any type of interviews at multiple stages, and for reference checks / background verification processes.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>SPOC is responsible for completing the entire recruitment process by coordinating closely with the stakeholders at Client and consultant offices to ensure interviews, offers and on-boarding happen on time.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>SPOC is also responsible for hand-holding candidates throughout the recruitment process and remains answerable to client at various stages by keeping all data at their fingertips.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>The Project Leader and SPOC shall keep reviews with the client once a week to ensure there is no lapse and for smooth execution of RPO.</p>
                  </div>

                  <div class="icon-paragraph">
                    <div class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                        <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                    </div>
                    <p>Project team does sourcing, headhunting, networking etc., approach potential candidates, conduct rigorous competency-based interviews, and develop a short list of appropriately qualified and interested candidates to arrive at a prospective list of pre-screened candidates.</p>
                  </div>

                </div>
              </div>
            </div>

          </div><!-- accordion end -->
        </div>
      </div>
    </div>
  </div>
</section>
<!-- faq-area-end -->




     <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->


    </main>
    

    <!-- main-area-end -->

<?php
include 'includes/footer.php';
?>
