<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Retained Search - ASPPL';
// $pageDescription = 'Retained Search ASPPL - Associated Search Professionals Pvt Ltd';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'retained-search';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

$headerInternalCss = '
    .services__details-wrap .tab-pane {
        display: none;
    }
    .services__details-wrap .tab-pane.active {
        display: block;
    }
    .sidebar__cat-list .list-wrap li.active a {
        background-color: var(--tg-theme-primary);
        color: #fff;
    }
';

include 'includes/header.php';
?>
    <!-- main-area -->
    <main class="main-area fix">


        <!-- breadcrumb-area -->
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">Executive or C-suite hire
</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : "/"; ?>/">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">Executive or C-suite hire
</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

        <!-- services-details-area -->
        <section class="services__details-area section-py-130">
            <div class="container">
                <div class="row">
                    <div class="col-70 order-0 order-lg-2">
                        <div class="services__details-wrap">

                            <div id="step1" class="tab-pane active">
                                <div class="services__details-content-top">
                                    <h2 class="title">Associated Search Professionals</h2>
                                    <p>Associated Search professionals has more than 15+ years experience in leadership consulting. Leaders are the key drivers for any business growth and operations. Visible leaders and invisible leaders are many in the market. ASPPL vibrant search practices and unique assessments discover the best suiting leadership qualities among professionals and made it visible to our clients for their business growth.

    Our Vibrant search practice adopts 6 step approach or pre-screening criteria to arrive at shortlisting as follows:</p>
                                </div>
                                <div class="services__details-thumb">
                                    <img src="assets/img/homepage/retainer-search-sp.jpg" alt="img">
                                </div>
                                <div class="services__details-content">
                                    <h2 class="title-two">Step 1 - Client Orientation</h2>
                                    <p class="info-one">Understand the relevant Industry and the client from all angles such as business, people, technology, markets, culture, geography, past – present-future aspects and the on-going challenges from the business - customer eco system by analysing both internal - external factors and dynamics</p>
                                    <p class="info-two">We do this through a detailed market research and analysis through our expert cell., of our clients, benchmarking competition and market eco system, reviewing business reports, balance sheets etc... Whatever necessary and thereby arrive at a proper understanding of what the client may require and suggest them our findings if necessary!</p>
                                    <p class="info-three">This step would help us to validate the mandate given by the client and do the market mapping effectively.</p>
                                </div>
                            </div>
                            
                            <div id="step2" class="tab-pane">
    <div class="services__details-content">
        <h2 class="title-two">Step 2 - Research & Presentation</h2>
        <p class="info-one">Our dedicated team conducts thorough research based on the client's requirements, market trends, and competitor analysis. We identify potential candidates through our extensive network and proprietary databases.</p>
        
        <div class="services__mid-thumb my-4">
            <img src="assets/img/services/step-2.jpg" alt="Research & Presentation" class="img-fluid d-block mx-auto" style="max-width: 60%; height: auto; border-radius: 8px;">
        </div>
        
        <p class="info-two">A detailed presentation is then prepared, showcasing the profiles of the most suitable candidates, along with our analysis and recommendations. This allows for a transparent and informed decision-making process for our clients.</p>
    </div>
</div>
                            
                            <div id="step3" class="tab-pane">
    <div class="services__details-content">
        <h2 class="title-two">Step 3 - Assessment Concepts and Tools</h2>
        <p class="info-one">To ensure a perfect fit, we utilize a range of psychometric tests and leadership assessments. These tools help evaluate a candidate's cognitive abilities, personality traits, and leadership style.</p>
        <p class="info-two">The results from these assessments provide valuable insights into how a candidate might perform in the specific role and fit within the client's organizational culture, complementing the interview process.</p>
        
        <div style="margin-top: 25px; overflow-x: auto;">
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #ccc; font-size: 15px; color: #333;">
                <thead>
                    <tr>
                        <th colspan="3" style="background-color: #01022e; color: #ffffff; padding: 12px; text-align: center; font-weight: 700; border: 1px solid #01022e;">
                            ASPPL Core Assessment Concepts for Leadership roles
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Technical Assessments</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Behavioural Assessments</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Leadership Attributes</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Role Fitment</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Values & Ethics</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Honesty & Integrity</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Cognitive Ability</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Aptitude & Attitude</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Drive for Results</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Performance Assessments</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Personality Traits</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Risk Tolerance</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Career Accomplishments</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Interpersonal Skills</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Humility</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Right Mind set</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Emotional Stability</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Learning Agility</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Compensation & Benefits</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Emotional Intelligence (EQ)</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Courage</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Medical and Health</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Teamwork & Peer Handling</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Curiosity</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Background Assessments</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Communication and Verbal</td>
                        <td style="padding: 8px 12px; border: 1px solid #ccc;">Logical Reasoning</td>
                    </tr>
                </tbody>
            </table>
            <p style="margin-top: 15px; font-size: 14px; color: #555; font-style: italic;">
                Our assessment technique’s guarantee the client interest and ensure the selection 99.99% matches to the client expectations
            </p>
        </div>
        </div>
</div>
                            
                            

                            <div id="step4" class="tab-pane">
    <div class="services__details-content">
        <h2 class="title-two">Step 4 - Guidance on Compensation & Benchmarking</h2>
        <p class="info-one">We provide expert guidance on compensation packages, ensuring they are competitive and aligned with industry standards. Our benchmarking services help clients structure attractive offers to secure top talent.</p>
        <p class="info-two">We analyze salary trends, bonus structures, and long-term incentives to create a comprehensive compensation strategy that meets the expectations of both the client and the candidate.</p>
        
        <div style="margin-top: 30px;">
            <p style="font-size: 16px; font-weight: 600; color: #333; margin-bottom: 20px; line-height: 1.6;">
                ASPPL possesses unique capabilities in carrying out the following "industry / sector" specific surveys for our clients, and we have been doing this from time to time:
            </p>
            
            <ul style="list-style: none; padding: 0; margin: 0; display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 15px;">
                <li style="background: #f8f8f8; padding: 15px 20px; border-left: 4px solid #01022e; border-radius: 4px; font-size: 15px; color: #444; box-shadow: 0 2px 5px rgba(0,0,0,0.05);">
                    Compensation trend analysis
                </li>
                <li style="background: #f8f8f8; padding: 15px 20px; border-left: 4px solid #01022e; border-radius: 4px; font-size: 15px; color: #444; box-shadow: 0 2px 5px rgba(0,0,0,0.05);">
                    Comp & Ben Surveys
                </li>
                <li style="background: #f8f8f8; padding: 15px 20px; border-left: 4px solid #01022e; border-radius: 4px; font-size: 15px; color: #444; box-shadow: 0 2px 5px rgba(0,0,0,0.05);">
                    Role Vs Compensation Survey
                </li>
                <li style="background: #f8f8f8; padding: 15px 20px; border-left: 4px solid #01022e; border-radius: 4px; font-size: 15px; color: #444; box-shadow: 0 2px 5px rgba(0,0,0,0.05);">
                    Talent Survey Vs Role Vs Compensation
                </li>
            </ul>
        </div>
        </div>
</div>

                            <div id="step5" class="tab-pane">
    <div class="services__details-content">
        <h2 class="title-two">Step 5 - Professional Background Verification : Three Stage</h2>
        <!--<p class="info-one">Integrity and trust are paramount. We conduct rigorous background verification and reference checks for the shortlisted candidates. This step is crucial to validate the candidate's credentials, past performance, and professional conduct.</p>-->
        <!--<p class="info-two">Our process includes verifying educational qualifications, employment history, and professional references to provide our clients with complete peace of mind.</p>-->

        <div style="margin-top: 30px; background-color: #f9f9f9; padding: 25px; border-radius: 5px; border-left: 5px solid #01022e;">
            <!--<h3 style="font-size: 18px; font-weight: 700; margin-bottom: 20px; color: #222; text-transform: uppercase; border-bottom: 1px solid #ddd; padding-bottom: 10px;">-->
            <!--    Step 5 - Professional Background Verification : Three Stages-->
            <!--</h3>-->
            
            <ul style="list-style: none; padding: 0; margin: 0;">
                <li style="margin-bottom: 20px;">
                    <strong style="color: #01022e; font-size: 16px; display: block; margin-bottom: 5px;">Stage I:</strong>
                    <span style="color: #555; line-height: 1.6; font-size: 15px;">ASPPL conducts a detailed background verification of our candidates before referring their resumes to our client. This include their current employment checks, CTC verification to ensure the authenticity of our referrals.</span>
                </li>
                
                <li style="margin-bottom: 20px;">
                    <strong style="color: #01022e; font-size: 16px; display: block; margin-bottom: 5px;">Stage II:</strong>
                    <span style="color: #555; line-height: 1.6; font-size: 15px;">Also, ASPPL conducts a systematic background check once our candidates are finalized (before offer release) by talking to their previous companies, either to their superiors or key stake holders and get the complete perspective of their performance, integrity, ethics & values. We will provide a complete report to our clients for their verification.</span>
                </li>
                
                <li>
                    <strong style="color: #01022e; font-size: 16px; display: block; margin-bottom: 5px;">Stage III:</strong>
                    <span style="color: #555; line-height: 1.6; font-size: 15px;">ASPPL conducts verification on certain technical or behavioral competencies of our candidates during the interview process incase if client has any major doubt; this is done by finding a business case from the past experiences and by conducting a thorough probe on the same, also by verifying with the experts / stake holders who were involved with those business cases.</span>
                </li>
            </ul>
        </div>
        </div>
</div>
                            
                            
                            
                            <div id="step6" class="tab-pane">
                                <div class="services__details-content">
                                    <h2 class="title-two">Step 6 - Performance Commitment & Replacement</h2>
                                    <p class="info-one">Our commitment doesn't end with the placement. We stand by our selections and offer a performance commitment. We also provide a replacement guarantee for a specified period, should the candidate not meet the expected performance standards or leave the organization.</p>
                                    <p class="info-two">This guarantee underscores our confidence in our search process and provides an added layer of security for our clients' investment in leadership talent.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-30">
                        <aside class="services__sidebar">
                            <div class="sidebar__widget">
                                <div class="sidebar__cat-list">
                                    <ul class="list-wrap">
                                        <li class="active">
                                            <a href="javascript:void(0);" data-tab="step1">Step 1 - Client Orientation
                                                <span>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="14" viewBox="0 0 24 14" fill="none">
                                                        <path d="M1 6.7777H22.6667M22.6667 6.7777L16.9683 1M22.6667 6.7777L16.9683 12.5556" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);" data-tab="step2">Step 2 - Research & Presentation
                                                <span>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="14" viewBox="0 0 24 14" fill="none">
                                                        <path d="M1 6.7777H22.6667M22.6667 6.7777L16.9683 1M22.6667 6.7777L16.9683 12.5556" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);" data-tab="step3">Step 3 - Assessment Concepts and Tools
                                                <span>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="14" viewBox="0 0 24 14" fill="none">
                                                        <path d="M1 6.7777H22.6667M22.6667 6.7777L16.9683 1M22.6667 6.7777L16.9683 12.5556" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);" data-tab="step4">Step 4 - Guidance on Compensation & Benchmarking
                                                <span>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="14" viewBox="0 0 24 14" fill="none">
                                                        <path d="M1 6.7777H22.6667M22.6667 6.7777L16.9683 1M22.6667 6.7777L16.9683 12.5556" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);" data-tab="step5">Step 5 - Professional Background Verification
                                                <span>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="14" viewBox="0 0 24 14" fill="none">
                                                        <path d="M1 6.7777H22.6667M22.6667 6.7777L16.9683 1M22.6667 6.7777L16.9683 12.5556" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);" data-tab="step6">Step 6 - Performance Commitment & Replacement
                                                <span>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="14" viewBox="0 0 24 14" fill="none">
                                                        <path d="M1 6.7777H22.6667M22.6667 6.7777L16.9683 1M22.6667 6.7777L16.9683 12.5556" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="sidebar__widget">
                                <div class="sidebar__contact">
                                    <h4 class="title">Our Dedicated Team Can Find the Right Candidate</h4>
                                    <!--<p>It is a long established fact that reader will be distracted.</p>-->
                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/contact" class="tg-btn tg-btn-three">Contact Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                                    <div class="shape">
                                        <img src="assets/img/images/sidebar_contact_shape01.svg" alt="shape" class="rotateme">
                                        <img src="assets/img/images/sidebar_contact_shape02.svg" alt="shape" class="alltuchtopdown">
                                    </div>
                                </div>
                            </div>
                        </aside>
                    </div>
                </div>
            </div>
        </section>
        <!-- services-details-area-end -->


    </main>
    <!-- main-area-end -->
    
<?php
    $footerInternalScripts = "
          document.addEventListener('DOMContentLoaded', function() {
                const tabLinks = document.querySelectorAll('.sidebar__cat-list .list-wrap a');
                const tabPanes = document.querySelectorAll('.services__details-wrap .tab-pane');
        
                tabLinks.forEach(link => {
                    link.addEventListener('click', function(e) {
                        e.preventDefault();
        
                        const targetId = this.getAttribute('data-tab');
                        const targetPane = document.getElementById(targetId);
        
                        tabLinks.forEach(innerLink => {
                            innerLink.parentElement.classList.remove('active');
                        });
                        this.parentElement.classList.add('active');
        
                        tabPanes.forEach(pane => {
                            pane.classList.remove('active');
                        });
        
                        if (targetPane) {
                            targetPane.classList.add('active');
                        }
                    });
                });
            });  
    ";
?>
<?php
include 'includes/footer.php';
?>