<?php
// Override page title and description
// $pageTitle = 'People Culture - ASPPL';
// $pageDescription = 'People Culture ASPPL - Associated Search Professionals Pvt Ltd';

// Set current page url name
$currentPageUrlName = 'people-culture';

// 1. ADD MAGNIFIC POPUP LIBRARIES
$headerCssAndScriptFiles = [
    'css' => [
        'https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css'
    ],
    'js'  => []
];

$footerScriptFiles = [
    'js'  => [
        'https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js'
    ]
];

include 'includes/header.php';
?>

<style>
    /* 1. CONTAINER SETUP */
    .project__item-five {
        position: relative !important;
        overflow: hidden !important;
        border-radius: 12px;
        margin-bottom: 30px;
        height: auto !important; 
        background: transparent !important;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    /* 2. IMAGE STYLING */
    .project__thumb-five {
        margin: 0 !important;
        height: 100% !important;
        width: 100% !important;
    }
    
    .project__thumb-five img {
        width: 100% !important;
        height: 280px !important; /* Fixed height for uniformity */
        object-fit: cover !important;
        display: block !important;
        transition: transform 0.5s ease;
    }

    /* 3. THE TITLE BOX - ALWAYS VISIBLE AT BOTTOM */
    .project__content-five {
        position: absolute !important;
        left: 0 !important;
        bottom: 0 !important;
        width: 100% !important;
        
        /* FORCE VISIBILITY */
        opacity: 1 !important;
        visibility: visible !important;
        transform: none !important;
        
        /* APPEARANCE (Matches screenshot look) */
        background: #F6F7FA !important; /* Light grayish background */
        padding: 15px 10px !important;
        z-index: 10 !important;
        
        display: block !important; 
        text-align: center; /* Center align the title */
    }

    /* 4. TITLE TEXT */
    .project__content-five .title {
        margin: 0 !important;
        font-size: 16px !important; 
        font-weight: 700 !important;
        color: #0A1128 !important; /* Dark color for text */
    }

    /* HOVER EFFECTS */
    .project__item-five:hover .project__thumb-five img {
        transform: scale(1.05); 
    }
    
    /* CURSOR FOR IMAGE LINK */
    a.popup-image {
        cursor: zoom-in;
        display: block; 
    }
</style>

    <main class="main-area fix">

        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">People & Culture</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">People & Culture</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <div class="services__details-area-four section-py-130">
            <div class="container">
                <div class="services__details-content-four">
                    <div class="row">
                        <div class="col-lg-5">
                            <h2 class="title">An Overview Of <span>Working In ASPPL</span></h2>
                        </div>
                    </div>
                </div>
                <div class="services__details-thumb-four">
                    <img src="assets/img/images/people-culture.png" alt="asppl-people-culture">
                </div>
            </div>
        </div>
        <div class="container">
            <div class="section__divider"></div>
        </div>
        <section class="project__solution-area section-py-130">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-6 col-md-8">
                        <div class="project__solution-thumb">
                            <img src="assets/img/images/asppl-bday-cel.jpg" alt="img">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="project__solution-content">
                            <div class="project__solution-item-wrap">
                                <div class="project__solution-item">
                                    <p>We have adopted a very open, transparent culture, with empowerment and authority to all our colleagues, we encourage them to exercise their ideas/ initiatives and motivate them to learn through experiences.</p>
                                </div>
                                <div class="project__solution-item">
                                    <p>We mentor our budding resources, provide them good industry exposure, offer them strong platform or a training ground to practice their own style of recruitment within our fundamental framework, and guide them to enrich their knowledge and expertise.</p>
                                </div>
                                <div class="project__solution-item">
                                    <p>We always believe self-development or Individual development is a key for organization success; we enable our consultants to go-through training & development programme on a periodical basis which can emphasis on various industry sectors, domain / skill areas / emerging subjects, personality development, communication development, email etiquette's, how to engage with senior professionals, CRM so on, so forth.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="benefit__area-two section-py-130">
            <div class="container">
                
                <div class="row justify-content-center">
                    <div class="col-lg-10">
                        <div class="section__title text-center mb-50">
                            <h2 class="title">An Overview Of "Working In ASPPL":</h2>
                        </div>
                    </div>
                </div>

                <div class="row gutter-y-30 popup-gallery">
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/cul1.jpg" class="popup-image" title="Birthday Celebration">
                                    <img src="assets/img/cult/cul1.jpg" alt="Birthday Celebration">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Birthday Celebration</h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/cul2.jpg" class="popup-image" title="Team Lunch">
                                    <img src="assets/img/cult/cul2.jpg" alt="Team Lunch">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Lunch</h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/cul3.jpg" class="popup-image" title="Office Anniversary">
                                    <img src="assets/img/cult/cul3.jpg" alt="Office Anniversary">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Office Anniversary</h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/cul5.jpg" class="popup-image" title="Team Outing">
                                    <img src="assets/img/cult/cul5.jpg" alt="Team Outing">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Outing</h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/cul6.jpg" class="popup-image" title="Pot Luck">
                                    <img src="assets/img/cult/cul6.jpg" alt="Pot Luck">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Pot Luck</h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/cul7.jpg" class="popup-image" title="Navratri Festival ">
                                    <img src="assets/img/cult/cul7.jpg" alt="Navratri Festival ">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Navratri Festival</h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/001.jpg" class="popup-image" title="Team Outing">
                                    <img src="assets/img/cult/001.jpg" alt="Team Outing">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Outing</h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/002.JPG" class="popup-image" title="Team Outing ">
                                    <img src="assets/img/cult/002.JPG" alt="Team Outing ">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Outing</h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/003.jpg" class="popup-image" title="Team Outing">
                                    <img src="assets/img/cult/003.jpg" alt="Team Outing">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Outing</h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/004.jpg" class="popup-image" title="Team Outing ">
                                    <img src="assets/img/cult/004.jpg" alt="Team Outing ">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Outing</h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/005.jpg" class="popup-image" title="Team Outing">
                                    <img src="assets/img/cult/005.jpg" alt="Team Outing">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Outing</h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/006.jpg" class="popup-image" title="Team Outing ">
                                    <img src="assets/img/cult/006.jpg" alt="Team Outing">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Outing</h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/007.jpg" class="popup-image" title="Team Outing">
                                    <img src="assets/img/cult/007.jpg" alt="Team Outing">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Outing</h2>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/cult/008.JPG" class="popup-image" title="Team Outing">
                                    <img src="assets/img/cult/008.JPG" alt="Team Outing">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">Team Outing</h2>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->
        </main>
    <script>
    jQuery(document).ready(function($) {
        $('.popup-gallery').magnificPopup({
            delegate: 'a.popup-image', 
            type: 'image',
            tLoading: 'Loading image #%curr%...',
            mainClass: 'mfp-img-mobile',
            gallery: {
                enabled: true,
                navigateByImgClick: true,
                preload: [0,1] 
            },
            image: {
                tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
                titleSrc: function(item) {
                    return item.el.attr('title');
                }
            }
        });
    });
</script>

<?php include 'includes/footer.php'; ?>