<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Active Searches - ASPPL';
// $pageDescription = 'View our current job openings and active searches';

// Set current page url name (Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'leadership-fitments';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';
?>

<!-- main-area -->
<main class="main-area fix">

    <!-- breadcrumb-area -->
    <section class="breadcrumb__area-two">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="breadcrumb__content breadcrumb__content-two">
                        <h2 class="title">Leadership Fitments</h2>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- career-area -->
    <section class="career__area-two section-py-100">
        <div class="container">

            <!-- Optional: quick reference image (local file you uploaded) -->
            <!-- Developers: the path below is available at /mnt/data/... -->
            <!--<div style="text-align:center; margin-bottom:18px;">-->
            <!--    <img src="/mnt/data/screencapture-asppl-in-leadership-fitments-php-2025-11-21-00_25_46.png"-->
            <!--         alt="leadership fitments reference" style="max-width:320px; border-radius:6px; box-shadow:0 4px 12px rgba(0,0,0,0.08);">-->
            <!--</div>-->

            <!-- section title -->
            <div class="row justify-content-center mb-30">
                <div class="col-lg-10">
                    <h3 class="section-heading">Some of the latest and noteworthy fitments</h3>
                </div>
            </div>

            <!-- styled table card -->
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="fitments-card">

                        <div class="table-responsive">
                            <table class="fitments-table" aria-describedby="fitments-caption">
                                <caption id="fitments-caption" class="sr-only">List of leadership fitments and roles</caption>
                                <thead>
                                    <tr>
                                        <th scope="col">Company / Mandate</th>
                                        <th scope="col">Role(s)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
    <td>Leading Indian Business Group, Semiconductor Venture</td>
    <td>Chief Executive Officer<br>Chief Operations Officer<br>Director Supply Chain</td>
</tr>

<tr>
    <td>Leading Auto Tier 1 Company, Instrument Cluster</td>
    <td>Chief Marketing Officer<br>Head HR<br>Chief Technology Officer</td>
</tr>

<tr>
    <td>Green Hydrogen Electrolyzer, US MNC</td>
    <td>Director HR<br>VP Finance<br>VP R&D<br>Director Quality<br>Director Operations</td>
</tr>

<tr>
    <td>Wind Nozzle Manufacturer, European MNC</td>
    <td>Country Head<br>CFO<br>Head R&D<br>Head Operations</td>
</tr>

<tr>
    <td>Leading Pipes and Fittings, European MNC</td>
    <td>Chief Marketing Officer<br>Chief Financial Officer<br>Chief Technology Officer<br>Chief Manufacturing Officer</td>
</tr>

<tr>
    <td>Leading Castings and Foundry</td>
    <td>Head Business Development<br>Plant Head</td>
</tr>

<tr>
    <td>Indian Company in the Business of Developing Urban Infrastructure & Investments</td>
    <td>CFO</td>
</tr>

<tr>
    <td>Indian Company in the Business of Mining and Mineral Processing</td>
    <td>Corporate Legal<br>Site Director</td>
</tr>

<tr>
    <td>Global Engineering Services Company</td>
    <td>Vice President Technology</td>
</tr>

<tr>
    <td>Semiconductor Hardware Engineering Services</td>
    <td>Sr Technical Architect</td>
</tr>

<tr>
    <td>European MNC, Building Materials</td>
    <td>Director – University L&D</td>
</tr>

<tr>
    <td>Global EMS Company</td>
    <td>VP Business Development</td>
</tr>

<tr>
    <td>India’s Largest Rigid Plastic Packaging Company</td>
    <td>Chief Operations Officer</td>
</tr>

<tr>
    <td>Largest Transformer Company</td>
    <td>Managing Director</td>
</tr>

<tr>
    <td>Leading Engineering Services Company</td>
    <td>Vice President – Deliver</td>
</tr>

<tr>
    <td>Leading Packaging Company</td>
    <td>Director</td>
</tr>

<tr>
    <td>Engineering Services Company</td>
    <td>CFO</td>
</tr>

<tr>
    <td>Electrical Equipment (Manufacturing)</td>
    <td>CFO</td>
</tr>

<tr>
    <td>Auto Components Manufacturing</td>
    <td>VP – R & D</td>
</tr>

<tr>
    <td>Leading Gas Company</td>
    <td>Group CFO & CS</td>
</tr>

<tr>
    <td>Global EMS Company</td>
    <td>VP & Site GM</td>
</tr>

<tr>
    <td>Leading Taiwan Company</td>
    <td>Country Manager</td>
</tr>

<tr>
    <td>Auto MNC Manufacturing</td>
    <td>AVP – HR</td>
</tr>

<tr>
    <td>Leading Global Electronic Distributor</td>
    <td>Director</td>
</tr>

<tr>
    <td>Leading EMS Company</td>
    <td>MD</td>
</tr>

<tr>
    <td>Leading Company Manufacturing Speciality and Fine Chemicals</td>
    <td>VP – Finance</td>
</tr>

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </section>

   <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->

</main>
<!-- main-area-end -->

<?php
include 'includes/footer.php';
?>

<!-- Inline styles: you can move these to your main CSS file if preferred -->
<style>
/* If your header already loads the fonts, this link tag is safe to remove.
   Keeping it here ensures the page uses the intended fonts. */
@import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@600;700&family=Open+Sans:wght@300;400;600&display=swap');

:root{
    --primary-teal: #007a8a;    /* accent similar to header */
    --muted-blue: #0b3b53;      /* darker header tone */
    --table-bg: #ffffff;
    --row-alt: #f6f6f6;
    --border: #e6e6e6;
    --text-dark: #20343a;
}

body {
    font-family: 'Open Sans', Arial, sans-serif;
    color: var(--text-dark);
}

/* Section heading style */
.section-heading {
    font-family: 'Montserrat', 'Open Sans', sans-serif;
    font-weight: 700;
    color: var(--muted-blue);
    letter-spacing: 0.6px;
    padding: 8px 0;
    margin: 0 0 8px 0;
}

/* Card container */
.fitments-card {
    background: var(--table-bg);
    border-radius: 6px;
    padding: 18px;
    box-shadow: 0 6px 24px rgba(20,40,60,0.06);
    border: 1px solid rgba(0,0,0,0.03);
}

/* Table */
.fitments-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13.5px;
    table-layout: auto;
}

/* Header row */
.fitments-table thead th {
    text-align: left;
    padding: 14px 16px;
    background: linear-gradient(90deg, rgba(0,122,138,0.06), rgba(11,59,83,0.02));
    color: var(--muted-blue);
    font-weight: 700;
    border-bottom: 1px solid var(--border);
    vertical-align: middle;
    font-family: 'Montserrat', 'Open Sans', sans-serif;
}

/* Body rows */
.fitments-table tbody td {
    padding: 12px 16px;
    vertical-align: top;
    border-bottom: 1px solid var(--border);
}

.fitments-table tbody tr:nth-child(even) {
    background: var(--row-alt);
}

.fitments-table tbody tr:hover {
    background: rgba(0,122,138,0.03);
}

.fitments-table tbody td br {
    line-height: 1.35;
}

/* Responsive: stack cells on small screens */
@media (max-width: 768px) {
    .fitments-table thead {
        display: none;
    }
    .fitments-table tbody tr {
        display: block;
        margin-bottom: 12px;
        border-radius: 6px;
        overflow: hidden;
    }
    .fitments-table tbody td {
        display: block;
        width: 100%;
        padding: 10px 12px;
    }
    .fitments-table tbody td::before {
        content: attr(data-label);
        display: block;
        font-weight: 600;
        margin-bottom: 6px;
        color: var(--muted-blue);
        font-family: 'Montserrat', 'Open Sans', sans-serif;
    }
}

/* Improve accessibility: visually hidden caption */
.sr-only {
  border: 0;
  clip: rect(0 0 0 0);
  clip-path: inset(50%);
  height: 1px;
  margin: -1px;
  overflow: hidden;
  padding: 0;
  position: absolute;
  width: 1px;
  white-space: nowrap;
}
</style>
