<?php
// Override page title and description (enable only if needed for SEO purposes)
//$pageTitle = 'ASPPL - Associated Search Professionals Pvt Ltd';
//$pageDescription = 'ASPPL - Associated Search Professionals Pvt Ltd. We are a leading recruitment firm.';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'home';

$headerCssAndScriptFiles = [
    'css' => ["assets/css/homepage-custom-styles.css"],
];

$footerScriptFiles = [
    'js'  => ["assets/js/homepage-custom-scripts.js"],
];

// Include the dynamic header
include 'includes/header.php';
?>
    <!-- main-area -->
    <main class="main-area fix">
        
       <!-- banner-area -->
        <section class="banner__area fix">
            <div class="banner__bg" data-background="assets/img/banner/hero_bg.jpg" style="background-image: url(&quot;assets/img/banner/hero_bg.jpg&quot;);"></div>

            <div class="swiper-container banner-active">
                <div class="swiper-wrapper">
                    <?php
                        $bannerItems = $db->select("SELECT * FROM services WHERE status = '1' ORDER BY id DESC");

                        foreach ($bannerItems as $banner):
                            $bannerTitle = isset($banner['service_name']) && $banner['service_name'] !== ''
                                ? escape_html($banner['service_name'])
                                : '';

                            $bannerDescription = isset($banner['service_description']) && $banner['service_description'] !== ''
                                ? escape_html($banner['service_description'])
                                : '';

                            $bannerButtonText = isset($banner['button_text']) && $banner['button_text'] !== ''
                                ? escape_html($banner['button_text'])
                                : '';

                            // Image (show only if exists)
                            $bannerImage = isset($banner['image_slider']) && $banner['image_slider'] !== ''
                                ? "admin/" . escape_html($banner['image_slider'])
                                : '';
                                
                            // Button URL
                            $rawBannerUrl = isset($banner['button_url']) ? trim($banner['button_url']) : '';
                            $bannerExternalUrl = 0;
                            if ($rawBannerUrl === '') {
                                $bannerButtonUrl = '#';
                            } else if (strpos($rawBannerUrl, '/') === 0) { // internal URL
                                $basePathUrl = isset($projectBasePath)? escape_html($projectBasePath) : "";
                                $bannerButtonUrl = $basePathUrl . escape_html($rawBannerUrl);
                            } else if(filter_var($rawBannerUrl, FILTER_VALIDATE_URL)) { // external URL
                                $bannerButtonUrl = escape_html($rawBannerUrl);
                                $bannerExternalUrl = 1;
                            } else {
                                $bannerButtonUrl = '#';
                            }
                    ?>
                            <div class="swiper-slide">
                                <div class="container">
                                    <div class="row align-items-center justify-content-center">

                                        <!-- Left Section -->
                                        <div class="col-lg-7">
                                            <div class="banner__content">

                                                <?php if ($bannerTitle): ?>
                                                    <h2 class="title" data-aos="fade-up" data-aos-delay="300">
                                                        <?= $bannerTitle ?>
                                                    </h2>
                                                <?php endif; ?>

                                                <?php if ($bannerDescription): ?>
                                                    <p data-aos="fade-up" data-aos-delay="500">
                                                        <?= $bannerDescription ?>
                                                    </p>
                                                <?php endif; ?>

                                                <?php if ($bannerButtonText): ?>
                                                    <div class="banner__btn" data-aos="fade-up" data-aos-delay="700">
                                                        <a <?php if(isset($bannerExternalUrl) && $bannerExternalUrl===1){ echo 'target="_blank"'; } ?> href="<?= $bannerButtonUrl ?>" class="tg-btn">
                                                            <?= $bannerButtonText ?>
                                                            <img src="assets/img/icons/right_arrow.svg" alt="Arrow" class="injectable">
                                                        </a>
                                                    </div>
                                                <?php endif; ?>

                                            </div>
                                        </div>

                                        <!-- Right Section -->
                                        <div class="col-lg-5 col-md-8">
                                            <?php if ($bannerImage): ?>
                                                <div class="banner__img">
                                                    <img src="<?= $bannerImage ?>" 
                                                        alt="<?= $bannerTitle ?: 'Banner Image' ?>" 
                                                        class="main-img">
                                                </div>
                                            <?php endif; ?>
                                        </div>

                                    </div>
                                </div>
                            </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Swiper Navigation Buttons -->
            <div class="banner__nav-wrap">
                <button class="banner-button-prev">
                    <img src="assets/img/icons/right_arrow.svg" alt="prev" class="injectable">
                </button>
                <button class="banner-button-next">
                    <img src="assets/img/icons/right_arrow.svg" alt="next" class="injectable">
                </button>
            </div>

            <div class="banner__shape">
                <img src="assets/img/banner/hero_shape02.svg" alt="shape" data-aos="fade-right" data-aos-delay="800">
            </div>
        </section>
       <!-- banner-area-end -->

        <!-- client/brand-area -->
        <?php
            $clientLogos = $db->select("SELECT title, path_small FROM clients_logo WHERE status = '1' ORDER BY id DESC");
            if (!empty($clientLogos)):
        ?>
            <div class="brand__area">
                <div class="container">
                    <div class="swiper-container brand-active fix">
                        <div class="swiper-wrapper">

                            <?php foreach ($clientLogos as $clientLogo): ?>
                                <?php
                                    $clientLogoTitle = isset($clientLogo['title']) && $clientLogo['title'] !== ''
                                        ? escape_html($clientLogo['title'])
                                        : 'Client Logo';

                                    $clientLogoPath = isset($clientLogo['path_small']) && $clientLogo['path_small'] !== ''
                                        ? "admin/" . escape_html($clientLogo['path_small'])
                                        : '';
                                ?>

                                <?php if ($clientLogoPath): ?>
                                    <div class="swiper-slide">
                                        <div class="brand-item">
                                            <img src="<?= $clientLogoPath ?>" alt="<?= $clientLogoTitle ?>">
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <!-- client/brand-area-end -->

        <!-- about-area -->
        <section class="about__area section-py-130">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-6 col-md-9">
                        <div class="about__img-wrap">
                            <div class="about__images">
                                <img src="assets/img/images/about_img01.jpg" alt="img">
                                <img src="assets/img/images/about_img02.jpg" alt="img" data-aos="fade-up" data-aos-delay="200">
                            </div>
                            <div class="experience__wrap" data-aos="fade-left" data-aos-delay="200">
                                <h2 class="count">15+</h2>
                                <span>Years Of <br> Experience</span>
                            </div>
                            <div class="profit__wrap" data-parallax='{"x" : 50 }'>
                                <div class="thumb">
                                    <img src="assets/img/images/profit_grap.svg" alt="img">
                                </div>
                                <div class="content">
                                    <h5 class="title">500+</h5>
                                    <span>Active Clients</span>
                                </div>
                            </div>
                            <div class="shape">
                                <img src="assets/img/images/about_shape01.svg" alt="shape" data-aos="fade-up-right" data-aos-delay="600">
                                <img src="assets/img/images/about_shape02.svg" alt="shape" class="alltuchtopdown">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="about__content">
                            <div class="section__title mb-15">
                                <span class="sub-title">Behind Our History</span>
                                <h2 class="title">Empowering organizations through leadership excellence.</h2>
                            </div>
                            <p>Associated Search Professionals Private Limited., (short form: ASPPL) founded by team of Passionate recruiters in the year 2010, a company incorporated under the Companies Act 1956, having registration number (CIN: U74140KA2010PTC053637) with registered office at No 623, HMT Main Road, Mathikere, Bangalore – 560 054., India</p>
                            <div class="about__inner-wrap">
                                <div class="about__list-box">
                                    <div class="about__list-box-item">
                                        <!-- <div class="icon">
                                            <i class="flaticon-growth"></i>
                                        </div> -->
                                        <div class="content">
                                            <h4 class="title">10000+ <br> Fitment to date</h4>
                                        </div>
                                    </div>
                                    <div class="about__list-box-item">
                                        <!-- <div class="icon">
                                            <i class="flaticon-pie-chart-1"></i>
                                        </div> -->
                                        <div class="content">
                                            <h4 class="title">250+ <br> CXO Searches</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="about__inner-content">
                                    <p>in the past 15+ years ASPPL has made a benchmark in the industry by recruiting over 10000+ professionals across 400+ clients, our team of 40+ consultants spans across 10+ industry verticals with offices across 6 regions within the country brings in enormous knowledge and expertise and creating huge value proposition to the clients</p>
                            
                                </div>
                            </div>
                            <div class="about__content-bottom">
                                <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/about" class="tg-btn">Explore Our Company <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- about-area-end -->
        
        <!-- industries-area -->
        <?php
            $industries = $db->select("SELECT title, image FROM industries WHERE status='1' ORDER BY sort_order ASC, id DESC");
            if (!empty($industries)):
        ?>
            <section class="industries__area mb-5 mt-1">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-7 col-lg-9">
                        <div class="section__title text-center mb-50">
                            <span class="sub-title">WE PROVIDE EXPERTS IN ALMOST EVERY FIELD</span>
                            <h2 class="title">Industries We Have Expertise In</h2>
                        </div>
                    </div>
                </div>
        
                <div class="slider-mask">
                    <div class="swiper-container industries-active">
                        <div class="swiper-wrapper">
        
                            <?php foreach ($industries as $industry): ?>
        
                                <?php
                                    $industryTitle = !empty($industry['title'])
                                        ? escape_html($industry['title'])
                                        : 'Industry';
        
                                    $industryImage = !empty($industry['image'])
                                        ? "admin/" . escape_html($industry['image'])
                                        : "";
                                ?>
        
                                <div class="swiper-slide">
                                    <div class="industries__item">
                                        <div class="industries__thumb">
                                            <img src="<?= $industryImage ?>" alt="<?= $industryTitle ?>">
                                        </div>
                                        <div class="industries__bottom"><p><?= $industryTitle ?></p></div>
                                    </div>
                                </div>
        
                            <?php endforeach; ?>
        
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php endif; ?>
        <!-- industries-area-end -->

        <!-- services-area -->
        <section class="services__area fix section-py-130 services__bg" data-background="assets/img/bg/services_bg.png">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-8">
                        <div class="section__title text-center mb-50">
                            <!--<span class="sub-title">Our Dedicated Services</span>-->
                            <h2 class="title">Our Services</h2>
                        </div>
                    </div>
                </div>
                <div class="swiper-container services-active fix">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="services__item shine__animate-item">
                                <div class="services__thumb shine__animate-link">
                                    <a href="retained-search"><img src="assets/img/homepage/retainer-search-hp.jpg" alt="img"></a>
                                    <!--<div class="services__icon">-->
                                    <!--    <i class="flaticon-investment"></i>-->
                                    <!--</div>-->
                                </div>
                                <div class="services__content">
                                    <h3 class="title"><a href="retained-search">Executive or C-Suite Hire </br><br>  </a></h3>
                                    <p>Secure transformative C-suite leaders through a bespoke, research-backed methodology designed for your most critical strategic mandates.</p>
                                    <a href="retained-search" class="link-btn">Read More <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                                </div>
                                <div class="services__item-shape">
                                    <img src="assets/img/services/services_item_shape.svg" alt="shape">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="services__item shine__animate-item">
                                <div class="services__thumb shine__animate-link">
                                    <a href="contingent-search"><img src="assets/img/homepage/contingent-search-hp.jpg" alt="img"></a>
                                    <!--<div class="services__icon">-->
                                    <!--    <i class="flaticon-report"></i>-->
                                    <!--</div>-->
                                </div>
                                <div class="services__content">
                                    <h3 class="title"><a href="contingent-search"> Contingent Search(Succuss Based mid to Senior/ Commitment & Exclusivity) </a></h3>
                                    <p>Accelerate hiring for mid-to-senior roles with our risk-free, success-based model that prioritizes speed without compromising on quality.</p>
                                    <a href="#" class="link-btn">Read More <img src="assets/img/icons/right_arrow.svg" alt="contingent-search" class="injectable"></a>
                                </div>
                                <div class="services__item-shape">
                                    <img src="assets/img/services/services_item_shape.svg" alt="shape">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="services__item shine__animate-item">
                                <div class="services__thumb shine__animate-link">
                                    <a href="rpo"><img src="assets/img/homepage/rpo-hp.jpg" alt="img"></a>
                                    <!--<div class="services__icon">-->
                                    <!--    <i class="flaticon-target"></i>-->
                                    <!--</div>-->
                                </div>
                                <div class="services__content">
                                    <h3 class="title"><a href="rpo"> RPO (Recruitment Process Outsourcing)<br></a></h3>
                                    <p>We act as an extension of your HR team, managing the entire acquisition lifecycle to reduce cost-per-hire and improve scalability.</p> </br>
                                    <a href="rpo" class="link-btn">Read More <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                                </div>
                                <div class="services__item-shape">
                                    <img src="assets/img/services/services_item_shape.svg" alt="shape">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="services__item shine__animate-item">
                                <div class="services__thumb shine__animate-link">
                                    <a href="staffing"><img src="assets/img/homepage/staffing-hp-1.jpg" alt="img"></a>
                                    <!--<div class="services__icon">-->
                                    <!--    <i class="flaticon-accountant"></i>-->
                                    <!--</div>-->
                                </div>
                                <div class="services__content">
                                    <h3 class="title"><a href="staffing">Staffing<br><br><br></a></h3>
                                    <p>lexible workforce solutions providing immediate access to pre-vetted professionals for project-based needs and seasonal peaks.</p>
                                    <a href="staffing" class="link-btn">Read More <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                                </div>
                                <div class="services__item-shape">
                                    <img src="assets/img/services/services_item_shape.svg" alt="shape">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="services__shape-wrap">
                <img src="assets/img/services/services_shape01.svg" alt="shape" data-aos="fade-down-left" data-aos-delay="400">
                <img src="assets/img/services/services_shape02.svg" alt="shape" data-aos="fade-up-right" data-aos-delay="400">
            </div>
        </section>
        <!-- services-area-end -->
        
        <!-- global-presence-area -->
        <section class="history__area section-py-130">
            <div class="container">
                <div class="row justify-content-center flex-row-reverse">
                    <div class="col-lg-6 col-md-10">
                        <div class="history__img-wrap">
                            <img src="assets/img/global-presence/our-gp.jpg" alt="Global Presence" style="width:60%; height:auto; display:block; margin:0 auto;">
                            <!--<img src="assets/img/images/history_img02.jpg" alt="Global Presence Image 2" data-aos="fade-up" data-aos-delay="400">-->
                            <!--<img src="assets/img/images/history_shape.svg" alt="shape" class="shape" data-aos="fade-down-right" data-aos-delay="400">-->
                            <!--<div class="satisfied__clients-wrap" data-parallax='{"x" : -30 }'>-->
                            <!--    <span class="title">International Network</span>-->
                            <!--    <img src="assets/img/images/cleint_img.png" alt="img">-->
                            <!--</div>-->
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="history__content">
                            <div class="section__title mb-20">
                                <span class="sub-title">Expanding Our Horizons</span>
                                <h2 class="title">Our Global Presence</h2>
                            </div>
                            <p>As a part of our growth strategy to expand further we have partnered with Lense & Lumen Advisory Group an International Executive Search Network Group. Lense & Lumen’s expertise and commitment will enrich ASPPL to strengthen and expand our international reach.</p>
                            <div class="about__content-bottom mt-30">
                                <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/global-presence" class="tg-btn">Read More <img src="assets/img/icons/right_arrow.svg" alt="arrow" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- global-presence-area-end -->

        <!-- cta-area -->
        <section class="cta__area">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-8">
                        <div class="cta__content">
                            <div class="section__title white-title">
                                <h2 class="title">Let’s discuss about how we can help make your business better!</h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="cta__btn">
                            <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/contact" class="tg-btn tg-hover-btn">Let’s Make a Schedule <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="cta__shape-wrap">
                <img src="assets/img/images/cta_shape01.svg" alt="shape" data-aos="fade-up-right" data-aos-delay="400">
                <img src="assets/img/images/cta_shape02.svg" alt="shape" data-aos="fade-up" data-aos-delay="400">
                <img src="assets/img/images/cta_shape03.svg" alt="shape">
            </div>
        </section>
        <!-- cta-area-end -->
        
        <!-- small-timeline-area -->
        <section class="small-timeline-section section-py-130" style="background-color: #ffffff; padding: 80px 0;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <div class="section__title text-center mb-60" style="margin-bottom: 80px;">
                    <span class="sub-title" style="display: block; color: #4facfe; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 10px;">Our Journey of Growth</span>
                    <h2 class="title" style="font-size: 36px; font-weight: 700; color: #333;">Key Milestones</h2>
                </div>
            </div>
        </div>

        <div class="custom-timeline-wrapper" style="position: relative; padding: 40px 0; max-width: 1100px; margin: 0 auto;">
            
            <div style="position: absolute; top: 50%; left: 0; width: 100%; height: 6px; background: linear-gradient(90deg, #4facfe 0%, #7c5cf7 25%, #f75c5c 50%, #00c9a7 75%, #ffa600 100%); transform: translateY(-50%); border-radius: 4px; z-index: 0;"></div>

            <div style="display: flex; justify-content: space-between; align-items: center; position: relative; z-index: 1;">

                <div class="custom-milestone-step" style="width: 20%; position: relative; text-align: center; padding: 0 10px;">
                    <div style="margin-bottom: 20px;">
                        <h5 style="color: #4facfe; font-weight: 700; font-size: 18px; margin: 0;">2010 - 2011</h5>
                    </div>
                    
                    <div style="position: relative; height: 80px; display: flex; align-items: center; justify-content: center; margin-bottom: 40px;">
                        <div style="width: 50px; height: 50px; background: white; border: 4px solid #4facfe; border-radius: 50% 50% 50% 0; transform: rotate(-45deg); position: absolute; top: 0; box-shadow: 0 5px 15px rgba(79, 172, 254, 0.3);"></div>
                        <div style="position: absolute; top: 12px; font-size: 20px; color: #4facfe; z-index: 2;">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 18h6"/><path d="M10 22h4"/><path d="M15.09 16.96A7 7 0 0 0 21 12.5a9 9 0 1 0-18 0 7 7 0 0 0 5.91 4.46"/><path d="M8.5 10a2.5 2.5 0 0 1 5 0"/></svg>
                        </div>
                    </div>

                    <div style="width: 16px; height: 16px; background: white; border: 4px solid #4facfe; border-radius: 50%; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 2;"></div>

                    <div style="margin-top: 40px;">
                        <p style="font-size: 14px; color: #666; line-height: 1.5;">Founded and achieved breakeven in the first year.</p>
                    </div>
                </div>

                <div class="custom-milestone-step" style="width: 20%; position: relative; text-align: center; padding: 0 10px; margin-top: -5px;">
                    <div style="margin-bottom: 45px;">
                        <p style="font-size: 14px; color: #666; line-height: 1.5;">Expanded to Mumbai & Delhi, reaching 500 placements.</p>
                    </div>

                    <div style="width: 16px; height: 16px; background: white; border: 4px solid #7c5cf7; border-radius: 50%; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 2;"></div>

                    <div style="position: relative; height: 80px; display: flex; align-items: flex-end; justify-content: center; margin-top: 25px;">
                         <div style="width: 50px; height: 50px; background: white; border: 4px solid #7c5cf7; border-radius: 50% 50% 50% 0; transform: rotate(135deg); position: absolute; bottom: 0; box-shadow: 0 5px 15px rgba(124, 92, 247, 0.3);"></div>
                         <div style="position: absolute; bottom: 12px; font-size: 20px; color: #7c5cf7; z-index: 2;">
                             <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 10c0 6-8 12-8 12s-8-6-8-12a8 8 0 0 1 16 0Z"/><circle cx="12" cy="10" r="3"/></svg>
                         </div>
                    </div>

                    <div style="margin-top: 20px;">
                        <h5 style="color: #7c5cf7; font-weight: 700; font-size: 18px; margin: 0;">2012 - 2014</h5>
                    </div>
                </div>

                <div class="custom-milestone-step" style="width: 20%; position: relative; text-align: center; padding: 0 10px;">
                    <div style="margin-bottom: 20px;">
                        <h5 style="color: #f75c5c; font-weight: 700; font-size: 18px; margin: 0;">2018 - 2020</h5>
                    </div>
                    
                    <div style="position: relative; height: 80px; display: flex; align-items: center; justify-content: center; margin-bottom: 40px;">
                        <div style="width: 50px; height: 50px; background: white; border: 4px solid #f75c5c; border-radius: 50% 50% 50% 0; transform: rotate(-45deg); position: absolute; top: 0; box-shadow: 0 5px 15px rgba(247, 92, 92, 0.3);"></div>
                        <div style="position: absolute; top: 12px; font-size: 20px; color: #f75c5c; z-index: 2;">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="20" x2="12" y2="10"/><line x1="18" y1="20" x2="18" y2="4"/><line x1="6" y1="20" x2="6" y2="16"/></svg>
                        </div>
                    </div>

                    <div style="width: 16px; height: 16px; background: white; border: 4px solid #f75c5c; border-radius: 50%; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 2;"></div>

                    <div style="margin-top: 40px;">
                        <p style="font-size: 14px; color: #666; line-height: 1.5;">Launched RPO, joined CII, and navigated the pandemic.</p>
                    </div>
                </div>

                <div class="custom-milestone-step" style="width: 20%; position: relative; text-align: center; padding: 0 10px; margin-top: -5px;">
                    <div style="margin-bottom: 45px;">
                        <p style="font-size: 14px; color: #666; line-height: 1.5;">Achieved Pan India Presence with 6 Regional offices and 40+ full time associates</p>
                    </div>

                    <div style="width: 16px; height: 16px; background: white; border: 4px solid #00c9a7; border-radius: 50%; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 2;"></div>

                    <div style="position: relative; height: 80px; display: flex; align-items: flex-end; justify-content: center; margin-top: 25px;">
                         <div style="width: 50px; height: 50px; background: white; border: 4px solid #00c9a7; border-radius: 50% 50% 50% 0; transform: rotate(135deg); position: absolute; bottom: 0; box-shadow: 0 5px 15px rgba(0, 201, 167, 0.3);"></div>
                         <div style="position: absolute; bottom: 12px; font-size: 20px; color: #00c9a7; z-index: 2;">
                             <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M22 21v-2a4 4 0 0 0-3-3.87"/><path d="M16 3.13a4 4 0 0 1 0 7.75"/></svg>
                         </div>
                    </div>

                    <div style="margin-top: 20px;">
                        <h5 style="color: #00c9a7; font-weight: 700; font-size: 18px; margin: 0;">2020 - 2021</h5>
                    </div>
                </div>

                <div class="custom-milestone-step" style="width: 20%; position: relative; text-align: center; padding: 0 10px;">
                    <div style="margin-bottom: 20px;">
                        <h5 style="color: #ffa600; font-weight: 700; font-size: 18px; margin: 0;">2025</h5>
                    </div>
                    
                    <div style="position: relative; height: 80px; display: flex; align-items: center; justify-content: center; margin-bottom: 40px;">
                        <div style="width: 50px; height: 50px; background: white; border: 4px solid #ffa600; border-radius: 50% 50% 50% 0; transform: rotate(-45deg); position: absolute; top: 0; box-shadow: 0 5px 15px rgba(255, 166, 0, 0.3);"></div>
                        <div style="position: absolute; top: 12px; font-size: 20px; color: #ffa600; z-index: 2;">
                             <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><line x1="2" y1="12" x2="22" y2="12"/><path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"/></svg>
                        </div>
                    </div>

                    <div style="width: 16px; height: 16px; background: white; border: 4px solid #ffa600; border-radius: 50%; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 2;"></div>

                    <div style="margin-top: 40px;">
                        <p style="font-size: 14px; color: #666; line-height: 1.5;">Achieved Global Presence with L&L Alliance</p>
                    </div>
                </div>

            </div>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-auto">
                <div class="about__content-bottom text-center" style="margin-top: 60px !important;">
                    <a href="<?php echo isset($projectBasePath) ? escape_html($projectBasePath) : ""; ?>/about#full-timeline" class="tg-btn" style="background: #b93131; color: #fff; padding: 15px 40px; border-radius: 50px; text-decoration: none; font-weight: 700; font-size: 18px; display: inline-flex; align-items: center; box-shadow: 0 4px 15px rgba(185, 49, 49, 0.3);">
                        Discover Our Full Story
                        <img src="assets/img/icons/right_arrow.svg" alt="arrow" class="injectable" style="margin-left: 10px; filter: brightness(0) invert(1); width: 20px;">
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
        <!-- small-timeline-area-end -->

        <!-- history-area -->
        <section class="history__area section-py-130">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6 col-md-10">
                        <div class="history__img-wrap">
                            <img src="assets/img/homepage/large-hp.jpg" alt="img">
                            <img src="assets/img/homepage/small-274-299-hp.jpg" alt="img" data-aos="fade-up" data-aos-delay="400">
                            <img src="assets/img/images/history_shape.svg" alt="shape" class="shape" data-aos="fade-down-right" data-aos-delay="400">
                            <div class="satisfied__clients-wrap" data-parallax='{"x" : -30 }'>
                                <span class="title">Satisfied Clients</span>
                                <img src="assets/img/images/cleint_img.png" alt="img">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="history__content">
                            <div class="section__title mb-20">
                                <h2 class="title">Understand the ASPPL Way.</h2>
                            </div>
                            <p>At ASPPL, we redefine the hiring landscape by looking beyond the resume. Our approach fuses data-driven market intelligence with deep psychological insights to ensure every candidate is not just a technical match, but a cultural catalyst for your organization. From the first handshake to the final offer, our process is transparent, rigorous, and dedicated to long-term retention.</p>
                            <div class="progress__wrap">
                                <div class="progress__item">
                                    <h6 class="title">USP / Core Values & Ethics</h6>
                                    <div class="progress" role="progressbar" aria-label="Example with label" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100">
                                        <div class="progress-bar wow slideInLeft" data-wow-delay=".2s" style="width: 100%"></div>
                                    </div>
                                </div>
                                <div class="progress__item">
                                    <h6 class="title">Methodology</h6>
                                    <div class="progress" role="progressbar" aria-label="Example with label" aria-valuenow="76" aria-valuemin="0" aria-valuemax="100">
                                        <div class="progress-bar wow slideInLeft" data-wow-delay=".2s" style="width: 100%"></div>
                                    </div>
                                </div>
                                <div class="progress__item">
                                    <h6 class="title">Sourcing Methods</h6>
                                    <div class="progress" role="progressbar" aria-label="Example with label" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100">
                                        <div class="progress-bar wow slideInLeft" data-wow-delay=".2s" style="width: 100%"></div>
                                    </div>
                                </div>
                                <div class="progress__item">
                                    <h6 class="title">Assessments / Concepts</h6>
                                    <div class="progress" role="progressbar" aria-label="Example with label" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100">
                                        <div class="progress-bar wow slideInLeft" data-wow-delay=".2s" style="width: 100%"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- history-area-end -->

        <!-- counter-area -->
        <!--<section class="counter__area">-->
        <!--    <div class="container">-->
        <!--        <div class="counter__wrap">-->
        <!--            <div class="row">-->
        <!--                <div class="col-lg-3 col-6">-->
        <!--                    <div class="counter__item">-->
        <!--                        <h2 class="count"><span class="odometer" data-count="95"></span>%</h2>-->
        <!--                        <p>Success Rate</p>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="col-lg-3 col-6">-->
        <!--                    <div class="counter__item">-->
        <!--                        <h2 class="count"><span class="odometer" data-count="23"></span>K</h2>-->
        <!--                        <p>Complete Projects</p>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="col-lg-3 col-6">-->
        <!--                    <div class="counter__item">-->
        <!--                        <h2 class="count"><span class="odometer" data-count="11"></span>K</h2>-->
        <!--                        <p>Satisfied Clients</p>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="col-lg-3 col-6">-->
        <!--                    <div class="counter__item">-->
        <!--                        <h2 class="count"><span class="odometer" data-count="620"></span>+</h2>-->
        <!--                        <p>Trade In The World</p>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="counter__shape">-->
        <!--        <img src="assets/img/images/counter__shape.svg" alt="shape" data-aos="fade-up-left" data-aos-delay="400">-->
        <!--    </div>-->
        <!--</section>-->
        <!-- counter-area-end -->

        <!-- video-area -->
        <!--<section class="video__area">-->
        <!--    <div class="video__bg" data-background="assets/img/bg/video_bg.webp"></div>-->
        <!--    <div class="container">-->
        <!--        <div class="row align-items-center">-->
        <!--            <div class="col-lg-5 order-0 order-lg-2">-->
        <!--                <div class="video__btn">-->
        <!--                    <a href="https://www.youtube.com/watch?v=6mkoGSqTqFI" class="play__btn popup-video"><img src="assets/img/images/play_video.svg" alt=""></a>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--            <div class="col-lg-7">-->
        <!--                <div class="video__content">-->
        <!--                    <span class="sub-title">Let’s Make A Tour</span>-->
        <!--                    <h2 class="title">Offering The Best Experience Of Business Consulting</h2>-->
        <!--                    <p>Transform your business with our transforeive consulting solution We go beyond short-term fixes to deliver.</p>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</section>-->
        <!-- video-area-end -->

        <!-- project-area -->
        <!--<section class="project__area section-py-130 project__bg" data-background="assets/img/bg/project_bg.jpg">-->
        <!--    <div class="container">-->
        <!--        <div class="row justify-content-center">-->
        <!--            <div class="col-xl-6 col-lg-8">-->
        <!--                <div class="section__title text-center mb-50">-->
        <!--                    <span class="sub-title">Our Working Portfolio</span>-->
        <!--                    <h2 class="title">Exploring Our Most Impactful Case Studies For You</h2>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="swiper-container project-active fix">-->
        <!--        <div class="swiper-wrapper">-->
        <!--            <div class="swiper-slide">-->
        <!--                <div class="project__item">-->
        <!--                    <div class="project__thumb">-->
        <!--                        <img src="assets/img/project/project_img01.jpg" alt="img">-->
        <!--                    </div>-->
        <!--                    <div class="project__content">-->
        <!--                        <div class="project__content-left">-->
        <!--                            <span>Business Strategy</span>-->
        <!--                            <h2 class="title"><a href="project-details.html">10x Business Growth</a></h2>-->
        <!--                        </div>-->
        <!--                        <div class="project__content-arrow">-->
        <!--                            <a href="project-details.html"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--            <div class="swiper-slide">-->
        <!--                <div class="project__item">-->
        <!--                    <div class="project__thumb">-->
        <!--                        <img src="assets/img/project/project_img02.jpg" alt="img">-->
        <!--                    </div>-->
        <!--                    <div class="project__content">-->
        <!--                        <div class="project__content-left">-->
        <!--                            <span>Business Strategy</span>-->
        <!--                            <h2 class="title"><a href="project-details.html">Build Financial Company</a></h2>-->
        <!--                        </div>-->
        <!--                        <div class="project__content-arrow">-->
        <!--                            <a href="project-details.html"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--            <div class="swiper-slide">-->
        <!--                <div class="project__item">-->
        <!--                    <div class="project__thumb">-->
        <!--                        <img src="assets/img/project/project_img03.jpg" alt="img">-->
        <!--                    </div>-->
        <!--                    <div class="project__content">-->
        <!--                        <div class="project__content-left">-->
        <!--                            <span>Finance Strategy</span>-->
        <!--                            <h2 class="title"><a href="project-details.html">Finance Success</a></h2>-->
        <!--                        </div>-->
        <!--                        <div class="project__content-arrow">-->
        <!--                            <a href="project-details.html"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--            <div class="swiper-slide">-->
        <!--                <div class="project__item">-->
        <!--                    <div class="project__thumb">-->
        <!--                        <img src="assets/img/project/project_img04.jpg" alt="img">-->
        <!--                    </div>-->
        <!--                    <div class="project__content">-->
        <!--                        <div class="project__content-left">-->
        <!--                            <span>Business Strategy</span>-->
        <!--                            <h2 class="title"><a href="project-details.html">Custom UX Design</a></h2>-->
        <!--                        </div>-->
        <!--                        <div class="project__content-arrow">-->
        <!--                            <a href="project-details.html"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="project__nav-wrap">-->
        <!--            <button class="project-button-prev">-->
        <!--                <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable">-->
        <!--            </button>-->
        <!--            <button class="project-button-next">-->
        <!--                <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable">-->
        <!--            </button>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</section>-->
        <!-- project-area-end -->

        <!-- founders-area -->
        <?php
            $founders = $db->select("SELECT id, name, designation, image_list, facebook_url, twitter_url, instagram_url, linkedin_url FROM founders WHERE status = '1' ORDER BY sort_order ASC, id DESC");
        ?>
        <?php if (!empty($founders)): ?>
            <section class="team__area fix section-py-130 mb-5">
                <div class="container">
                    <!-- Section Header -->
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="section__title white-title mb-50 mb-md-30">
                                <h2 class="title">Meet our <br> Founders</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="section__content white-content mb-50">
                                <p>Our founders are the pillars behind ASPPL’s vision and growth. Meet the leaders who built the foundation of excellence.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Founders Cards -->
                    <div class="row gutter-y-30 justify-content-center">
                        <?php if (!empty($founders)): ?>
                            <?php foreach ($founders as $founder): ?>

                                <?php
                                    $founderId = (int) $founder['id'];
                                    $founderName = escape_html($founder['name']);
                                    $founderDesignation = escape_html($founder['designation']);

                                    // Use default image if empty
                                    $founderImage = !empty($founder['image_list'])
                                        ? "admin/" . escape_html($founder['image_list'])
                                        : "";

                                    // Social URLs
                                    $socialLinks = [
                                        "facebook"  => trim($founder["facebook_url"]),
                                        "twitter"   => trim($founder["twitter_url"]),
                                        "instagram" => trim($founder["instagram_url"]),
                                        "linkedin"  => trim($founder["linkedin_url"]),
                                    ];

                                    // Social icon map
                                    $socialIcons = [
                                        "facebook"  => "assets/img/icons/facebook.svg",
                                        "twitter"   => "assets/img/icons/twitter.svg",
                                        "instagram" => "assets/img/icons/instagram.svg",
                                        "linkedin"  => "assets/img/icons/linkedin.svg",
                                    ];
                                ?>

                                <div class="col-xl-3 col-lg-4 col-md-6">
                                    <div class="team__item">

                                        <!-- Founder Image -->
                                        <div class="team__thumb">
                                            <img src="<?= $founderImage ?>" alt="<?= $founderName ?>">
                                        </div>

                                        <!-- Founder Name & Designation -->
                                        <div class="team__content">
                                            <h2 class="title">
                                                <a href="founder-details?id=<?= $founderId ?>">
                                                    <?= $founderName ?>
                                                </a>
                                            </h2>
                                            <span><?= $founderDesignation ?></span>
                                        </div>

                                        <!-- Social Icons -->
                                        <div class="team__social">
                                            <div class="social-toggle-icon">
                                                <i class="fas fa-share-alt"></i>
                                            </div>

                                            <ul class="list-wrap">
                                                <?php foreach ($socialLinks as $key => $url): ?>
                                                    <?php if (!empty($url)): ?>
                                                        <li>
                                                            <a href="<?= escape_html($url) ?>" target="_blank" rel="noopener noreferrer">
                                                                <img src="<?= $socialIcons[$key] ?>" class="injectable" alt="<?= $key ?>">
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>

                                        <div class="team__shape">
                                            <img src="assets/img/team/team_shape.svg" alt="shape">
                                        </div>

                                    </div>
                                </div>

                            <?php endforeach; ?>
                        <?php else: ?>

                            <!-- No Founders Fallback -->
                            <div class="col-lg-12 text-center text-white">
                                <p>No founder profiles found.</p>
                            </div>

                        <?php endif; ?>
                    </div>

                </div>

                <!-- Background shapes -->
                <div class="team__shape-wrap">
                    <img src="assets/img/team/team_shape01.svg" alt="shape" data-aos="fade-down-left" data-aos-delay="400">
                    <img src="assets/img/team/team_shape02.svg" alt="shape" data-aos="fade-up-right" data-aos-delay="400">
                    <img src="assets/img/team/team_shape03.svg" alt="shape" class="rightToLeft">
                </div>
            </section>
        <?php endif; ?>
        <!-- founders-area-end -->
        
        <!-- sector-presence-area -->
        <section class="sector__presence mb-5 pb-5">
            <div class="container">
        
                <!-- Section Title -->
                <div class="row justify-content-center">
                    <div class="col-xl-8 col-lg-10">
                        <div class="section__title text-center mb-60">
                            <span class="sub-title">Our Sector Presence</span>
                            <h2 class="title">Sector Presence & Business Split</h2>
                        </div>
                    </div> 
                </div>
        
                <div class="row align-items-center justify-content-center"> 
        
                    <!-- LEFT SIDE — CONTENT -->
                    <div class="col-lg-6 col-md-10">
                        <div class="sector__content">
        
                            <h3 class="mb-4">Business Split Overview</h3>
        
                            <ul class="list-wrap sector-tick-list">
        
                                <li>
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none"> <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/> </svg>
                                    Engineering & Manufacturing
                                </li>
        
                                <li>
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none"> <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/> </svg>
                                    Automotive
                                </li>
        
                                <li>
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none"> <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/> </svg>
                                    Electronics & Hardware
                                </li>
        
                                <li>
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none"> <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/> </svg>
                                    Energy & Power
                                </li>
        
                                <li>
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none"> <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/> </svg>
                                    Semiconductor
                                </li>
        
                                <li>
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none"> <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/> </svg>
                                    EPC & Construction
                                </li>
        
                                <li>
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none"> <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/> </svg>
                                    Chemicals, Oil & Gas
                                </li>
        
                                <li>
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none"> <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/> </svg>
                                    Consumer | FMCG | Retail | Distribution
                                </li>
        
                                <li>
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none"> <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/> </svg>
                                    Financial Services | Private Equity
                                </li>
        
                            </ul>
        
                        </div>
                    </div>
        
                    <!-- RIGHT SIDE — PIE CHART -->
                    <div class="col-lg-6 col-md-10 text-center mt-5 mt-lg-0">
                        <img src="assets/img/business-verticals/sector-presence-1.png" 
                             alt="Sector Pie Chart" 
                             class="img-fluid rounded shadow-lg">
                    </div>
        
                </div>
        
            </div>
        </section>
        <!-- sector-presence-area-end -->
        
        <!-- core-values-area -->
        <section class="work__area-three mb-5 pt-4 pb-5">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-6 col-md-10">
                        <div class="work__thumb">
                            <img src="assets/img/business-verticals/core-values.jpg" alt="Our Core Values">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="work__content-three">
                            <div class="section__title mb-25">
                                <h2 class="title">Our USP / Core Value & Ethics</h2>
                            </div>
                            
                            <h4> Key Differentiators </h4>
                            <br>
                            <ul class="work__list-wrap list-wrap" style="margin-bottom: 40px;">
                                <li>
                                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/>
                                    </svg>
                                    Our searches are tied to our client's vision and corporate strategy.
                                </li>
                                <li>
                                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/>
                                    </svg>
                                    We are partner-led, partner-driven, and completely hands-on.
                                </li>
                                <li>
                                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/>
                                    </svg>
                                    Highly Dependable and Result Oriented Approach
                                </li>
                            </ul>

                            <h4> Our Belief </h4>
                            <div style="font-size: 20px; line-height: 1.6; margin-top: 15px;">
                                "The fundamental principle of economic activity is that no man you transact with will lose, then you shall not."
                            </div>
                            <div style="font-size: 16px; text-align: right; font-style: italic;">
                                - An excerpt from Arthashastra
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- core-values-area-end -->
        
        <!-- Case-Study-area -->
<section class="project__area section-py-130 project__bg" style="background-color: #01022e;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-8">
                <div class="section__title text-center mb-50">
                    <span class="sub-title" style="color: #ffffff;">Success Stories</span>
                    <h2 class="title" style="color: #ffffff;">Exploring Our Most Impactful Case Studies</h2>
                </div>
            </div>
        </div>
    </div>
    <div class="swiper-container project-active fix">
        <div class="swiper-wrapper">
            
            <div class="swiper-slide">
                <div class="project__item">
                    <div class="project__thumb">
                        <img src="assets/img/case-study/case-study.jpg" alt="Executive Search MD Placement">
                    </div>
                    <div class="project__content">
                        <div class="project__content-left">
                            <span>Executive Search (Automotive)</span>
                            <h2 class="title"><a href="case-study.php">Securing an MD for US Tier-1 Giant</a></h2>
                        </div>
                        <div class="project__content-arrow">
                            <a href="case-study.php"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                        </div>
                    </div>
                </div>
            </div>

            </div>
        <div class="project__nav-wrap">
            <button class="project-button-prev">
                <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable">
            </button>
            <button class="project-button-next">
                <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable">
            </button>
        </div>
    </div>
</section>
        
        
        <!-- Case-Study-area -->
        

        <!-- testimonial-area -->
        <?php
            $testimonials = $db->select("SELECT name, designation, description, image, rating FROM testimonials WHERE status = '1' ORDER BY id DESC LIMIT 5");
            
            if (!empty($testimonials)):
        ?>
            <section class="testimonial__area fix py-lg-5">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-10">
                            <div class="testimonial__wrap">
                                <div class="swiper-container fix testimonial-active">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($testimonials as $testimonial): ?>
                                            <?php
                                                $authorName = isset($testimonial['name']) ? escape_html($testimonial['name']) : '';
                                                $authorDesignation = isset($testimonial['designation']) ? escape_html($testimonial['designation']) : '';
                                                $testimonialText = isset($testimonial['description']) ? strip_tags($testimonial['description']) : '';
                                                $authorImage = isset($testimonial['image']) && $testimonial['image'] !== '' ? "admin/" . escape_html($testimonial['image']) : '';
                                                $testimonialRating = isset($testimonial['rating']) ? (int)$testimonial['rating'] : 5;
                                            ?>
                                            <div class="swiper-slide">
                                                <div class="testimonial__item">
                                                    <div class="testimonial__icon">
                                                        <img src="assets/img/icons/quote.svg" alt="icon" class="injectable">
                                                    </div>
                                                    <div class="testimonial__content">
                                                        <p>“<?= $testimonialText ?>”</p>
                                                        <div class="testimonial__rating">
                                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                                <i class="fas fa-star" <?php if ($i > $testimonialRating) echo 'style="color: #d8d8d8;"'; ?>></i>
                                                            <?php endfor; ?>
                                                        </div>
                                                        <div class="testimonial__content-bottom">
                                                            <h4 class="title"><?= $authorName ?></h4>
                                                            <span><?= $authorDesignation ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>

                                <!-- This is the navigation slider with author images -->
                                <div class="swiper testimonial__nav">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($testimonials as $testimonial): ?>
                                            <?php
                                                $authorImage = isset($testimonial['image']) && $testimonial['image'] !== '' ? "admin/" . escape_html($testimonial['image']) : '';
                                            ?>
                                            <div class="swiper-slide">
                                                <button><img src="<?= $authorImage ?>" alt="img"></button>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>

                                <!-- Navigation Arrows -->
                                <div class="testimonial__nav-two">
                                    <button class="testimonial-button-prev"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></button>
                                    <button class="testimonial-button-next"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="testimonial__shape-wrap">
                    <img src="assets/img/images/testi_shape01.svg" alt="shape">
                    <img src="assets/img/images/testi_shape02.svg" alt="shape">
                    <img src="assets/img/images/testi_shape03.svg" alt="shape" data-aos="fade-up-right" data-aos-delay="400">
                    <img src="assets/img/images/testi_shape04.svg" alt="shape">
                    <img src="assets/img/images/testi_shape05.svg" alt="shape">
                    <img src="assets/img/images/map.svg" alt="shape" class="big-shape">
                </div>
            </section>
        <?php endif; ?>
        <!-- testimonial-area-end -->

        <!-- blog-post-area -->
        <!--<section class="blog__post-area section-py-130">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="section__title mb-50 mb-md-30">
                            <span class="sub-title">Flexible Pricing Plan</span>
                            <h2 class="title">We’ve offered the best <br> pricing for you</h2>
                        </div>
                    </div>
                    <div class="col-lg-6 mb-50">
                        <div class="section__content">
                            <p>Ever find yourself staring at your computer screen a good consulting slogan to come to mind? Oftentimes.</p>
                        </div>
                    </div>
                </div>
                <div class="row gutter-y-30 justify-content-center">
                    <div class="col-lg-4 col-md-6">
                        <div class="blog__post-item shine__animate-item">
                            <div class="blog__post-thumb shine__animate-link">
                                <a href="blog-details"><img src="assets/img/blog/blog_post01.jpg" alt="img"></a>
                                <div class="blog__post-date">
                                    <span>
                                        <img src="assets/img/icons/calendar.svg" alt="" class="injectable"> Oct 21, 2025
                                    </span>
                                    <div class="shape">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 159 46" fill="none" preserveAspectRatio="none">
                                            <path d="M14.5854 6.5335C16.0365 2.60713 19.7795 0 23.9654 0H159V46H0L14.5854 6.5335Z" fill="currentColor" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="blog__post-content">
                                <a href="blog" class="blog__post-tag">Business</a>
                                <h2 class="title"><a href="blog-details">How To Monitor And Google Core Web Vitals</a></h2>
                                <div class="blog__post-author">
                                    <a href="blog-details"><img src="assets/img/images/testi_avatar01.png" alt="img"></a>
                                    <span>By <a href="blog-details">Doman Smith</a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="blog__post-item shine__animate-item">
                            <div class="blog__post-thumb shine__animate-link">
                                <a href="blog-details"><img src="assets/img/blog/blog_post02.jpg" alt="img"></a>
                                <div class="blog__post-date">
                                    <span>
                                        <img src="assets/img/icons/calendar.svg" alt="" class="injectable"> Oct 21, 2025
                                    </span>
                                    <div class="shape">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 159 46" fill="none" preserveAspectRatio="none">
                                            <path d="M14.5854 6.5335C16.0365 2.60713 19.7795 0 23.9654 0H159V46H0L14.5854 6.5335Z" fill="currentColor" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="blog__post-content">
                                <a href="blog" class="blog__post-tag">Corporate Work</a>
                                <h2 class="title"><a href="blog-details">How To Monitor And Google Core Web Vitals</a></h2>
                                <div class="blog__post-author">
                                    <a href="blog-details"><img src="assets/img/images/testi_avatar02.png" alt="img"></a>
                                    <span>By <a href="blog-details">Doman Smith</a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="blog__post-item shine__animate-item">
                            <div class="blog__post-thumb shine__animate-link">
                                <a href="blog-details"><img src="assets/img/blog/blog_post03.jpg" alt="img"></a>
                                <div class="blog__post-date">
                                    <span>
                                        <img src="assets/img/icons/calendar.svg" alt="" class="injectable"> Oct 21, 2025
                                    </span>
                                    <div class="shape">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 159 46" fill="none" preserveAspectRatio="none">
                                            <path d="M14.5854 6.5335C16.0365 2.60713 19.7795 0 23.9654 0H159V46H0L14.5854 6.5335Z" fill="currentColor" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="blog__post-content">
                                <a href="blog" class="blog__post-tag">consulting</a>
                                <h2 class="title"><a href="blog-details">How To Monitor And Google Core Web Vitals</a></h2>
                                <div class="blog__post-author">
                                    <a href="blog-details"><img src="assets/img/images/testi_avatar03.png" alt="img"></a>
                                    <span>By <a href="blog-details">Doman Smith</a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>-->
        <!-- blog-post-area-end -->

        <!-- call-back-area -->
        <section class="call__back-area fix section-py-130" id="contact-section">
            <div class="container">
                <div class="call__back-wrap">
                    <div class="row align-items-center">
                        <div class="col-lg-7">
                            <div class="call__back-img">
                                <img src="assets/img/homepage/contact-us-hp.jpg" alt="img">
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="call__back-content">
                                <div class="section__title white-title mb-15">
                                    <h2 class="title">Unlock Your Next Growth Sprint Today!</h2>
                                </div>
                                <p>You have the vision; we have the roadmap. Schedule your free consultation to discover untapped opportunities, streamline your operations, and fast-track your path to success.</p>

                                <!-- Flash Message (Bootstrap 5 alert) -->
                                <?php if ($msg = get_flash_message("contact_message")): ?>
                                    <?php 
                                        $cls = 'alert-info';
                                        if ($msg['type'] === 'success') $cls = 'alert-success';
                                        if ($msg['type'] === 'error')   $cls = 'alert-danger';
                                    ?>
                                    <div class="alert <?= $cls ?> alert-dismissible fade show py-2 px-3 small d-flex mt-3"
                                        id="contactAlert">

                                        <?= escape_html($msg['text']) ?>

                                        <button type="button" 
                                            class="btn-close position-absolute end-0 top-50 translate-middle-y pe-3"
                                            data-bs-dismiss="alert"
                                            aria-label="Close"></button>
                                    </div>
                                <?php endif; ?>

                                <!-- Contact Form -->
                                <form action="actions/contact-submit" method="POST" class="call__back-form contact__form">

                                    <!-- Detect which page the form belongs to -->
                                    <input type="hidden" name="page_from" value="index">

                                    <div class="form-grp">
                                        <input type="text" 
                                            name="name" 
                                            placeholder="Name *"
                                            required
                                            value="<?= escape_html(get_flash_message('contact_old_session_name') ?? '') ?>">
                                    </div>

                                    <div class="form-grp">
                                        <input type="email" 
                                            name="email" 
                                            placeholder="E-mail *"
                                            required
                                            value="<?= escape_html(get_flash_message('contact_old_session_email') ?? '') ?>">
                                    </div>

                                    <div class="form-grp">
                                        <input type="text" 
                                            name="subject" 
                                            placeholder="Subject *"
                                            required
                                            value="<?= escape_html(get_flash_message('contact_old_session_subject') ?? '') ?>">
                                    </div>

                                    <div class="form-grp">
                                        <textarea name="message" 
                                                placeholder="Comments *"
                                                required
                                                maxlength="5000"><?= escape_html(get_flash_message('contact_old_session_message') ?? '') ?></textarea>
                                    </div>

                                    <button type="submit" name="contact-form-submit" class="contact-form-submit-btn">Submit Now</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Shapes -->
            <div class="call__back-shape">
                <img src="assets/img/images/call_back_shape01.svg" alt="shape" data-aos="fade-down-right" data-aos-delay="400">
                <img src="assets/img/images/call_back_shape02.svg" alt="shape">
                <img src="assets/img/images/call_back_shape03.svg" alt="shape" class="alltuchtopdown">
                <img src="assets/img/images/call_back_shape04.svg" alt="shape" class="rightToLeft">
                <img src="assets/img/images/call_back_shape05.svg" alt="shape" data-aos="fade-up-left" data-aos-delay="400">
            </div>
        </section>
        <!-- call-back-area-end -->

    </main>
    <!-- main-area-end -->

<?php
// Include the dynamic footer
include 'includes/footer.php';
?>
