<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/PHPMailer/PHPMailer.php';
require_once __DIR__ . '/PHPMailer/SMTP.php';
require_once __DIR__ . '/PHPMailer/Exception.php';

/**
 * Send Email using PHPMailer
 */
function send_email_with_phpmailer(
    $toEmail,
    $toName,
    $subject,
    $htmlBody,
    $fromEmail = 'no-reply@yourdomain.com',
    $fromName = 'Your Website'
) {
    $mail = new PHPMailer(true);

    try {

        // SMTP CONFIG
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'yourgmail@gmail.com';
        $mail->Password   = 'your-app-password';   
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = 587;

        // FROM (Dynamic)
        $mail->setFrom($fromEmail, $fromName);

        // TO (Dynamic)
        $mail->addAddress($toEmail, $toName);

        // SUBJECT (Dynamic)
        $mail->Subject = $subject;

        // HTML EMAIL BODY (Dynamic)
        $mail->isHTML(true);
        $mail->CharSet = 'UTF-8';
        $mail->Body = $htmlBody;

        // SEND
        return $mail->send();

    } catch (Exception $e) {
        if (defined('APP_DEBUG') && APP_DEBUG) {
            error_log("Mailer Error: " . $e->getMessage());
        }
        return false;
    }
}

/**
 * Email Template
 */
function phpmailer_email_template($title, $contentHtml)
{
    $dateTime = date("d M Y, h:i A"); 
    $currentUserIP = $_SERVER['REMOTE_ADDR'] ?? '-';

    return "
    <div style='background:#eef1f7;padding:40px 0;font-family:Arial,sans-serif;'>

        <div style='max-width:600px;margin:auto;background:#ffffff;
                    border-radius:14px;overflow:hidden;
                    box-shadow:0 4px 20px rgba(0,0,0,0.12);'>

            <!-- HEADER -->
            <div style='background:linear-gradient(135deg,#4e73df,#1e3caa);
                        padding:22px 28px;color:#fff;display:flex;
                        justify-content:space-between;align-items:flex-start;'>

                <div style='font-size:22px;font-weight:600;line-height:1.4;'>
                    $title
                </div>

                <div style='font-size:13px;opacity:0.9;text-align:right;line-height:1.4;'>
                    $dateTime<br>
                    <strong>Visitor IP:</strong> $currentUserIP
                </div>
            </div>

            <!-- BODY -->
            <div style='padding:28px;color:#333;font-size:15px;line-height:1.7;'>
                $contentHtml
            </div>

            <!-- NOTE -->
            <div style='margin:0 25px 25px;border-radius:8px;background:#fff4e5;
                        border:1px solid #ffcc8e;padding:18px;'>
                <strong style='color:#d17b00;font-size:14px;'>Important Note:</strong><br>
                <span style='font-size:13px;color:#815300;'>
                    This is an automated email. Please do not reply.
                </span>
            </div>

            <!-- FOOTER -->
            <div style='padding:15px;text-align:center;background:#f8f9fc;
                        border-top:1px solid #e4e6ef;font-size:12px;color:#777;'>
                &copy; " . date("Y") . " Your Website. All rights reserved.
            </div>

        </div>
    </div>
    ";
}