<?php
/**
 * Dynamic Header Include
 * 
 * Handles all HTML head section and header markup
 * Includes CSS files and meta tags
 * 
 * Usage in your page:
 * <?php include 'includes/header.php'; ?>
 */

// Load essentials
require_once __DIR__ . "/config.php";
require_once __DIR__ . "/functions.php";
require_once __DIR__ . "/Database.php";

// Create DB connection (you will use $db everywhere)
$db = new Database();

// Auto-detect base path URL safely (no hardcoding)
@$projectBasePath = rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? ''), '/');
if ($projectBasePath === '.' || $projectBasePath === '/') {
    $projectBasePath = '';
}

// Set page title if not already defined
if (!isset($pageTitle)) {
    $pageTitle = 'ASPPL - Associated Search Professionals Pvt Ltd';
}

// Set page description if not already defined
if (!isset($pageDescription)) {
    $pageDescription = 'ASPPL - Associated Search Professionals Pvt Ltd';
}

// Initialize asset arrays if not already defined
if (!isset($headerCssAndScriptFiles)) {
    $headerCssAndScriptFiles = [
        'css' => [],
        'js'  => [],
    ];
}

// Initialize internal CSS if not already defined
if (!isset($headerInternalCss)) {
    $headerInternalCss = '';
}

// Initialize internal JS if not already defined
if (!isset($headerInternalJs)) {
    $headerInternalJs = '';
}

// Set current page if not already defined
if (!isset($currentPageUrlName)) {
    $currentPageUrlName = '';
}

// Active menu check function
if (!function_exists('isActive')) {
    function isActive($menuName, $currentPageUrlName)
    {
        if (!is_array($menuName)) {
            $menuName = [$menuName];
        }

        foreach ($menuName as $item) {
            if ($item === $currentPageUrlName) {
                return 'active';
            }
            if (strpos($currentPageUrlName, $item) === 0) {
                return 'active';
            }
        }
        return '';
    }
}
?>
<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo isset($pageTitle)? escape_html($pageTitle) : ""; ?></title>
    <meta name="description" content="<?php echo isset($pageDescription)? escape_html($pageDescription) : ""; ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <!-- Place favicon.ico in the root directory -->

    <!-- Default Theme CSS here -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.css">
    <link rel="stylesheet" href="assets/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="assets/css/tg-flaticon.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/default.css">
    <link rel="stylesheet" href="assets/css/default-icons.css">
    <link rel="stylesheet" href="assets/css/odometer.css">
    <link rel="stylesheet" href="assets/css/aos.css">
    <link rel="stylesheet" href="assets/css/tg-cursor.css">
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/common-custom-styles.css">

    <!-- Custom CSS here -->
    <?php
    // Output CSS files
    if (!empty($headerCssAndScriptFiles['css']) && is_array($headerCssAndScriptFiles['css'])) {
        $loadedCss = [];
        foreach ($headerCssAndScriptFiles['css'] as $cssFile) {
            @$cssFile = trim($cssFile);
            
            // Prevent duplicate CSS files
            if (!in_array($cssFile, $loadedCss)) {
                $loadedCss[] = $cssFile;
                
                // Check if it's a CDN link or local file
                if (strpos($cssFile, 'http://') === 0 || strpos($cssFile, 'https://') === 0) {
                    // External CDN link
                    echo '<link rel="stylesheet" href="' . htmlspecialchars($cssFile, ENT_QUOTES, 'UTF-8') . '">' . PHP_EOL . '    ';
                } else {
                    // Local file
                    echo '<link rel="stylesheet" href="' . htmlspecialchars($cssFile, ENT_QUOTES, 'UTF-8') . '">' . PHP_EOL . '    ';
                }
            }
        }
    }
    ?>

    <!-- Custom Internal CSS -->
    <?php
    if (!empty($headerInternalCss)) {
        echo '<style type="text/css">' . PHP_EOL;
        echo $headerInternalCss . PHP_EOL;
        echo '</style>' . PHP_EOL;
    }
    ?>

    <!-- Custom JS in header (rare, use only if needed before body load) -->
    <!-- Custom JS here -->
    <?php
    // Output JavaScript files
    if (!empty($headerCssAndScriptFiles['js']) && is_array($headerCssAndScriptFiles['js'])) {
        $loadedJs = [];
        foreach ($headerCssAndScriptFiles['js'] as $jsFile) {
            @$jsFile = trim($jsFile);
            
            // Prevent duplicate JS files
            if (!in_array($jsFile, $loadedJs)) {
                $loadedJs[] = $jsFile;
                
                // Check if it's a CDN link or local file
                if (strpos($jsFile, 'http://') === 0 || strpos($jsFile, 'https://') === 0) {
                    // External CDN link
                    echo '<script src="' . htmlspecialchars($jsFile, ENT_QUOTES, 'UTF-8') . '"></script>' . PHP_EOL;
                } else {
                    // Local file
                    echo '<script src="' . htmlspecialchars($jsFile, ENT_QUOTES, 'UTF-8') . '"></script>' . PHP_EOL;
                }
            }
        }
    }
    ?>

    <!-- Custom Internal JavaScript -->
    <?php
    if (!empty($headerInternalJs)) {
        echo '<script type="text/javascript">' . PHP_EOL;
        echo $headerInternalJs . PHP_EOL;
        echo '</script>' . PHP_EOL;
    }
    ?>
</head>

<body>

    <!-- preloader -->
    <!--<div class="preloader">
        <div class="preloader-inner">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>-->
    <!-- preloader-end -->

    <!-- Scroll-top -->
    <button class="scroll__top scroll-to-target" data-target="html">
        <i class="fas fa-chevron-up"></i>
    </button>
    <!-- Scroll-top-end-->

    <!-- header-area -->
    <header>
        <!--<div class="tg-header__top">-->
        <!--    <div class="container custom-container">-->
        <!--        <div class="row align-items-center">-->
        <!--            <div class="col-lg-7">-->
        <!--                <div class="tg-header__top-info">-->
        <!--                    <ul class="list-wrap">-->
        <!--                        <li><i class="flaticon-placeholder"></i>#39, 14th Main Road, Gokula 1st Stage, Mathikere Bengaluru - 560 054</li>-->
        <!--                        <li><i class="flaticon-envelope"></i><a href="mailto:careers@asppl.in">careers@asppl.in</a></li>-->
        <!--                    </ul>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--            <div class="col-lg-5">-->
        <!--                <div class="tg-header__top-right">-->
        <!--                    <ul class="list-wrap">-->
        <!--                        <li><i class="flaticon-telephone"></i><a href="tel:+91 234 56789">+91 234 56789</a></li>-->
        <!--                        <li>-->
        <!--                            <div class="tg-header__top-social">-->
        <!--                                <ul class="list-wrap">-->
        <!--                                    <li><a href="https://www.facebook.com/" target="_blank"><img src="assets/img/icons/facebook.svg" alt="" class="injectable"></a></li>-->
        <!--                                    <li><a href="https://x.com/home" target="_blank"><img src="assets/img/icons/twitter.svg" alt="" class="injectable"></a></li>-->
        <!--                                    <li><a href="https://www.linkedin.com/" target="_blank"><img src="assets/img/icons/linkedin.svg" alt="" class="injectable"></a></li>-->
                                            <!--<li><a href="https://www.pinterest.com/" target="_blank"><img src="assets/img/icons/pinterest.svg" alt="" class="injectable"></a></li>-->
        <!--                                </ul>-->
        <!--                            </div>-->
        <!--                        </li>-->
        <!--                    </ul>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
        <div id="header-fixed-height"></div>
        <div id="sticky-header" class="tg-header__area">
            <div class="container custom-container">
                <div class="row">
                    <div class="col-12">
                        <div class="tgmenu__wrap">
                            <nav class="tgmenu__nav">
                                <div class="logo">
                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/"><img src="assets/img/logo/asspl-logo.png" alt="Logo"></a>
                                </div>
                                <div class="tgmenu__navbar-wrap tgmenu__main-menu d-none d-lg-flex">
                                    <ul class="navigation">
                                        <!-- Home -->
                                        <li class="<?php echo isActive('home', $currentPageUrlName); ?>">
                                            <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/">Home</a>
                                        </li>

                                        <!-- About -->
                                        <li class="menu-item-has-children <?php echo isActive(['about','founders','blog'], $currentPageUrlName); ?>">
                                            <a href="#">About</a>

                                            <ul class="sub-menu">
                                                <li class="<?php echo isActive('about', $currentPageUrlName); ?>">
                                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/about">About</a>
                                                </li>

                                                <li class="<?php echo isActive('founders', $currentPageUrlName); ?>">
                                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/founders">Founders</a>
                                                </li>

                                                <!--<li class="menu-item-has-children <?php //echo isActive(['people-culture','annual-conference','international-trips'], $currentPageUrlName); ?>">-->
                                                <!--    <a href="#">Life At Asppl</a>-->

                                                <!--    <ul class="sub-menu">-->
                                                <!--        <li class="<?php //echo isActive('people-culture', $currentPageUrlName); ?>">-->
                                                <!--            <a href="<?php //echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/people-culture">People & Culture</a>-->
                                                <!--        </li>-->

                                                <!--        <li class="<?php //echo isActive('annual-conference', $currentPageUrlName); ?>">-->
                                                <!--            <a href="<?php //echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/annual-conference">Annual Conference</a>-->
                                                <!--        </li>-->

                                                <!--        <li class="<?php //echo isActive('international-trips', $currentPageUrlName); ?>">-->
                                                <!--            <a href="<?php //echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/international-trips">International Trips</a>-->
                                                <!--        </li>-->
                                                <!--    </ul>-->
                                                <!--</li>-->

                                                <!--<li class="<?php //echo isActive('blog', $currentPageUrlName); ?>">-->
                                                <!--    <a href="<?php //echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>">Blog</a>-->
                                                <!--</li>-->
                                            </ul>
                                        </li>

                                        <!-- Services -->
                                        <li class="menu-item-has-children <?php echo isActive(['retained-search','contingent-search','rpo','staffing'], $currentPageUrlName); ?>">
                                            <a href="#">Services</a>

                                            <ul class="sub-menu">
                                                <li class="<?php echo isActive('retained-search', $currentPageUrlName); ?>">
                                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/retained-search">Executive or C-suite hire</a>
                                                </li>

                                                <li class="<?php echo isActive('contingent-search', $currentPageUrlName); ?>">
                                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/contingent-search">Contingent Search</a>
                                                </li>

                                                <li class="<?php echo isActive('rpo', $currentPageUrlName); ?>">
                                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/rpo">Recruitment Process Outsourcing</a>
                                                </li>

                                                <li class="<?php echo isActive('staffing', $currentPageUrlName); ?>">
                                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/staffing">Staffing</a>
                                                </li>
                                            </ul>
                                        </li>

                                        <!-- Active Searches -->
                                        <!--<li class="menu-item-has-children <?php //echo isActive(['active-searches','leadership-fitments','approach','methodology','sourcing-methods','assessments'], $currentPageUrlName); ?>">-->
                                        <!--    <a href="#">Active Searches</a>-->

                                        <!--    <ul class="sub-menu">-->

                                        <!--        <li class="<?php //echo isActive('active-searches', $currentPageUrlName); ?>">-->
                                        <!--            <a href="<?php //echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/active-searches">Active Searches</a>-->
                                        <!--        </li>-->

                                        <!--        <li class="<?php //echo isActive('leadership-fitments', $currentPageUrlName); ?>">-->
                                        <!--            <a href="<?php //echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/leadership-fitments">Leadership Fitments</a>-->
                                        <!--        </li>-->

                                        <!--        <li class="<?php //echo isActive('approach', $currentPageUrlName); ?>">-->
                                        <!--            <a href="<?php //echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/approach">Approach</a>-->

                                                    <!--<ul class="sub-menu">-->
                                                    <!--    <li class="<?php //echo isActive('usp', $currentPageUrlName); ?>">-->
                                                    <!--        <a href="#">USP / Core Values & Ethics</a>-->
                                                    <!--    </li>-->

                                                    <!--    <li class="<?php //echo isActive('methodology', $currentPageUrlName); ?>">-->
                                                    <!--        <a href="#">Methodology</a>-->
                                                    <!--    </li>-->

                                                    <!--    <li class="<?php //echo isActive('sourcing-methods', $currentPageUrlName); ?>">-->
                                                    <!--        <a href="#">Sourcing Methods</a>-->
                                                    <!--    </li>-->

                                                    <!--    <li class="<?php //echo isActive('assessments', $currentPageUrlName); ?>">-->
                                                    <!--        <a href="#">Assessments / Concepts</a>-->
                                                    <!--    </li>-->
                                                    <!--</ul>-->
                                        <!--        </li>-->
                                        <!--    </ul>-->
                                        <!--</li>-->

                                        <!-- Global Presence -->
                                        <li class="<?php echo isActive('global-presence', $currentPageUrlName); ?>">
                                            <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/global-presence">Global Presence</a>
                                        </li>

                                          <!--Business Verticals -->
                                        <!--<li class="menu-item-has-children <?php //echo isActive(['engineering-automative','consumer-goods-fmcg','leadership','energy-process-infrastructure','technology-it','contingent-searches'], $currentPageUrlName); ?>">-->
                                        <!--    <a href="#">Business Verticals</a>-->

                                        <!--    <ul class="sub-menu">-->

                                        <!--        <li class="<?php //echo isActive('engineering-automative', $currentPageUrlName); ?>">-->
                                        <!--            <a href="<?php //echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/engineering-automative">Engineering & Automative</a>-->
                                        <!--        </li>-->

                                        <!--        <li class="<?php //echo isActive('consumer-goods-fmcg', $currentPageUrlName); ?>">-->
                                        <!--            <a href="consumer-goods-fmcg">Consumer Goods & FM CG</a>-->
                                        <!--        </li>-->

                                        <!--        <li class="<?php //echo isActive('leadership', $currentPageUrlName); ?>">-->
                                        <!--            <a href="leadership">Leadership</a>-->
                                        <!--        </li>-->

                                        <!--        <li class="<?php //echo isActive('energy-process-infrastructure', $currentPageUrlName); ?>">-->
                                        <!--            <a href="energy-process-infrastructure">Energy Process & Infrastructure</a>-->
                                        <!--        </li>-->

                                        <!--        <li class="<?php //echo isActive('technology-it', $currentPageUrlName); ?>">-->
                                        <!--            <a href="technology-it">Technology & IT</a>-->
                                        <!--        </li>-->

                                        <!--        <li class="<?php //echo isActive('contingent-searches', $currentPageUrlName); ?>">-->
                                        <!--            <a href="contingent-searches">Contingent Searches</a>-->
                                        <!--        </li>-->

                                        <!--    </ul>-->
                                        <!--</li>-->
                                        
                                        <!--Life At ASPPL-->
                                        <li class="menu-item-has-children <?php echo isActive(['people-culture','annual-conference','international-trips'], $currentPageUrlName); ?>">
                                            <a href="#">Life At ASPPL</a>

                                            <ul class="sub-menu">

                                                <li class="<?php echo isActive('people-culture', $currentPageUrlName); ?>">
                                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/people-culture">People & Culture</a>
                                                </li>

                                                <li class="<?php echo isActive('annual-conference', $currentPageUrlName); ?>">
                                                    <a href="annual-conference">Annual Conference</a>
                                                </li>

                                                <li class="<?php echo isActive('international-trips', $currentPageUrlName); ?>">
                                                    <a href="international-trips">International Trips</a>
                                                </li>

                                            </ul>
                                        </li>

                                    </ul>
                                </div>
                                <div class="tgmenu__action">
                                    <ul class="list-wrap">
                                        <li class="header-btn">
                                            <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/contact" class="tg-btn"> Contact Us</a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="mobile-nav-toggler"><i class="tg-flaticon-menu"></i></div>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile Menu  -->
        <div class="tgmobile__menu">
            <nav class="tgmobile__menu-box">
                <div class="close-btn"><i class="tg-flaticon-close-1"></i></div>
                <div class="nav-logo">
                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/"><img src="assets/img/logo/asspl-logo.png" alt="Logo"></a>
                </div>
                <!--<div class="tgmobile__search">-->
                <!--    <form action="#">-->
                <!--        <input type="text" placeholder="Search here...">-->
                <!--        <button><i class="fas fa-search"></i></button>-->
                <!--    </form>-->
                <!--</div>-->
                <div class="tgmobile__menu-outer">
                    <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                </div>
                <div class="social-links">
                    <ul class="list-wrap">
                        <!--<li><a href="#"><i class="fab fa-facebook-f"></i></a></li>-->
                        <!--<li><a href="#"><i class="fab fa-twitter"></i></a></li>-->
                        <!--<li><a href="#"><i class="fab fa-instagram"></i></a></li>-->
                        <li><a href="https://in.linkedin.com/company/associated-search-professionals-private-limited"><i class="fab fa-linkedin-in"></i></a></li>
                        <!--<li><a href="#"><i class="fab fa-youtube"></i></a></li>-->
                    </ul>
                </div>
            </nav>
        </div>
        <div class="tgmobile__menu-backdrop"></div>
        <!-- End Mobile Menu -->

        <!-- header-search -->
        <div class="search__popup">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="search__wrapper">
                            <div class="search__close">
                                <button type="button" class="search-close-btn">
                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M17 1L1 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                        <path d="M1 1L17 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                    </svg>
                                </button>
                            </div>
                            <div class="search__form">
                                <form action="#">
                                    <div class="search__input">
                                        <input class="search-input-field" type="text" placeholder="Type keywords here">
                                        <span class="search-focus-border"></span>
                                        <button>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M9.55 18.1C14.272 18.1 18.1 14.272 18.1 9.55C18.1 4.82797 14.272 1 9.55 1C4.82797 1 1 4.82797 1 9.55C1 14.272 4.82797 18.1 9.55 18.1Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                <path d="M19.0002 19.0002L17.2002 17.2002" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                            </svg>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="search-popup-overlay"></div>
        <!-- header-search-end -->

        <!-- offCanvas-menu -->
        <div class="offCanvas__info">
            <div class="offCanvas__close-icon menu-close">
                <button><img src="assets/img/icons/times.svg" alt="" class="injectable"></button>
            </div>
            <div class="offCanvas__logo mb-30">
                <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/"><img src="assets/img/logo/asspl-logo.png" alt="Logo"></a>
            </div>
            <div class="offCanvas__content">
                <p>Businorem ipsum dolor sit amet cons interdum quam duis variuy time honored tradition etting .</p>
            </div>
            <div class="offCanvas__img">
                <ul class="list-wrap">
                    <li><a href="javascript:void(0)"><img src="assets/img/images/footer_insta01.jpg" alt="img"></a></li>
                    <li><a href="javascript:void(0)"><img src="assets/img/images/footer_insta02.jpg" alt="img"></a></li>
                    <li><a href="javascript:void(0)"><img src="assets/img/images/footer_insta03.jpg" alt="img"></a></li>
                    <li><a href="javascript:void(0)"><img src="assets/img/images/footer_insta04.jpg" alt="img"></a></li>
                    <li><a href="javascript:void(0)"><img src="assets/img/images/footer_insta05.jpg" alt="img"></a></li>
                    <li><a href="javascript:void(0)"><img src="assets/img/images/footer_insta06.jpg" alt="img"></a></li>
                </ul>
            </div>
            <div class="offCanvas__side-info">
                <div class="contact-list">
                    <i class="flaticon-placeholder"></i>
                    <p>Sydney Harbour Circular City of Sydney,Australia.</p>
                </div>
                <div class="contact-list">
                    <i class="flaticon-telephone"></i>
                    <a href="tel:0123456789">+123 888 9999</a>
                </div>
                <div class="contact-list">
                    <i class="flaticon-envelope"></i>
                    <a href="mailto:info@asppl.com">info@asppl.com</a>
                </div>
            </div>
            <div class="offCanvas__social">
                <h6 class="title">Follow us</h6>
                <ul class="list-wrap">
                    <li><a href="https://www.facebook.com/" target="_blank"><img src="assets/img/icons/facebook.svg" alt="" class="injectable"></a></li>
                    <li><a href="https://x.com/home" target="_blank"><img src="assets/img/icons/twitter.svg" alt="" class="injectable"></a></li>
                    <li><a href="https://www.instagram.com/" target="_blank"><img src="assets/img/icons/instagram.svg" alt="" class="injectable"></a></li>
                    <li><a href="https://www.pinterest.com/" target="_blank"><img src="assets/img/icons/pinterest.svg" alt="" class="injectable"></a></li>
                </ul>
            </div>
        </div>
        <div class="offCanvas__overly"></div>
        <!-- offCanvas-menu-end -->

    </header>
    <!-- header-area-end -->
