<?php

/** 
 * Clean input for safe display in HTML
 * Usage: echo escape_html($value);
 */
function escape_html($value) {
    return htmlspecialchars(trim((string)$value), ENT_QUOTES, 'UTF-8');
}

/**
 * Redirect to a specific page
 * Usage: redirect_to("index.php?page=home");
 */
function redirect_to($url) {
    header("Location: $url");
    exit;
}

/**
 * Store flash message
 * Usage: set_flash_message("success", "Message Saved!");
 */
function set_flash_message($key, $message) {
    $_SESSION[$key] = $message;
}

/**
 * Get & clear flash message
 * Usage:
 * if($msg = get_flash_message("success")) { echo $msg; }
 */
function get_flash_message($key) {
    if (!empty($_SESSION[$key])) {
        $msg = $_SESSION[$key];
        unset($_SESSION[$key]);
        return $msg;
    }
    return null;
}

/**
 * Debug helper
 * Usage: dump($array);
 */
function dump($data) {
    echo "<pre>";
    print_r($data);
    echo "</pre>";
}
