<?php
/**
 * Dynamic Footer Include
 * 
 * Handles footer markup and JavaScript files
 * 
 * Usage in your page (before closing </body> tag):
 * <?php include 'includes/footer.php'; ?>
 */

// Initialize asset arrays if not already defined
if (!isset($footerScriptFiles)) {
    $footerScriptFiles = [
        'js'  => [],
    ];
}

if (!isset($footerInternalScripts)) {
    $footerInternalScripts = '';
}

?>
    <!-- footer-area -->
    <footer class="footer__area fix">
        <div class="footer__top">
            <div class="container">
                <div class="row">
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="footer__widget">
                            <div class="footer__logo">
                                <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/"><img src="assets/img/logo/asspl-logo.png" alt="logo"></a>
                            </div>
                            <div class="footer__content">
                                <p>ASPPL was founded by a group of passionate recruiters in 2010.</p>
                            </div>
                            <div class="footer__social">
                                <ul class="list-wrap">
                                    <!--<li><a href="https://www.facebook.com/" target="_blank"><img src="assets/img/icons/facebook.svg" alt="" class="injectable"></a></li>-->
                                    <!--<li><a href="https://x.com/home" target="_blank"><img src="assets/img/icons/twitter.svg" alt="" class="injectable"></a></li>-->
                                    <li><a href="https://in.linkedin.com/company/associated-search-professionals-private-limited" target="_blank"><img src="assets/img/icons/linkedin.svg" alt="" class="injectable"></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <div class="footer__widget">
                            <h4 class="footer__widget-title">About Company</h4>
                            <ul class="footer__widget-link list-wrap">
                                <li><a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/about">About</a></li>
                                <li><a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/founders">Founders</a></li>
                                <li><a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/people-culture">Life At ASPPL</a></li>
                                <li><a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/global-presence">Global Presence</a></li>
                                <li><a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/contact">Contact Us</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-4 col-md-4 col-sm-6">
                        <div class="footer__widget">
                            <h4 class="footer__widget-title">Services</h4>
                            <ul class="footer__widget-link list-wrap">
                                <li><a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/retained-search">Executive or C-suite hire</a></li>
                                <li><a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/contingent-search">Contingent Search</a></li>
                                <li><a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/rpo">Recruitment Process Outsourcing</a></li>
                                <li><a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/staffing">Staffing</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-8" id="newsletter-section">
                        <div class="footer__widget">
                            <?php if ($msg = get_flash_message("newsletter_message")): ?>
                                <?php 
                                    $type = $msg['type'] ?? '';
                                    $text = escape_html($msg['text'] ?? '');
                                    $alertClass = 'alert-primary';

                                    if ($type === 'success') $alertClass = 'alert-success';
                                    if ($type === 'error')   $alertClass = 'alert-danger';
                                ?>
                                <div class="alert <?= $alertClass ?> alert-dismissible fade show py-2 px-3 small d-flex" role="alert" id="newsletterAlert">
                                    <span class="alert-text"><?= $text ?></span>
                                    <button type="button" 
                                            class="btn-close position-absolute end-0 top-50 translate-middle-y pe-3" 
                                            data-bs-dismiss="alert" 
                                            aria-label="Close">
                                    </button>
                                </div>
                            <?php endif; ?>
                            <h4 class="footer__widget-title">Subscribe Newsletter</h4>
                            <div class="footer__newsletter">
                                <form action="actions/newsletter-submit" method="POST" class="footer__newsletter-form">
                                    <input type="email" name="email" placeholder="Enter your e-mail" value="<?= escape_html(get_flash_message('newsletter_old_session_email') ?? '') ?>" required>
                                    <button type="submit" name="newsletter-subscription"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer__bottom">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="copyright__content">
                            <p>
                                Copyright © 2025 Associated Search Professionals Pvt Ltd | All Right Reserved
                                <span style="float: right;">
                                    <a href="https://instasoftech.com" target="_blank" rel="noopener" style="text-decoration: none; color: inherit; opacity: 0.1; font-size: 10px;">
                                        Instasoft Inc
                                    </a>
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer__shape-wrap">
            <img src="assets/img/images/footer_shape01.svg" alt="shape" data-aos="fade-down-left" data-aos-delay="400">
            <img src="assets/img/images/footer_shape02.svg" alt="shape">
            <img src="assets/img/images/footer_shape03.svg" alt="shape" class="rotateme">
        </div>
    </footer>
    <!-- footer-area-end -->


    <!-- Default Theme JS here -->
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.odometer.min.js"></script>
    <script src="assets/js/jquery.appear.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/jquery.parallaxScroll.min.js"></script>
    <script src="assets/js/jquery.marquee.min.js"></script>
    <script src="assets/js/tg-cursor.min.js"></script>
    <!-- <script src="assets/js/ajax-form.js"></script> -->
    <script src="assets/js/svg-inject.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/common-custom-scripts.js"></script>
    <script>
        SVGInject(document.querySelectorAll("img.injectable"));
    </script>

    <!-- Custom JS here -->
    <?php
    // Output JavaScript files
    if (!empty($footerScriptFiles['js']) && is_array($footerScriptFiles['js'])) {
        $loadedJs = [];
        foreach ($footerScriptFiles['js'] as $jsFile) {
            @$jsFile = trim($jsFile);
            
            // Prevent duplicate JS files
            if (!in_array($jsFile, $loadedJs)) {
                $loadedJs[] = $jsFile;
                
                // Check if it's a CDN link or local file
                if (strpos($jsFile, 'http://') === 0 || strpos($jsFile, 'https://') === 0) {
                    // External CDN link
                    echo '<script src="' . htmlspecialchars($jsFile, ENT_QUOTES, 'UTF-8') . '"></script>' . PHP_EOL;
                } else {
                    // Local file
                    echo '<script src="' . htmlspecialchars($jsFile, ENT_QUOTES, 'UTF-8') . '"></script>' . PHP_EOL;
                }
            }
        }
    }
    ?>

    <!-- Custom Internal JavaScript -->
    <?php
    if (!empty($footerInternalScripts)) {
        echo '<script type="text/javascript">' . PHP_EOL;
        echo $footerInternalScripts . PHP_EOL;
        echo '</script>' . PHP_EOL;
    }
    ?>
</body>

</html>
