<?php
require_once __DIR__ . '/config.php';

class Database {
    private $pdo;
    public function __construct() {
        $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $options = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
        ];
        try {
            $this->pdo = new PDO($dsn, DB_USERNAME, DB_PASSWORD, $options);
        } catch (PDOException $e) {
            // In production don't echo the error
            if (APP_DEBUG) {
                die("DB Connection failed: " . $e->getMessage());
            } else {
                error_log("DB Connection failed: " . $e->getMessage());
                die("Database connection error.");
            }
        }
    }

    // Fetch multiple rows
    public function select($sql, $params = []) {
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    }

    // Fetch single row
    public function selectOne($sql, $params = []) {
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetch();
    }

    // Execute write (INSERT/UPDATE/DELETE) and return boolean
    public function execute($sql, $params = []) {
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute($params);
    }

    // Get last inserted id
    public function lastInsertId() {
        return $this->pdo->lastInsertId();
    }
}
