<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Global Presence - ASPPL';
// $pageDescription = 'Global Presence ASPPL - Associated Search Professionals Pvt Ltd';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'global-presence';

$headerCssAndScriptFiles = [
    'css' => ["assets/css/globalpresencepage-custom-styles.css"],
];

$footerScriptFiles = ['js'  => ["assets/js/globalpresencepage-custom-scripts.js"]];

include 'includes/header.php';
?>
    <!-- main-area -->
    <main class="main-area fix">
        <!-- breadcrumb-area -->
        <section class="breadcrumb__area-two">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="breadcrumb__content breadcrumb__content-two">
                            <h2 class="title">Global Presence </h2>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

        <!-- services-details-area -->
        <div class="services__details-area-two">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="services__details-thumb-two">
                            <img src="assets/img/global-presence/lladvisory.jpg" alt="lladvisorygroup">
                        </div>
                        <div class="services__details-content-two">
                            <p>As a part of our growth strategy to expand further we have partnered with Lense & Lumen Advisory Group an International Executive Search Network Group. Lense & Lumen’s expertise and commitment will enrich ASPPL to strengthen and expand our international reach. Together we want to achieve our goals more successfully and learn from each other to deliver high level services to our clients.</p> </br>
                            <p>Lense & Lumen Advisory Group is co-owned by four independent European Executive Search & HR Consultancy firms that have decided to join their talents and expertise in order to create a new international organisation. These four firms have been working together for many years, leading searches for C- level positions and assisting companies in their international expansion.</p> </br>
                            <p>With members in Belgium, Czech Republic, China, Denmark, France, Germany, Italy, the Netherlands, Norway, South Africa, Spain, Sweden, Switzerland, the UK, and the USA, Lense & Lumen Advisory Group is a network that is already made up of a hundred professionals; our goal is to expand over the next few months to enlarge our international coverage. Through its four founding companies that remain independent, Lense & Lumen Advisory Group will provide seamless Executive Search and HR & Leadership Consulting services. More info @ <a href="https://lladvisorygroup.com/" target="blank" style="color:blue;">www.lladvisorygroup.com</a></p>
                        </div>
                    </div>
                </div>
                <span class="features__divider"></span>
            </div>
        </div>
        <!-- services-details-area-end -->
        
        <!-- lense-lumen-members-slider-area -->
        <?php
            $members = $db->select("
                SELECT * FROM global_presence_members
                WHERE status = 1 
                ORDER BY sort_order ASC, id DESC
            ");
            if (!empty($members)):
        ?>
            <section class="lense-lumen-slider-section">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="slider-section-title">
                                <span class="sub-title">A STRONG INTERNATIONAL PARTNERSHIP</span>
                                <h2 class="title">The members of Lense & Lumen</h2>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="slider-container">
                    <div class="swiper lense-lumen-swiper">
                            <div class="swiper-wrapper">
                            <?php foreach ($members as $m): ?>
                                <div class="swiper-slide">
                                    <img src="admin/<?= $m['image'] ?>" alt="<?= escape_html($m['member_name']) ?>" width="180">
                                    <div class="slide-content">
                                        <p class="name"><?= escape_html($m['member_name']) ?></p>
                                        <p class="country"><?= escape_html($m['country']) ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                            </div>
                    </div>
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-button-next"></div>
                </div>
            </section>
        <?php endif; ?>
        <!-- lense-lumen-members-slider-area-end -->

<!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->


    </main>
    <!-- main-area-end -->

<?php
include 'includes/footer.php';
?>
