<?php
// Override page title and description(if needed for SEO purpose)
// $pageTitle = 'Our Founders - ASPPL';
// $pageDescription = 'Meet our founders';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'founders';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';

$query = "
    SELECT 
        id, name, designation, image_list, linkedin_url
    FROM founders
    WHERE status = '1'
    ORDER BY sort_order ASC, id DESC
";

$founders = $db->select($query);
?>

<!-- main-area -->
<main class="main-area fix">

    <!-- ===================================================== -->
    <!-- BREADCRUMB AREA -->
    <!-- ===================================================== -->
    <section class="breadcrumb__area">
        <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
        <div class="container">
            <div class="breadcrumb__content">
                <h2 class="title">Founders</h2>

                <nav class="breadcrumb">
                    <span>
                        <a href="<?= isset($projectBasePath) ? escape_html($projectBasePath) : "" ?>/">Home</a>
                    </span>
                    <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                    <span>Founders</span>
                </nav>

            </div>
        </div>
    </section>
    <!-- breadcrumb-area-end -->


    <!-- ===================================================== -->
    <!-- FOUNDERS LISTING SECTION -->
    <!-- ===================================================== -->
    <section class="team__area-three section-py-130">
        <div class="container">

            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="section__title text-center mb-50 mb-md-30">
                        <h2 class="title">Meet Our Founders</h2>
                    </div>
                </div>
            </div>

            <div class="row gutter-y-30 justify-content-center">

                <?php if (!empty($founders)): ?>
                    <?php foreach ($founders as $founder): ?>

                        <?php
                            $founderId   = (int) $founder['id'];
                            $name        = escape_html($founder['name']);
                            $designation = escape_html($founder['designation']);

                            // Founder image (fallback if empty)
                            $profileImage = !empty($founder['image_list'])
                                ? "admin/" . escape_html($founder['image_list'])
                                : "";

                            // LinkedIn URL only for this design
                            $linkedin = trim($founder['linkedin_url']);

                            // Founder Details Page Link
                            // (/founder-details?id=XX)
                            $detailsLink = (isset($projectBasePath) ? escape_html($projectBasePath) : "")
                                         . "/founder-details?id=" . $founderId;
                        ?>

                        <div class="col-xl-3 col-lg-4 col-sm-6">
                            <div class="team__item-three">

                                <div class="team__thumb-three">
                                    <img src="<?= $profileImage ?>" alt="<?= $name ?>">
                                </div>

                                <div class="team__content-three">
                                    <h2 class="title">
                                        <a href="<?= $detailsLink ?>"><?= $name ?></a>
                                    </h2>

                                    <span><?= $designation ?></span>

                                    <div class="team__social-three">
                                        <ul class="list-wrap">
                                            <?php if (!empty($linkedin)): ?>
                                                <li>
                                                    <a href="<?= escape_html($linkedin) ?>" target="_blank" rel="noopener">
                                                        <img src="assets/img/icons/linkedin.svg" class="injectable">
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>

                                </div>

                            </div>
                        </div>

                    <?php endforeach; ?>

                <?php else: ?>

                    <!-- If no founders found -->
                    <div class="col-lg-8 text-center">
                        <p>No founders available at the moment.</p>
                    </div>

                <?php endif; ?>

            </div>
        </div>
    </section>
    <!-- team-area-end -->

</main>
<!-- main-area-end -->

<?php
include 'includes/footer.php';
?>
