<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Founder Details - ASPPL';
// $pageDescription = 'View founder member details';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPage = 'founders';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';


// =======================================================
//   Fetch Founder ID safely
// =======================================================
$founderId = isset($_GET['id']) ? (int) $_GET['id'] : 0;

// Default: founder not found
$founder = null;

// =======================================================
//  If valid ID -> Fetch Founder Data
// =======================================================
if ($founderId > 0) {
    $query = "
        SELECT 
            id, name, designation, bio, image_bio,
            facebook_url, twitter_url, instagram_url, linkedin_url
        FROM founders
        WHERE id = {$founderId} AND status = '1'
        LIMIT 1
    ";

    $result = $db->select($query);
    if (!empty($result)) {
        $founder = $result[0]; // store found founder
    }
}

// Prepare data if founder exists
if ($founder) {
    $name        = escape_html($founder['name']);
    $designation = escape_html($founder['designation']);
    $bio         = $founder['bio'];

    // Image (fallback included)
    $profileImage = !empty($founder['image_bio'])
        ? "admin/" . escape_html($founder['image_bio'])
        : "";

    // Social URLs
    $socialLinks = [
        "linkedin"  => trim($founder["linkedin_url"]),
        "facebook"  => trim($founder["facebook_url"]),
        "twitter"   => trim($founder["twitter_url"]),
        "instagram" => trim($founder["instagram_url"]),
    ];

    // Social Icons
    $socialIcons = [
        "linkedin"  => "assets/img/icons/linkedin.svg",
        "facebook"  => "assets/img/icons/facebook.svg",
        "twitter"   => "assets/img/icons/twitter.svg",
        "instagram" => "assets/img/icons/instagram.svg",
    ];
}
?>

<!-- main-area -->
<main class="main-area fix">

    <!-- ===================================================== -->
    <!-- BREADCRUMB AREA -->
    <!-- ===================================================== -->
    <section class="breadcrumb__area">
        <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
        <div class="container">
            <div class="breadcrumb__content">

                <h2 class="title">
                    <?= $founder ? $name : "Founder Details" ?>
                </h2>

                <nav class="breadcrumb">
                    <span>
                        <a href="<?= isset($projectBasePath) ? escape_html($projectBasePath) : "" ?>/">Home</a>
                    </span>

                    <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>

                    <span>Founder Details</span>

                    <?php if ($founder): ?>
                        <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                        <span><?= $name ?></span>
                    <?php endif; ?>

                </nav>

            </div>
        </div>
    </section>
    <!-- breadcrumb-area-end -->



<?php if (!$founder): ?>

    <!-- ===================================================== -->
    <!-- NOT FOUND SECTION -->
    <!-- ===================================================== -->
    <section class="team__details-area section-py-130">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <h2>Founder Not Found</h2>
                    <p>Sorry, the founder you requested could not be found.</p>

                    <a href="<?= isset($projectBasePath) ? escape_html($projectBasePath) : '' ?>/founders" 
                       class="tg-btn mt-4">
                        Back to Founders List
                    </a>
                </div>
            </div>
        </div>
    </section>

<?php else: ?>

    <!-- ===================================================== -->
    <!-- FOUNDER DETAILS SECTION -->
    <!-- ===================================================== -->
    <section class="team__details-area section-py-130">
        <div class="container">

            <div class="row justify-content-center">

                <!-- Left Image -->
                <div class="col-44">
                    <div class="team__details-img">
                        <img src="<?= $profileImage ?>" alt="<?= $name ?>">
                    </div>
                </div>

                <!-- Right Details -->
                <div class="col-56">
                    <div class="team__details-info-wrap">

                        <h2 class="title"><?= $name ?></h2>
                        <span><?= $designation ?></span>

                        <!-- Social Links -->
                        <div class="team__details-social">
                            <ul class="list-wrap">
                                <?php foreach ($socialLinks as $key => $url): ?>
                                    <?php if (!empty($url)): ?>
                                        <li>
                                            <a href="<?= escape_html($url) ?>" target="_blank" rel="noopener noreferrer">
                                                <img src="<?= $socialIcons[$key] ?>" alt="<?= $key ?>" class="injectable">
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>

                        <!-- Bio -->
                        <p><?= $bio ?></p>

                    </div>
                </div>

            </div>

            <!-- Contact Form -->
            <div class="team__details-contact">
                <div class="team__details-contact-content">
                    <h2 class="title">Connect With Me</h2>
                </div>

                <form id="contact-form" 
                                action="actions/contact-submit" 
                                method="POST" 
                                class="team__details-form call__back-form-two contact__form">
                    <div id="contact-section">
                        <?php if ($msg = get_flash_message("contact_message")): ?>
                            <?php 
                                $cls = 'alert-info';
                                if ($msg['type'] === 'success') $cls = 'alert-success';
                                if ($msg['type'] === 'error')   $cls = 'alert-danger';
                            ?>
                            <div class="alert <?= $cls ?> alert-dismissible fade show py-2 px-3 small d-flex mt-3"
                                id="contactAlert">

                                <?= escape_html($msg['text']) ?>

                                <div type="button" 
                                    class="btn-close position-absolute end-0 top-50 translate-middle-y pe-3"
                                    data-bs-dismiss="alert"
                                    aria-label="Close"></div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Detect which page the form belongs to -->
                    <input type="hidden" name="page_from" value="founder-details">
                    <input type="hidden" name="founder-details-id" value="<?php echo isset($founderId)? $founderId : ""; ?>">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-grp">
                                <input type="text" name="name" placeholder="Name *" required value="<?= escape_html(get_flash_message('contact_old_session_name') ?? '') ?>">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-grp">
                                <input type="email" name="email" placeholder="E-mail *" required value="<?= escape_html(get_flash_message('contact_old_session_email') ?? '') ?>">
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-grp">
                                <input name="subject" type="text" placeholder="Subject *" required value="<?= escape_html(get_flash_message('contact_old_session_subject') ?? '') ?>">
                            </div>
                        </div>
                    </div>

                    <div class="form-grp">
                        <textarea name="message" placeholder="Comments *" required maxlength="5000"><?= escape_html(get_flash_message('contact_old_session_message') ?? '') ?></textarea>
                    </div>

                    <button type="submit" class="contact-form-submit-btn" name="contact-form-submit">Send Message</button>
                </form>
            </div>

        </div>
    </section>

<?php endif; ?>

</main>
    <!-- main-area-end -->

<?php
include 'includes/footer.php';
?>
