<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Business Vertical - ASPPL';
// $pageDescription = 'Business Vertical ASPPL - Associated Search Professionals Pvt Ltd';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'engineering-automative';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';
?>
    <!-- main-area -->
    <main class="main-area fix">


        <!-- breadcrumb-area -->
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">Energy Process & Infrastructure Services</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">Business Verticals</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

        <!-- features-area -->
        <section class="features__area-two section-py-130">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-6 col-md-10 order-0 order-lg-2">
                        <div class="features__img">
                            <img src="assets/img/business-verticals/energy-process.jpg" alt="img">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="features__content-two">
                            <div class="section__title mb-25">
                                <!--<span class="sub-title">Feature</span>-->
                                <h2 class="title">Energy Process & Infrastructure</h2>
                            </div>
                            <!--<p>Our Tax Advisory Services are tailored to address the diverse tax needs of individuals, businesses, and organisations. From compliance to advanced tax strategies, our experts work to ensure you achieve.</p>-->
                            <ul class="list-wrap about__list-item-two">
                                <li>
                                    <div class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    Renewable Energy – hydro, Wind, Solar, Biomass
                                </li>
                                <li>
                                    <div class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    Conventional - Thermal, Coal, Oil, Natural Gas
                                </li>
                                <li>
                                    <div class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    Power Generation, Transmission, Distribution
                                </li>
                                <li>
                                    <div class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    Civil Infra, MEP, Metro Rail
                                </li>
                                <li>
                                    <div class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    Fashion and Lifestyle, Biotech, Mobile phones, IT
                                </li>
                                <li>
                                    <div class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    Build–operate–transfer (BOT) or build–own
                                </li>
                                <li>
                                    <div class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    Petrochemical, refinery Plants
                                </li>
                                <li>
                                    <div class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    Fertilizers, Steel, Metals, Mineral processing, Cement, Paints etc
                                </li>
                                
                            </ul>
                            <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/contact" class="tg-btn tg-btn-three">Let’s Talk <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>-->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- features-area-end -->

        <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->


    </main>
    <!-- main-area-end -->

<?php
include 'includes/footer.php';
?>
