<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Contingent Search - ASPPL';
// $pageDescription = 'Contingent Search ASPPL - Associated Search Professionals Pvt Ltd';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'contingent-search';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';
?>
    <!-- main-area -->
    <main class="main-area fix">


        <!-- breadcrumb-area -->
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">Contingent Search</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">Contingent Search</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

        <!-- features-area -->
        <section class="features__area-two section-py-130">
    <div class="container">

        <div class="row justify-content-center">
            <div class="col-xl-12 col-lg-12">
                <div class="section__title text-center mb-50">
                    <h2 class="title">Our 5-Phase Search Process</h2>
                    <p style="margin-top: 15px; font-size: 16px; line-height: 1.6;">
                        We aim to be true advisors to our clients during the entire phase of the search process. We strive to continuously exceed our client’s expectations by providing the right choice of candidates with the right vision, right background and the right expectations.
                    </p>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-lg-6 col-md-6 mb-4 mb-lg-0">
                <div style="background-color: #f9f9f9; padding: 30px; border-radius: 8px; height: 100%; box-shadow: 0 4px 10px rgba(0,0,0,0.03);">
                    <h4 style="font-size: 18px; font-weight: 700; color: #333; border-left: 4px solid #01022e; padding-left: 15px; margin-bottom: 20px;">
                        1. Identify and Establish Search Priorities
                    </h4>
                    <ul class="list-wrap" style="padding-left: 20px;">
                        <li style="margin-bottom: 8px; color: #555;">Jointly Identify and Analyze the challenges which are bespoke to the organization and the role.</li>
                        <li style="margin-bottom: 8px; color: #555;">Determine the skills, knowledge and abilities required, offering insight and fresh perspectives on how clients can think about their needs.</li>
                        <li style="margin-bottom: 8px; color: #555;">Develop a customized job description and candidate specification, detailing the company, the role, responsibilities, goals and key challenges.</li>
                        <li style="margin-bottom: 8px; color: #555;">Determine the client priorities that will shape the search process.</li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-6 col-md-6">
                <div style="background-color: #f9f9f9; padding: 30px; border-radius: 8px; height: 100%; box-shadow: 0 4px 10px rgba(0,0,0,0.03);">
                    <h4 style="font-size: 18px; font-weight: 700; color: #333; border-left: 4px solid #01022e; padding-left: 15px; margin-bottom: 20px;">
                        2. Define the Search Target Plan
                    </h4>
                    <ul class="list-wrap" style="padding-left: 20px;">
                        <li style="margin-bottom: 8px; color: #555;">Draw a search target plan by researching into companies and sectors to find those with relevant skill-sets and qualifications.</li>
                        <li style="margin-bottom: 8px; color: #555;">Supplementing our extensive knowledge of the market and relationships with senior executives across industries and Functions.</li>
                        <li style="margin-bottom: 8px; color: #555;">Core to our approach is the preliminary referencing work which brings in confidence with our clients about the candidates whom we refer.</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-lg-6 col-md-6 mb-4 mb-lg-0">
                <div style="background-color: #f9f9f9; padding: 30px; border-radius: 8px; height: 100%; box-shadow: 0 4px 10px rgba(0,0,0,0.03);">
                    <h4 style="font-size: 18px; font-weight: 700; color: #333; border-left: 4px solid #01022e; padding-left: 15px; margin-bottom: 20px;">
                        3. Evaluate and Assess Candidates
                    </h4>
                    <ul class="list-wrap" style="padding-left: 20px;">
                        <li style="margin-bottom: 8px; color: #555;">Approach potential candidates to test their interest in the role, drawing on our insights about candidate interests and aspirations to persuade strong prospects to consider new opportunities.</li>
                        <li style="margin-bottom: 8px; color: #555;">Conduct rigorous competency-based interviews with candidates based on the proven skills, knowledge, abilities and aptitudes outlined in the position specification.</li>
                        <li style="margin-bottom: 8px; color: #555;">Develop a short list of candidates with the qualifications and interest in the position.</li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-6 col-md-6">
                <div style="background-color: #f9f9f9; padding: 30px; border-radius: 8px; height: 100%; box-shadow: 0 4px 10px rgba(0,0,0,0.03);">
                    <h4 style="font-size: 18px; font-weight: 700; color: #333; border-left: 4px solid #01022e; padding-left: 15px; margin-bottom: 20px;">
                        4. Submit Shortlisted Candidates
                    </h4>
                    <ul class="list-wrap" style="padding-left: 20px;">
                        <li style="margin-bottom: 8px; color: #555;">Present the most qualified candidates based on in-depth written analysis and appraisal against the specification.</li>
                        <li style="margin-bottom: 8px; color: #555;">Highlighting on informal external views on each candidate to confirm our knowledge of the candidate’s achievements and track record.</li>
                        <li style="margin-bottom: 8px; color: #555;">Provide meaningful insight into their past performance and reputation.</li>
                        <li style="margin-bottom: 8px; color: #555;">Verify each candidate’s academic qualifications and employment track record.</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div style="background-color: #f9f9f9; padding: 30px; border-radius: 8px; height: 100%; box-shadow: 0 4px 10px rgba(0,0,0,0.03);">
                    <h4 style="font-size: 18px; font-weight: 700; color: #333; border-left: 4px solid #01022e; padding-left: 15px; margin-bottom: 20px;">
                        5. Search Completion
                    </h4>
                    <ul class="list-wrap" style="padding-left: 20px;">
                        <li style="margin-bottom: 8px; color: #555;">After the client has selected its preferred candidate, conduct thorough background checks and referencing to further assess competencies, strengths and weaknesses, and to provide external views of the individual.</li>
                        <li style="margin-bottom: 8px; color: #555;">Assist in negotiations over compensation and other terms to help finalize the search.</li>
                        <li style="margin-bottom: 8px; color: #555;">Communicate regularly with Stakeholders during the transition.</li>
                        <li style="margin-bottom: 8px; color: #555;">Periodically follow up with client and candidate once search is closed, checking in on the placement’s fit with the organization and the progress of the transition.</li>
                    </ul>
                </div>
            </div>
        </div>

    </div>
</section>

<!-- features-area -->

  <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->


    </main>
    <!-- main-area-end -->

<?php
include 'includes/footer.php';
?>
