<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Contact Us - ASPPL';
// $pageDescription = 'Contact ASPPL - Associated Search Professionals Pvt Ltd';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'contact';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';
?>
    <!-- main-area -->
    <main class="main-area fix">


        <!-- breadcrumb-area -->
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">Contact With Us</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">Contact</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

        <!-- contact-map -->
        <div class="contact-map">
  <iframe 
    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3058.000000000000!2d77.55600000000000!3d13.00500000000000!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3bae153e00000000%3A0x0000000000000000!2s39%2014th%20Main%20Rd%2C%20Gokula%201st%20Stage%2C%20Mathikere%2C%20Bengaluru%2C%20Karnataka%20560054!5e0!3m2!1sen!2sin!4v0000000000000!5m2!1sen!2sin"
    allowfullscreen 
    loading="lazy">
  </iframe>
</div>

        <!-- contact-map-end -->

        <!-- contact-area -->
        <section class="contact__area">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="contact__info-wrap">
                    <div class="contact__info-item">
                        <h4 class="title">Registered Office - Bangalore</h4>
                        <p>39, 14th Main Road, Gokula 1st Stage, Mathikere Bengaluru - 560 054</p>
                        
                        <a href="https://www.google.com/maps/search/?api=1&query=39,+14th+Main+Road,+Gokula+1st+Stage,+Mathikere+Bengaluru" target="_blank" class="d-inline-flex align-items-center mt-2 text-decoration-none" style="font-weight: 600; color: #007bff;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="me-2">
                                <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                            </svg>
                            Navigate / View on Map
                        </a>
                        <div class="shape">
                            <svg xmlns="http://www.w3.org/2000/svg" width="174" height="210" viewBox="0 0 174 210" fill="none">
                                <path d="M168.636 86.8182C168.636 150.455 86.8182 205 86.8182 205C86.8182 205 5 150.455 5 86.8182C5 65.1187 13.6201 44.3079 28.964 28.964C44.3079 13.6201 65.1187 5 86.8182 5C108.518 5 129.328 13.6201 144.672 28.964C160.016 44.3079 168.636 65.1187 168.636 86.8182Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                                <path d="M86.8182 114.091C101.88 114.091 114.091 101.88 114.091 86.8182C114.091 71.7559 101.88 59.5455 86.8182 59.5455C71.7559 59.5455 59.5455 71.7559 59.5455 86.8182C59.5455 101.88 71.7559 114.091 86.8182 114.091Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </div>

                    <div class="contact__info-item">
                        <h4 class="title">Head Office - Bangalore</h4>
                        <p>61, RA Arcade, 2nd Floor, 18th Cross, Margosa Road, Malleshwaram, Bangalore 560003</p>
                        
                        <a href="https://www.google.com/maps/search/?api=1&query=61,+RA+Arcade,+Margosa+Road,+Malleshwaram,+Bangalore" target="_blank" class="d-inline-flex align-items-center mt-2 text-decoration-none" style="font-weight: 600; color: #007bff;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="me-2">
                                <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                            </svg>
                            Navigate / View on Map
                        </a>
                        <div class="shape">
                            <svg xmlns="http://www.w3.org/2000/svg" width="174" height="210" viewBox="0 0 174 210" fill="none">
                                <path d="M168.636 86.8182C168.636 150.455 86.8182 205 86.8182 205C86.8182 205 5 150.455 5 86.8182C5 65.1187 13.6201 44.3079 28.964 28.964C44.3079 13.6201 65.1187 5 86.8182 5C108.518 5 129.328 13.6201 144.672 28.964C160.016 44.3079 168.636 65.1187 168.636 86.8182Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                                <path d="M86.8182 114.091C101.88 114.091 114.091 101.88 114.091 86.8182C114.091 71.7559 101.88 59.5455 86.8182 59.5455C71.7559 59.5455 59.5455 71.7559 59.5455 86.8182C59.5455 101.88 71.7559 114.091 86.8182 114.091Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </div>

                    <div class="contact__info-item">
                        <h4 class="title">Chennai - Adyar</h4>
                        <p>32, 3rd Main Road, Kasturba Nagar, Adyar, Chennai - 600 020 </p>

                        <a href="https://www.google.com/maps/search/?api=1&query=32,+3rd+Main+Road,+Kasturba+Nagar,+Adyar,+Chennai" target="_blank" class="d-inline-flex align-items-center mt-2 text-decoration-none" style="font-weight: 600; color: #007bff;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="me-2">
                                <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                            </svg>
                            Navigate / View on Map
                        </a>
                        <div class="shape">
                            <svg xmlns="http://www.w3.org/2000/svg" width="174" height="210" viewBox="0 0 174 210" fill="none">
                                <path d="M168.636 86.8182C168.636 150.455 86.8182 205 86.8182 205C86.8182 205 5 150.455 5 86.8182C5 65.1187 13.6201 44.3079 28.964 28.964C44.3079 13.6201 65.1187 5 86.8182 5C108.518 5 129.328 13.6201 144.672 28.964C160.016 44.3079 168.636 65.1187 168.636 86.8182Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                                <path d="M86.8182 114.091C101.88 114.091 114.091 101.88 114.091 86.8182C114.091 71.7559 101.88 59.5455 86.8182 59.5455C71.7559 59.5455 59.5455 71.7559 59.5455 86.8182C59.5455 101.88 71.7559 114.091 86.8182 114.091Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </div>

                    <div class="contact__info-item">
                        <h4 class="title">Chennai - OMR</h4>
                        <p>3, Rajiv Street, 2nd Floor, Shobha Castle, Kottivakkam, Chennai - 600 041.</p>
                        
                        <a href="https://www.google.com/maps/search/?api=1&query=Shobha+Castle,+Kottivakkam,+Chennai" target="_blank" class="d-inline-flex align-items-center mt-2 text-decoration-none" style="font-weight: 600; color: #007bff;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="me-2">
                                <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                            </svg>
                            Navigate / View on Map
                        </a>
                        <div class="shape">
                            <svg xmlns="http://www.w3.org/2000/svg" width="174" height="210" viewBox="0 0 174 210" fill="none">
                                <path d="M168.636 86.8182C168.636 150.455 86.8182 205 86.8182 205C86.8182 205 5 150.455 5 86.8182C5 65.1187 13.6201 44.3079 28.964 28.964C44.3079 13.6201 65.1187 5 86.8182 5C108.518 5 129.328 13.6201 144.672 28.964C160.016 44.3079 168.636 65.1187 168.636 86.8182Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                                <path d="M86.8182 114.091C101.88 114.091 114.091 101.88 114.091 86.8182C114.091 71.7559 101.88 59.5455 86.8182 59.5455C71.7559 59.5455 59.5455 71.7559 59.5455 86.8182C59.5455 101.88 71.7559 114.091 86.8182 114.091Z" stroke="currentColor" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-6">
                <div class="contact__form-wrap">
                    <h2 class="title">Leave Us A Message</h2>

                    <div id="contact-section">
                        <?php if ($msg = get_flash_message("contact_message")): ?>
                            <?php 
                                $cls = 'alert-info';
                                if ($msg['type'] === 'success') $cls = 'alert-success';
                                if ($msg['type'] === 'error')   $cls = 'alert-danger';
                            ?>
                            <div class="alert <?= $cls ?> alert-dismissible fade show py-2 px-3 small d-flex mt-3"
                                id="contactAlert">

                                <?= escape_html($msg['text']) ?>

                                <button type="button" 
                                    class="btn-close position-absolute end-0 top-50 translate-middle-y pe-3"
                                    data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                    </div>

                    <form id="contact-form" 
                        action="actions/contact-submit" 
                        method="POST" 
                        class="contact__form">
                        
                        <input type="hidden" name="page_from" 
                            value="contact">

                        <div class="form-grp">
                            <label for="name">Name *</label>
                            <input id="name" name="name" required type="text"
                                value="<?= escape_html(get_flash_message('contact_old_session_name') ?? '') ?>">
                        </div>

                        <div class="form-grp">
                            <label for="email">Email *</label>
                            <input id="email" name="email" required type="email"
                                value="<?= escape_html(get_flash_message('contact_old_session_email') ?? '') ?>">
                        </div>

                        <div class="form-grp">
                            <label for="subject">Subject *</label>
                            <input id="subject" name="subject" required type="text"
                                value="<?= escape_html(get_flash_message('contact_old_session_subject') ?? '') ?>">
                        </div>

                        <div class="form-grp">
                            <label for="comment">Comment *</label>
                            <textarea id="comment" name="message" required><?= escape_html(get_flash_message('contact_old_session_message') ?? '') ?></textarea>
                        </div>

                        <button type="submit" name="contact-form-submit" class="tg-btn tg-btn-three contact-form-submit-btn">Submit Message</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
        <!-- contact-area-end -->

   <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->


    </main>
    <!-- main-area-end -->

<?php
include 'includes/footer.php';
?>
