<?php
// Override page title and description
$pageTitle = 'Executive Placement Triumph - Case Study | ASPPL';
$pageDescription = 'Case Study: Securing an MD for a US Automotive Tier-1 Giant (2011). A look back at how ASPPL solved a high-stakes executive search.';

// Set current page url name
$currentPageUrlName = 'case-study';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';
?>
    <main class="main-area fix">

        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">Success Stories</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : "/"; ?>/">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">Case Study</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="features__area-two section-py-130">
            <div class="container">
                
                <div class="row align-items-center justify-content-center mb-50">
                    <div class="col-lg-6 col-md-10 order-0 order-lg-2">
                        <div class="features__img">
                            <img src="assets/img/case-study/case-study.jpg
" alt="Executive Search Success" style="border-radius: 10px; box-shadow: 0 10px 30px rgba(0,0,0,0.1);">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="features__content-two">
                            <div class="section__title mb-20">
                                <span class="sub-title">Success Look back #1</span>
                                <h2 class="title" style="font-size: 32px;">Executive Placement Triumph</h2>
                                <h5 style="color: #6c757d; font-weight: 400; margin-top: 10px;">Securing an MD for a US Automotive Tier-1 Giant (2011)</h5>
                            </div>
                            
                            <h4 class="title-sm" style="color: #0A102E;">The Challenge</h4>
                            <p>In 2011, ASPPL secured its inaugural retained mandate: finding a Managing Director (MD) for a prominent, Large Tier-1 US MNC entering a critical phase in the Automotive sector. The client demanded a <strong>"unicorn profile"</strong>:</p>
                            
                            <ul class="list-wrap about__list-item-two">
                                <li>
                                    <div class="icon"><i class="fas fa-check"></i></div>
                                    <div><strong>Deep Automotive Industry Roots:</strong> Non-negotiable sector experience.</div>
                                </li>
                                <li>
                                    <div class="icon"><i class="fas fa-check"></i></div>
                                    <div><strong>Stability & Loyalty:</strong> Max 3 job changes; 7+ years tenure in current role.</div>
                                </li>
                                <li>
                                    <div class="icon"><i class="fas fa-check"></i></div>
                                    <div><strong>Proven Growth Trajectory:</strong> From 1000+ crores business unit with scaling experience.</div>
                                </li>
                                <li>
                                    <div class="icon"><i class="fas fa-check"></i></div>
                                    <div><strong>Dynamic Leadership:</strong> Capable of steering an ambitious expansion.</div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="row mb-50">
                    <div class="col-12">
                        <div style="background: #f4f6f8; padding: 30px; border-left: 5px solid #0A102E; border-radius: 4px;">
                            <h5 style="margin-bottom: 10px;">The Market Reality</h5>
                            <p style="margin-bottom: 0; font-style: italic;">"Compounding this difficulty was the state of the market: two major international search firms had already executed exhaustive searches, seemingly exhausting the pool of active and visible candidates."</p>
                        </div>
                    </div>
                </div>

                <div class="row mb-30">
                    <div class="col-12 text-center mb-40">
                        <h3 class="title">The Hurdles to Finding "Mr. TIM"</h3>
                        <p>The ideal candidate presented several unique challenges:</p>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="features__item-three" style="padding: 30px; background: #fff; box-shadow: 0 5px 20px rgba(0,0,0,0.05); height: 100%;">
                            <div class="features__content-three">
                                <div class="icon" style="margin-bottom: 20px; color: #0A102E; font-size: 24px;">
                                    <i class="fas fa-user-secret"></i> </div>
                                <h4 class="title">Invisible Talent</h4>
                                <p>Mr. TIM was not an active job seeker. Crucially, he did not even have a LinkedIn profile at the time, making traditional digital headhunting impossible.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="features__item-three" style="padding: 30px; background: #fff; box-shadow: 0 5px 20px rgba(0,0,0,0.05); height: 100%;">
                            <div class="features__content-three">
                                <div class="icon" style="margin-bottom: 20px; color: #0A102E; font-size: 24px;">
                                    <i class="fas fa-cogs"></i> </div>
                                <h4 class="title">The Niche</h4>
                                <p>Employed at a Turbo Chargers company (highly specialized), making him a "hidden gem" outside typical org charts reviewed by competitors.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="features__item-three" style="padding: 30px; background: #fff; box-shadow: 0 5px 20px rgba(0,0,0,0.05); height: 100%;">
                            <div class="features__content-three">
                                <div class="icon" style="margin-bottom: 20px; color: #0A102E; font-size: 24px;">
                                    <i class="fas fa-trophy"></i> </div>
                                <h4 class="title">The Vacuum</h4>
                                <p>ASPPL had to succeed where two global firms had failed. Conventional candidates were already rejected or off the table.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <hr style="margin: 50px 0; border-top: 1px solid #e0e0e0;">

                <div class="row align-items-start">
                    <div class="col-lg-6 mb-30">
                        <h3 class="title mb-20">The Solution: Going Beyond the Visible</h3>
                        <p>Recognizing the futility of public profiles, ASPPL employed a deep, classic, and high-touch executive search strategy:</p>
                        
                        <div style="margin-top: 25px;">
                            <div class="d-flex mb-3">
                                <div style="min-width: 40px; height: 40px; background: #eef0f4; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-right: 15px; color: #0A102E; font-weight: bold;">1</div>
                                <div>
                                    <h5 style="font-size: 18px; margin-bottom: 5px;">The Power of Veterans</h5>
                                    <p style="font-size: 15px; margin-bottom: 0;">Connected with hundreds of veterans—current/former CEOs and Board Members—to bypass job boards.</p>
                                </div>
                            </div>
                            <div class="d-flex mb-3">
                                <div style="min-width: 40px; height: 40px; background: #eef0f4; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-right: 15px; color: #0A102E; font-weight: bold;">2</div>
                                <div>
                                    <h5 style="font-size: 18px; margin-bottom: 5px;">Valuable Referencing</h5>
                                    <p style="font-size: 15px; margin-bottom: 0;">Leveraged conversations for confidential introductions to passive, high-performing individuals.</p>
                                </div>
                            </div>
                            <div class="d-flex mb-3">
                                <div style="min-width: 40px; height: 40px; background: #eef0f4; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-right: 15px; color: #0A102E; font-weight: bold;">3</div>
                                <div>
                                    <h5 style="font-size: 18px; margin-bottom: 5px;">Targeting the "Inactive"</h5>
                                    <p style="font-size: 15px; margin-bottom: 0;">Shifted focus entirely to the inactive talent pool—successful leaders not looking to move.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6 mb-30">
                        <div style="background: linear-gradient(135deg, #0A102E 0%, #1e2846 100%); color: #fff; padding: 40px; border-radius: 10px; height: 100%;">
                            <h3 style="color: #fff; border-bottom: 1px solid rgba(255,255,255,0.2); padding-bottom: 15px; margin-bottom: 25px;">The Outcome</h3>
                            
                            <div style="margin-bottom: 20px;">
                                <h5 style="color: #FFD700; font-size: 18px;">★ A Perfect Fit</h5>
                                <p style="color: rgba(255,255,255,0.9);">Mr. TIM was selected as the unanimous choice for the MD role.</p>
                            </div>

                            <div style="margin-bottom: 20px;">
                                <h5 style="color: #FFD700; font-size: 18px;">★ Rapid Onboarding</h5>
                                <p style="color: rgba(255,255,255,0.9);">Despite market exhaustion, ASPPL onboarded Mr. TIM within an impressive <strong>5 months</strong> of receiving the mandate.</p>
                            </div>

                            <p style="font-size: 14px; color: rgba(255,255,255,0.6); margin-top: 30px; font-style: italic;">
                                "This landmark placement cemented ASPPL's reputation for accessing discreet talent, proving that strategic human connections triumph over exhausted databases."
                            </p>
                        </div>
                    </div>
                </div>

                <div class="row mt-40">
                    <div class="col-12 text-center">
                         <h5 style="color: #6c757d;">More case studies to follow...</h5>
                    </div>
                </div>

            </div>
        </section>
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        </main>
    <?php
include 'includes/footer.php';
?>