/*=============================================
	=        Newsletter Subscribtion Section
=============================================*/
document.addEventListener("DOMContentLoaded", function() {
    const alertBox = document.getElementById("newsletterAlert");
    if (alertBox) {
        const target = document.getElementById("newsletter-section");
        if (target) {
            target.scrollIntoView({
                behavior: "smooth",
                block: "center"
            });
        }
    }
});

/*===================================
	=        Contact Form Section
=====================================*/
document.addEventListener("DOMContentLoaded", function() {
    const alertBox = document.getElementById("contactAlert");
    if (alertBox) {
        const target = document.getElementById("contact-section");
        if (target) {
            target.scrollIntoView({
                behavior: "smooth",
                block: "center"
            });
        }
    }

    document.querySelector('.contact__form').addEventListener('submit', function () {
        var btn = document.querySelector('.contact-form-submit-btn');
        // Add spinner & disable looking style
        btn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Processing...';
        btn.style.opacity = "0.7";
        btn.style.pointerEvents = "none";
    });
});


/*======================================
	=       Industries Section Slider
========================================*/
document.addEventListener('DOMContentLoaded', function () {
    if (typeof Swiper !== 'undefined') {
        var industriesSlider = new Swiper(".industries-active", {
            loop: true,
            slidesPerGroup: 1, 
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            breakpoints: {
                1200: { slidesPerView: 5, spaceBetween: 20 },
                992: { slidesPerView: 4, spaceBetween: 20 },
                768: { slidesPerView: 3, spaceBetween: 20 },
                0: { slidesPerView: 1.3, spaceBetween: 15, centeredSlides: true }
            }
        });
    } else {
        console.error('Swiper library is not loaded. Cannot initialize industries slider.');
    }
});