<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'Active Searches - ASPPL';
// $pageDescription = 'View our current job openings and active searches';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'approach';

$headerCssAndScriptFiles = ['css' => [], 'js'  => []];
$footerScriptFiles = ['js'  => []];

include 'includes/header.php';
?>
    <!-- main-area -->
    <main class="main-area fix">


        <!-- breadcrumb-area -->
        <section class="breadcrumb__area-two">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="breadcrumb__content breadcrumb__content-two">
                            <h2 class="title">Our Approach</h2>
                            <!--<nav class="breadcrumb">-->
                            <!--    <span property="itemListElement" typeof="ListItem">-->
                            <!--        <a href="index.html">Home</a>-->
                            <!--    </span>-->
                            <!--    <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>-->
                            <!--    <span property="itemListElement" typeof="ListItem">Career</span>-->
                            <!--</nav>-->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

        <!-- career-area -->
        <div class="career__area">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <!--<div class="career__img">-->
                        <!--    <img src="assets/img/images/career_img01.jpg" alt="img">-->
                        <!--</div>-->
                        <div class="career__content">
                            <p>At ASPPL, our approach is built on clarity, integrity, and precision. We combine strong core values with a structured methodology to deliver reliable and effective talent solutions. Through advanced sourcing methods and well-defined assessment frameworks, we ensure every search is thorough, unbiased, and aligned with our clients’ business objectives.</p>
                        </div>
                    </div>
                </div>
                <span class="features__divider"></span>
            </div>
        </div>
        <!-- career-area-end -->

        <!-- work-area -->
        <section class="work__area-three section-pb-130">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-6 col-md-10">
                        <div class="work__thumb">
                            <img src="assets/img/business-verticals/core-values.jpg" alt="img">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="work__content-three">
                            <div class="section__title mb-25">
                                <h2 class="title">Our USP / Core Value & Ethics</h2>
                            </div>
                            <h4> Key Differentiators </h4>
                            </br>
                            <ul class="work__list-wrap list-wrap">
                                <li>
                                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/>
                                    </svg>
                                    Our searches are tied to our client's vision and corporate strategy.
                                </li>
                                <li>
                                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/>
                                    </svg>
                                    We are partner-led, partner-driven, and completely hands-on.
                                </li>
                                <li>
                                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/>
                                    </svg>
                                    Highly Dependable and Result Oriented Approach
                                </li>
                            </ul>
                        </div>
                        </br>
                        <div>
    <h4>Core Values (D : T : H)</h4>
    <br>

    <ul class="core-values-list">
        <li>
            <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/>
            </svg>
            D for Discreet : in our Approach, we give high prominence to being polite, careful, tactful, diplomatic and confidential
        </li>

        <li>
            <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/>
            </svg>
            T for Transparency : We provide the highest level of transparency while executing each assignment. Clients have full and constant access to our entire search team throughout the search processes
        </li>

        <li>
            <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M6.93841 15.8911C8.7676 13.0791 15.4953 5.84106 21.0746 2.08087C21.3116 1.92117 21.5791 2.23465 21.3827 2.44213C16.0823 8.03965 10.4168 14.3711 7.16296 19.846C7.07232 19.9985 6.85351 20.0038 6.7588 19.8538C5.12145 17.2603 3.71716 13.5322 0.70718 12.3898C0.483573 12.3049 0.505064 11.9888 0.73758 11.9328C3.62207 11.2378 4.97369 13.7047 6.93841 15.8907V15.8911Z" fill="currentColor"/>
            </svg>
            H for Honesty : We persist on honesty and fairness as the guidelines for our business and we dedicate ourselves to incorporate these values in all our actions, including Setting the Right Expectations for both stakeholders (Client | Candidates)
        </li>
    </ul>
</div>

<style>
    .core-values-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .core-values-list li {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        margin-bottom: 18px;
        font-size: 17px;
        line-height: 1.6;
        color: #1A1A1A;
    }

    .core-values-list svg {
        margin-top: 5px; /* aligns icon with text nicely */
        color: #0A2342;  /* dark navy like your design */
    }
</style>

                        
                        
                    </div>
                    
                </div>
            </div>
        </section>
        <!-- work-area-end -->

<!-- features-area -->
<section class="features__area-three section-py-130">
    <div class="container">

        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section__title text-center mb-40">
                    <span class="sub-title">The 12 Steps Approach</span>
                    <h2 class="title">Snapshot of Our Methodology</h2>
                </div>
            </div>
        </div>

        <!-- Row 1 -->
        <div class="row gutter-y-24 justify-content-center">
            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/Client-Orientation.png" alt="Client Orientation" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Client Orientation</h3>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/Search-Target-Plan.png" alt="Search Target Plan" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Search Target Plan</h3>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/Industry-Mapping.png" alt="Industry Mapping" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Industry Mapping</h3>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/People-Mapping.png" alt="People Mapping" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">People Mapping</h3>
                    </div>
                </div>
            </div>
        </div>

        <br/>

        <!-- Row 2 -->
        <div class="row gutter-y-24 justify-content-center">
            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/First-Shortlist.png" alt="First Shortlist" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">First Shortlist</h3>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/Assessment-icon.png" alt="Assessment" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Assessment</h3>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/Interviews-icon.png" alt="Interviews" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Interviews</h3>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/councelliing-icon.png" alt="Counselling" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Counselling</h3>
                    </div>
                </div>
            </div>
        </div>

        <br/>

        <!-- Row 3 -->
        <div class="row gutter-y-24 justify-content-center">
            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/Background-Checks-icon.png" alt="Background Checks" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Background Checks</h3>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/Offer-Release-icon.png" alt="Offer Release" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Offer Release</h3>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/onboarding.png" alt="Onboarding" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Onboarding</h3>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-sm-6">
                <div class="features__item-two">
                    <div class="features__icon-two">
                        <img src="assets/img/icons/approach/Post-Joining-Feedbacks.png" alt="Post Joining Feedbacks" />
                    </div>
                    <div class="features__content-four">
                        <h3 class="title">Post Joining Feedbacks</h3>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>
<!-- features-area-end -->

        <!-- benefit-area -->
        <section class="benefit__area-two section-py-130">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-4 col-md-7 col-sm-9 order-0 order-lg-2">
                        <div class="benefit__img-two benefit__img-three">
                            <img src="assets/img/business-verticals/sorcing.jpg" alt="Sourcing">
                        </div>
                    </div>
                    <div class="col-lg-8">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="section__title mb-50">
                                    <!--<span class="sub-title">Benefits</span>-->
                                    <h2 class="title">Sourcing Methods</h2>
                                </div>
                                <div class="benefit__item-two">
                                    <div class="benefit__icon-two">
                                        <i class="fas fa-bullseye"></i>
                                    </div>
                                    <div class="benefit__content-two">
                                        <h4 class="title">Headhunting</h4>
                                        <p>We directly approach high-impact professionals.</p>
                                    </div>
                                </div>
                                <div class="benefit__item-two">
                                    <div class="benefit__icon-two">
                                        <i class="fas fa-lightbulb"></i>
                                    </div>
                                    <div class="benefit__content-two">
                                        <h4 class="title">People Mapping</h4>
                                        <p>We chart key talent across target companies.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="benefit__item-two">
                                    <div class="benefit__icon-two">
                                        <i class="fas fa-network-wired"></i>
                                    </div>
                                    <div class="benefit__content-two">
                                        <h4 class="title">Networking</h4>
                                        <p>We tap into strong industry connections.</p>
                                    </div>
                                </div>
                                <div class="benefit__item-two">
                                    <div class="benefit__icon-two">
                                        <i class="fas fa-chart-bar"></i>
                                    </div>
                                    <div class="benefit__content-two">
                                        <h4 class="title">Market Mapping</h4>
                                        <p>We study talent trends and competitor structures.</p>
                                    </div>
                                </div>
                                <div class="benefit__item-two">
                                    <div class="benefit__icon-two">
                                        <i class="fas fa-database"></i>
                                    </div>
                                    <div class="benefit__content-two">
                                        <h4 class="title">Internal Database</h4>
                                        <p>We use a curated pool of pre-screened candidates.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- benefit-area-end -->

       <!-- Assessments-area -->
<section class="career__area-two section-py-130">
    <div class="container">

        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="section__title text-center mb-50">
                    <h2 class="title">Our Assessments / Concepts</h2>
                </div>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-12">

                <div class="table-responsive assessment-table-wrapper">
                    <table class="table table-bordered assessment-table">
                        <tbody>

                            <tr>
                                <td>TECHNICAL ASSESSMENT</td>
                                <td>INTELLECTUAL CAPABILITIES</td>
                            </tr>

                            <tr>
                                <td>PHYSOMETRIC ASSESSMENTS</td>
                                <td>BEHAVIOURAL FACT CHEKING</td>
                            </tr>

                            <tr>
                                <td>LOGICAL REASONING</td>
                                <td>CTC DILIGENCE</td>
                            </tr>

                            <tr>
                                <td>CULTURAL ASSESSMENT</td>
                                <td>APTITUDE & ATTITUDE</td>
                            </tr>

                            <tr>
                                <td>ACADEMIC AND CAREER INTERPRETATIONS</td>
                                <td>COGNITIVE ABILITY</td>
                            </tr>

                            <tr>
                                <td>LEADERSHIP & PEOPLE MANAGEMENT</td>
                                <td>VERBAL REASONING & COMMUNICATION</td>
                            </tr>

                            <tr>
                                <td>PERSONALITY ASSESSMENT</td>
                                <td>CREDIBILITY IN THE MARKET</td>
                            </tr>

                            <tr>
                                <td>MEDICAL EXAMINATIONS</td>
                                <td>HONESTY, INTERGRITY & VALUE SYSTEMS</td>
                            </tr>

                        </tbody>
                    </table>
                </div>

            </div>
        </div>

    </div>
</section>
<!-- Assessments-area-end -->


 <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->


    </main>
    <!-- main-area-end -->

<?php
include 'includes/footer.php';
?>
