<?php
// Set current page url name
$currentPageUrlName = 'annual-conference';

// 1. ADD MAGNIFIC POPUP LIBRARIES
$headerCssAndScriptFiles = [
    'css' => [
        'https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css'
    ],
    'js'  => []
];

$footerScriptFiles = [
    'js'  => [
        'https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js'
    ]
];

include 'includes/header.php';
?>

<style>
    /* 1. CONTAINER SETUP */
    .project__item-five {
        position: relative !important;
        overflow: hidden !important;
        border-radius: 12px;
        margin-bottom: 30px;
        /* Force the container to respect the image height */
        height: auto !important; 
        background: transparent !important;
    }

    /* 2. IMAGE STYLING */
    .project__thumb-five {
        margin: 0 !important;
        height: 100% !important;
        width: 100% !important;
    }
    
    .project__thumb-five img {
        width: 100% !important;
        height: 300px !important; /* Fixed height for consistency */
        object-fit: cover !important;
        display: block !important;
        transition: transform 0.5s ease;
    }

    /* 3. THE TITLE BOX - FORCE VISIBLE (The Main Fix) */
    /* We target both the default state AND the hover state to ensure they match */
    .project__item-five .project__content-five,
    .project__item-five:hover .project__content-five {
        
        /* Positioning: Lock it to the bottom of the card */
        position: absolute !important;
        left: 0 !important;
        bottom: 0 !important;
        width: 100% !important;
        
        /* VISIBILITY: Override any theme animations */
        opacity: 1 !important;
        visibility: visible !important;
        transform: none !important;      /* Stops the text from sliding down */
        translate: none !important;      /* Newer CSS property to stop movement */
        margin: 0 !important;            /* Remove margins that might push it out */
        
        /* APPEARANCE */
        background: #F9F5FF !important;  /* Light background */
        padding: 15px 20px !important;
        z-index: 99 !important;          /* Ensure it sits on top of image */
        
        display: flex !important;
        justify-content: space-between;
        align-items: center;
    }

    /* 4. TITLE TEXT */
    .project__content-five .title {
        margin: 0 !important;
        font-size: 18px !important;
        font-weight: 700 !important;
        opacity: 1 !important;
    }
    .project__content-five .title a {
        color: #CD222A !important; /* Default Red Color */
        text-decoration: none !important;
    }

    /* 5. ARROW BUTTON */
    .project__content-five .arrow {
        position: relative !important;
        opacity: 1 !important;
        visibility: visible !important;
        background: #0A1128 !important;
        padding: 8px !important;
        border-radius: 6px !important;
        display: inline-flex !important;
        right: auto !important;
        bottom: auto !important;
        transform: none !important;
    }
    
    .project__content-five .arrow img {
        width: 14px !important;
        filter: brightness(0) invert(1);
    }

    /* Optional: Zoom image on hover */
    .project__item-five:hover .project__thumb-five img {
        transform: scale(1.05);
    }
    
    .popup-image {
        cursor: zoom-in;
    }
</style>

    <main class="main-area fix">
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">Annual Conference</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>/">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">Annual Conference</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="project__area-five section-py-130">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="section__title mb-50 mb-md-30">
                            <h2 class="title"> Annual Conference</h2>
                        </div>
                    </div>
                </div>
                
                <div class="row gutter-y-30 popup-gallery">
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/srilanka1.jpg" class="popup-image" title="Sri Lanka Conference">
                                    <img src="assets/img/annual-conf/srilanka1.jpg" alt="Sri Lanka Conference">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Sri Lanka (2012)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/khedda1.jpg" class="popup-image" title="Khedda Resort Conference">
                                    <img src="assets/img/annual-conf/khedda1.jpg" alt="Khedda Resort Conference">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Khedda Resort (2013)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/yelagiri1.jpg" class="popup-image" title="Yelagiri">
                                    <img src="assets/img/annual-conf/yelagiri1.jpg" alt="yelagiri1">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Yelagiri (2014)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/pondicherry.jpg" class="popup-image" title="Pondicherry">
                                    <img src="assets/img/annual-conf/pondicherry.jpg" alt="pondicherry">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Pondicherry (2015)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/ooty.jpg" class="popup-image" title="Ooty">
                                    <img src="assets/img/annual-conf/ooty.jpg" alt="ooty">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Ooty (2016)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/coorg.jpg" class="popup-image" title="Coorg">
                                    <img src="assets/img/annual-conf/coorg.jpg" alt="Coorg">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Coorg (2017)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/alleppey.jpg" class="popup-image" title="Alleppey">
                                    <img src="assets/img/annual-conf/alleppey.jpg" alt="Alleppey">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Alleppey (2018)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/masinagudi1.jpg" class="popup-image" title="masinagudi">
                                    <img src="assets/img/annual-conf/masinagudi1.jpg" alt="masinagudi">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Masinagudi (2019)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/yercaud1.jpg" class="popup-image" title="Yercaud">
                                    <img src="assets/img/annual-conf/yercaud1.jpg" alt="Yercaud">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Yercaud (2023)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="project__item-five">
                            <div class="project__thumb-five">
                                <a href="assets/img/annual-conf/kabini1.jpg" class="popup-image" title="Kabini">
                                    <img src="assets/img/annual-conf/kabini1.jpg" alt="kabini">
                                </a>
                            </div>
                            <div class="project__content-five">
                                <h2 class="title">
                                    Kabini (2024)
                                </h2>
                                <!--<a href="<?php echo isset($projectBasePath)? escape_html($projectBasePath) : ""; ?>" class="arrow tg-btn tg-btn-four">-->
                                <!--    <img src="assets/img/icons/right_arrow02.svg" alt="" class="injectable">-->
                                <!--</a>-->
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </section>

    </main>

<script>
    jQuery(document).ready(function($) {
        $('.popup-gallery').magnificPopup({
            delegate: 'a.popup-image', 
            type: 'image',
            tLoading: 'Loading image #%curr%...',
            mainClass: 'mfp-img-mobile',
            gallery: {
                enabled: true, 
                navigateByImgClick: true,
                preload: [0,1] 
            },
            image: {
                tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
                titleSrc: function(item) {
                    return item.el.attr('title'); 
                }
            }
        });
    });
</script>

<?php
include 'includes/footer.php';
?>