<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="box">
    <div class="box-header with-border">
        <div class="left">
            <h3 class="box-title">Testimonials</h3>
        </div>
        <div class="right">
            <a href="<?php echo base_url(); ?>admin_testimonials/add_testimonials" class="btn btn-sm btn-success btn-add-new pull-right">
                <i class="fa fa-plus"></i>
               Add Testimonials
            </a>
        </div>
    </div><!-- /.box-header -->

    <div class="box-body">
        <div class="row">
            <!-- include message block -->
            <div class="col-sm-12">
                <?php $this->load->view('admin/includes/_messages'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" role="grid">
                        <thead>
                        <tr role="row">
                            <th width="20"><input type="checkbox" class="checkbox-table" id="checkAll"></th>
                            <th width="20"><?php echo trans('id'); ?></th>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Designation</th>
                            <th>Description</th>
                            <th>Rating</th>
                            <th>Status</th>
                            <!-- <th></th> -->
                            <?php if ($list_type == "slider_posts"): ?>
                                <th><?php echo trans('slider_order'); ?></th>
                            <?php endif; ?>
                            <th><?php echo trans('date'); ?></th>
                            <th class="max-width-120"><?php echo trans('options'); ?></th>
                        </tr>
                        </thead>
                        <tbody>

                        <?php foreach ($testimonials as $item): ?>
                            <tr>
                                <td><input type="checkbox" name="checkbox-table" class="checkbox-table" value="<?php echo $item->id; ?>"></td>
                                <td><?php echo html_escape($item->id); ?></td>
                                <td class="td-post">
                                    <img src="<?php echo base_url().$item->image; ?>" alt="" class="img-responsive"/>
                                    <?php echo html_escape($item->page_title); ?>
                                </td>
                                <td>
                                    <?php echo html_escape($item->name); ?>
                                </td>
                                 <td>
                                    <?php echo html_escape($item->designation); ?>
                                </td>
                               <td>
                                    <?php echo html_escape(strip_tags($item->description)); ?>
                                </td>
                                <td>
                                    <?php for ($i = 0; $i < 5; $i++): ?>
                                        <i class="fa fa-star" style="color: <?php echo ($i < $item->rating) ? '#fec202;' : '#ccc;'; ?>"></i>
                                    <?php endfor; ?>
                                </td>
                                <td>
                                    <?php if ($item->status == 1): ?>
                                        <label class="label label-success">Active</label>
                                    <?php else: ?>
                                        <label class="label label-danger">Inactive</label>
                                    <?php endif; ?>
                                </td>
                                <!-- <td class="td-post-sp">
                                    <?php //if ($item->visibility == 1): ?>
                                        <label class="label label-success label-table"><i class="fa fa-eye"></i></label>
                                    <?php //else: ?>
                                        <label class="label label-danger label-table"><i class="fa fa-eye"></i></label>
                                    <?php //endif; ?>
                                </td> -->
                               
                                <td><?php echo $item->created_at; ?></td>

                                <td>
                                    <!-- form delete user -->
                                    <?php echo form_open('admin_testimonials/testimonials_options_testimonials'); ?>

                                    <input type="hidden" name="id" value="<?php echo html_escape($item->id); ?>">

                                    <div class="dropdown">
                                        <button class="btn bg-purple dropdown-toggle btn-select-option"
                                                type="button"
                                                data-toggle="dropdown"><?php echo trans('select_option'); ?>
                                            <span class="caret"></span>
                                        </button>

                                        <ul class="dropdown-menu pull-right options-list">

                                            <li>
                                                <a href="<?php echo base_url(); ?>admin_testimonials/update_testimonials/<?php echo html_escape($item->id); ?>">
                                                    <i class="fa fa-edit i-edit"></i><?php echo trans('edit'); ?></a>
                                            </li>
                                       <li>
                                                <a class="p0">
                                                    <button type="submit" name="option" value="delete"
                                                            class="btn-list-button"
                                                            onclick="return confirm('<?php echo trans("confirm_testi"); ?>');">
                                                        <i class="fa fa-trash i-delete"></i><?php echo trans('delete'); ?>
                                                    </button>
                                                </a>
                                            </li>

                                        </ul>
                                    </div>

                                    <?php echo form_close(); ?><!-- form end -->

                                </td>
                            </tr>
                        <?php endforeach; ?>

                        </tbody>
                    </table>

                  <!--  <div class="col-sm-12 table-ft">
                        <div class="row">

                            <div class="pull-right">
                                <?php echo $this->pagination->create_links(); ?>
                            </div>

                            <?php if (count($testimonials) > 0): ?>
                                <div class="pull-left">
                                    <button class="btn btn-sm btn-danger btn-table-delete" onclick="delete_selected_testimonials('<?php echo trans("confirm_testimonials"); ?>');"><?php echo trans('delete'); ?></button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>-->

                </div>
            </div>
        </div>
    </div><!-- /.box-body -->
</div>