<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="row">
    <div class="col-lg-6 col-md-12">
        <div class="box box-primary">

            <div class="box-header with-border">
                <h3 class="box-title">Update Industry</h3>
            </div>

            <?php echo form_open_multipart('industries/update_post'); ?>
            <div class="box-body">

                <?php $this->load->view('admin/includes/_messages'); ?>

                <input type="hidden" name="id" value="<?= $item->id ?>">

                <div class="form-group">
                    <label>Industry Title</label>
                    <input type="text" name="title" class="form-control"
                           value="<?= html_escape($item->title) ?>" required>
                </div>

                <div class="form-group">
                    <label>Sort Order</label>
                    <input type="number" name="sort_order" class="form-control"
                           value="<?= $item->sort_order ?>">
                </div>

                <div class="form-group">
                    <label>Status</label>
                    <select name="status" class="form-control">
                        <option value="1" <?= $item->status == 1 ? "selected" : "" ?>>Active</option>
                        <option value="0" <?= $item->status == 0 ? "selected" : "" ?>>Inactive</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Current Image</label>
                    <div>
                        <img src="<?= base_url($item->image) ?>" class="thumbnail img-responsive" style="max-width: 150px;">
                    </div>
                </div>

                <div class="form-group">
                    <label>Change Image</label>
                    <div>
                        <a class="btn btn-success btn-sm btn-file-upload">
                            Select Image
                            <input type="file" id="Multifileupload" name="file" size="40" accept=".png, .jpg, .jpeg, .gif">
                        </a>
                    </div>

                    <div id="MultidvPreview"></div>
                </div>
            </div>

            <div class="box-footer">
                <button type="submit" class="btn btn-primary pull-right">Save Changes</button>
            </div>

            <?php echo form_close(); ?>
        </div>
    </div>
</div>
