<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="row">
    <div class="col-lg-4 col-md-12">
        <!-- ADD INDUSTRY BOX -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Add Industry</h3>
            </div>

            <?php echo form_open_multipart('industries/add_post'); ?>
            <div class="box-body">

                <?php $this->load->view('admin/includes/_messages_form'); ?>

                <div class="form-group">
                    <label class="control-label">Industry Title</label>
                    <input type="text" class="form-control" name="title" placeholder="Enter industry name" required>
                </div>

                <div class="form-group">
                    <label class="control-label">Sort Order</label>
                    <input type="number" class="form-control" name="sort_order" value="0">
                </div>

                <div class="form-group">
                    <label class="control-label">Status</label>
                    <select name="status" class="form-control" required>
                        <option value="1" selected>Active</option>
                        <option value="0">Inactive</option>
                    </select>
                </div>

                <div class="form-group">
                    <label class="control-label">Industry Image</label>
                    <div>
                        <a class="btn btn-success btn-sm btn-file-upload">
                            Select Image
                            <input type="file" id="Multifileupload" name="file" size="40" accept=".png, .jpg, .jpeg, .gif" required>
                        </a>
                    </div>
                    <div id="MultidvPreview"></div>
                </div>

            </div>

            <div class="box-footer">
                <button type="submit" class="btn btn-primary pull-right">Add Industry</button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>


    <!-- RIGHT SIDE – INDUSTRY LIST -->
    <div class="col-lg-8 col-md-12">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Industries</h3>
            </div>

            <div class="box-body">
                <?php $this->load->view('admin/includes/_messages'); ?>

                <div class="table-responsive">
                    <table class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Sort</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Options</th>
                        </tr>
                        </thead>

                        <tbody>
                        <?php foreach ($items as $item): ?>
                            <tr>
                                <td><?= $item->id ?></td>

                                <td>
                                    <img src="<?= base_url($item->image) ?>" class="img-responsive"
                                         style="max-width:80px">
                                </td>

                                <td><?= html_escape($item->title) ?></td>

                                <td><?= $item->sort_order ?></td>

                                <td>
                                    <?php if ($item->status == 1): ?>
                                        <span class="label label-success">Active</span>
                                    <?php else: ?>
                                        <span class="label label-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>

                                <td><?= nice_date($item->created_at, 'd.m.Y') ?></td>

                                <td>
                                    <!-- OPTIONS DROPDOWN -->
                                    <?php echo form_open('industries/delete_post'); ?>
                                    <input type="hidden" name="id" value="<?= $item->id ?>">

                                    <div class="dropdown">
                                        <button class="btn bg-purple dropdown-toggle btn-select-option"
                                                data-toggle="dropdown">
                                            Select Option <span class="caret"></span>
                                        </button>

                                        <ul class="dropdown-menu">
                                            <li>
                                                <a href="<?= base_url('industries/update/' . $item->id) ?>">
                                                    <i class="fa fa-edit"></i> Edit
                                                </a>
                                            </li>

                                            <li>
                                                <button type="submit"
                                                    class="btn-list-button"
                                                    onclick="return confirm('Are you sure you want to delete this industry?');">
                                                    <i class="fa fa-trash"></i> Delete
                                                </button>
                                            </li>
                                        </ul>
                                    </div>

                                    <?php echo form_close(); ?>
                                </td>

                            </tr>
                        <?php endforeach; ?>
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>

</div>
