<div class="row">

    <!-- ADD MEMBER FORM -->
    <div class="col-lg-4 col-md-12">
        <div class="box box-primary">

            <div class="box-header with-border">
                <h3 class="box-title">Add Global Presence Member</h3>
            </div>

            <?php echo form_open_multipart('global_presence/add_post'); ?>
            <div class="box-body">

                <?php $this->load->view('admin/includes/_messages_form'); ?>

                <div class="form-group">
                    <label>Name</label>
                    <input type="text" name="member_name" class="form-control" required>
                </div>

                <div class="form-group">
                    <label>Country</label>
                    <input type="text" name="country" class="form-control" required>
                </div>

                <div class="form-group">
                    <label>Sort Order</label>
                    <input type="number" name="sort_order" class="form-control" value="0">
                </div>

                <div class="form-group">
                    <label>Status</label>
                    <select name="status" class="form-control">
                        <option value="1" selected>Active</option>
                        <option value="0">Inactive</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Member Image</label>
                    <div>
                        <a class="btn btn-success btn-sm btn-file-upload">
                            Select Image
                            <input type="file" id="Multifileupload" name="file" size="40" accept=".png, .jpg, .jpeg, .gif" required>
                        </a>
                    </div>
                    <div id="MultidvPreview"></div>
                </div>

            </div>

            <div class="box-footer">
                <button type="submit" class="btn btn-primary pull-right">Add Member</button>
            </div>

            <?php echo form_close(); ?>
        </div>
    </div>



    <!-- MEMBERS LIST TABLE -->
    <div class="col-lg-8 col-md-12">
        <div class="box">

            <div class="box-header with-border">
                <h3 class="box-title">Members List</h3>
            </div>

            <div class="box-body">
                <?php $this->load->view('admin/includes/_messages'); ?>

                <table class="table table-bordered table-striped">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Image</th>
                        <th>Name</th>
                        <th>Country</th>
                        <th>Sort</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Options</th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php foreach ($items as $item): ?>
                        <tr>
                            <td><?= $item->id ?></td>

                            <td><img src="<?= base_url($item->image) ?>" style="max-width:80px"></td>

                            <td><?= html_escape($item->member_name) ?></td>

                            <td><?= html_escape($item->country) ?></td>

                            <td><?= $item->sort_order ?></td>

                            <td>
                                <?php if ($item->status == 1): ?>
                                    <span class="label label-success">Active</span>
                                <?php else: ?>
                                    <span class="label label-danger">Inactive</span>
                                <?php endif; ?>
                            </td>

                            <td><?= nice_date($item->created_at, 'd.m.Y') ?></td>

                            <td>
                                <div class="dropdown">
                                    <button class="btn bg-purple dropdown-toggle btn-select-option"
                                            data-toggle="dropdown">
                                        Select Option <span class="caret"></span>
                                    </button>

                                    <ul class="dropdown-menu">
                                        <li><a href="<?= base_url('global_presence/update/'.$item->id) ?>"><i class="fa fa-edit"></i> Edit</a></li>

                                        <li>
                                            <?php echo form_open('global_presence/delete_post'); ?>
                                            <input type="hidden" name="id" value="<?= $item->id ?>">
                                            <button type="submit" onclick="return confirm('Delete this member?');" class="btn-list-button">
                                                <i class="fa fa-trash"></i> Delete
                                            </button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                            </td>

                        </tr>
                    <?php endforeach; ?>
                    </tbody>

                </table>
            </div>

        </div>
    </div>

</div>
