<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="row">
    <div class="col-sm-12">
        <?php echo form_open_multipart('admin_founders/update_founder_post'); ?>
        <input type="hidden" name="id" value="<?php echo $founder->id; ?>">
        <div class="row">
            <div class="col-sm-12 form-header">
                <h1 class="form-title"><?php echo "Update Founder / Team Member"; ?></h1>
                <a href="<?php echo base_url(); ?>admin_founders/founders" class="btn btn-sm btn-success btn-add-new pull-right">
                    <i class="fa fa-bars"></i>
                    Founders & Team List
                </a>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="form-post">
                    <div class="form-post-left">
                         <div class="form-group">
                            <label class="control-label">Full Name</label>
                            <input type="text" class="form-control" name="name" placeholder="Full Name" value="<?php echo html_escape($founder->name); ?>" required>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Designation</label>
                            <input type="text" class="form-control" name="designation" placeholder="E.g., Co-Founder & Director" value="<?php echo html_escape($founder->designation); ?>" required>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Biography</label>
                            <textarea id="ckEditor" class="form-control" name="bio" placeholder="Biography"><?php echo $founder->bio; ?></textarea>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Facebook URL</label>
                            <input type="text" class="form-control" name="facebook_url" placeholder="Facebook URL" value="<?php echo html_escape($founder->facebook_url); ?>">
                        </div>
                         <div class="form-group">
                            <label class="control-label">Twitter URL</label>
                            <input type="text" class="form-control" name="twitter_url" placeholder="Twitter URL" value="<?php echo html_escape($founder->twitter_url); ?>">
                        </div>
                         <div class="form-group">
                            <label class="control-label">Instagram URL</label>
                            <input type="text" class="form-control" name="instagram_url" placeholder="Instagram URL" value="<?php echo html_escape($founder->instagram_url); ?>">
                        </div>
                         <div class="form-group">
                            <label class="control-label">LinkedIn URL</label>
                            <input type="text" class="form-control" name="linkedin_url" placeholder="LinkedIn URL" value="<?php echo html_escape($founder->linkedin_url); ?>">
                        </div>
                    </div>
                    <div class="form-post-right">
                        <div class="row">
                            <div class="col-sm-12">
                                <?php $this->load->view('admin/includes/_founders_image_edit_box', ['post' => $founder]); ?>
                            </div>
                            <div class="col-sm-12">
                                <div class="box">
                                    <div class="box-header with-border">
                                        <div class="left">
                                            <h3 class="box-title">Publish</h3>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select name="status" class="form-control">
                                                <option value="1" <?php echo ($founder->status == 1) ? 'selected' : ''; ?>>Active</option>
                                                <option value="0" <?php echo ($founder->status == 0) ? 'selected' : ''; ?>>Inactive</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Sort Order</label>
                                            <input type="number" class="form-control" name="sort_order" placeholder="Sort Order" value="<?php echo $founder->sort_order; ?>">
                                        </div>
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary pull-right">Save Changes</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>