<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="box">
    <div class="box-header with-border">
        <div class="left">
            <h3 class="box-title">Founders & Team</h3>
        </div>
        <div class="right">
            <a href="<?php echo base_url(); ?>admin_founders/add_founder" class="btn btn-sm btn-success btn-add-new pull-right">
                <i class="fa fa-plus"></i>
                Add Founder
            </a>
        </div>
    </div><!-- /.box-header -->

    <div class="box-body">
        <div class="row">
            <!-- include message block -->
            <div class="col-sm-12">
                <?php $this->load->view('admin/includes/_messages'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped dataTable" id="cs_datatable_founders" role="grid">
                        <thead>
                            <tr role="row">
                                <th width="20"><?php echo trans('id'); ?></th>
                                <th><?php echo trans('image'); ?></th>
                                <th><?php echo trans('name'); ?></th>
                                <th><?php echo 'designation'; ?></th>
                                <th><?php echo trans('status'); ?></th>
                                <th><?php echo trans('date'); ?></th>
                                <th class="max-width-120"><?php echo trans('options'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($founders as $item): ?>
                            <tr>
                                <td><?php echo html_escape($item->id); ?></td>
                                <td>
                                    <img src="<?php echo !empty($item->image_list)? base_url() . $item->image_list : ""; ?>" alt="image" style="width: 75px; border-radius: 5px;"/>
                                </td>
                                <td><?php echo html_escape($item->name); ?></td>
                                <td><?php echo html_escape($item->designation); ?></td>
                                <td>
                                    <?php if ($item->status == 1): ?>
                                        <label class="label label-success">Active</label>
                                    <?php else: ?>
                                        <label class="label label-danger">Inactive</label>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo nice_date($item->created_at, 'd.m.Y'); ?></td>
                                <td>
                                    <!-- Options dropdown -->
                                    <?php echo form_open('admin_founders/delete_founder_post'); ?>
                                    <input type="hidden" name="id" value="<?php echo html_escape($item->id); ?>">
                                    <div class="dropdown">
                                        <button class="btn bg-purple dropdown-toggle btn-select-option" type="button" data-toggle="dropdown"><?php echo trans('select_option'); ?> <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu pull-right options-list">
                                            <li>
                                                <a href="<?php echo base_url(); ?>admin_founders/update_founder/<?php echo html_escape($item->id); ?>">
                                                    <i class="fa fa-edit i-edit"></i><?php echo trans('edit'); ?></a>
                                            </li>
                                            <li>
                                                <a class="p0">
                                                    <button type="submit" name="option" value="delete" class="btn-list-button" onclick="return confirm('Are you sure you want to delete this item?');">
                                                        <i class="fa fa-trash i-delete"></i><?php echo trans('delete'); ?>
                                                    </button>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <?php echo form_close(); ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div><!-- /.box-body -->
</div>