<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="row">
    <div class="col-sm-12">
        <?php echo form_open_multipart('admin_founders/add_founder_post'); ?>
        <div class="row">
            <div class="col-sm-12 form-header">
                <h1 class="form-title"><?php echo "Add Founder / Team Member"; ?></h1>
                <a href="<?php echo base_url(); ?>admin_founders/founders" class="btn btn-sm btn-success btn-add-new pull-right">
                    <i class="fa fa-bars"></i>
                    Founders & Team List
                </a>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="form-post">
                    <div class="form-post-left">
                        <div class="form-group">
                            <label class="control-label">Full Name</label>
                            <input type="text" class="form-control" name="name" placeholder="Full Name" value="<?php echo old('name'); ?>" required>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Designation</label>
                            <input type="text" class="form-control" name="designation" placeholder="E.g., Co-Founder & Director" value="<?php echo old('designation'); ?>" required>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Biography</label>
                            <textarea id="ckEditor" class="form-control" name="bio" placeholder="Biography"><?php echo old('bio'); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Facebook URL</label>
                            <input type="text" class="form-control" name="facebook_url" placeholder="Facebook URL" value="<?php echo old('facebook_url'); ?>">
                        </div>
                         <div class="form-group">
                            <label class="control-label">Twitter URL</label>
                            <input type="text" class="form-control" name="twitter_url" placeholder="Twitter URL" value="<?php echo old('twitter_url'); ?>">
                        </div>
                         <div class="form-group">
                            <label class="control-label">Instagram URL</label>
                            <input type="text" class="form-control" name="instagram_url" placeholder="Instagram URL" value="<?php echo old('instagram_url'); ?>">
                        </div>
                         <div class="form-group">
                            <label class="control-label">LinkedIn URL</label>
                            <input type="text" class="form-control" name="linkedin_url" placeholder="LinkedIn URL" value="<?php echo old('linkedin_url'); ?>">
                        </div>
                    </div>
                    <div class="form-post-right">
                        <div class="row">
                            <div class="col-sm-12">
                                <?php $this->load->view('admin/includes/_founders_image_upload_box'); ?>
                            </div>
                            <div class="col-sm-12">
                                <div class="box">
                                    <div class="box-header with-border">
                                        <div class="left">
                                            <h3 class="box-title">Publish</h3>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select name="status" class="form-control">
                                                <option value="1" selected>Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Sort Order</label>
                                            <input type="number" class="form-control" name="sort_order" placeholder="Sort Order" value="0">
                                        </div>
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary pull-right">Add Founder</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>