<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Service_admin_model extends CI_Model
{

    //input values
    public function input_values()
    {
        $data = array(
            'page_title' => $this->input->post('page_title', true),
            'page_desc' => $this->input->post('page_desc', true),
            'service_name' => $this->input->post('service_name', true),
            'service_description' => $this->input->post('service_description', false),
            'button_text' => $this->input->post('button_text', false),
            'button_url' => $this->input->post('button_url', false),
            'status' => $this->input->post('status', true),
            'visibility' => $this->input->post('visibility', true),
        );
        return $data;
    }

    //add post
    public function add_service()
    {
         $this->load->model("service_model");
        $data = $this->set_data();
        $date_published = $this->input->post('date_published', true);
        if (!empty($date_published)) {
            $data["created_at"] = $date_published;
        }

       // $data['user_id'] = user()->id;
        $data['status'] = $this->input->post('status', true);
        $data['visibility'] = 1;

        return $this->db->insert('services', $data);
    }
    
    public function get_service_count()
    {
        $query = $this->db->get('services');
        return $query->num_rows();
    }
    //update post
    public function update_service($id)
    {
         $this->load->model("service_model");
        $data = $this->set_data();

        $data["created_at"] = $this->input->post('date_published', true);

        $publish = $this->input->post('publish', true);
        if (!empty($publish) && $publish == 1) {
            $data["status"] = 1;
        }

        //if author set visibility
        /*if (is_author()) {
            $data['status'] = 0;
        }*/

        $data['visibility'] = 1;

        $this->db->where('id', $id);
        return $this->db->update('services', $data);
    }

    //set post data
    public function set_data()
    {
        $data = $this->input_values();
        if (empty($this->input->post('image_url', true))):
            //add post image
             $image = $this->file_model->get_image($this->input->post('post_image_id', true));
            if (!empty($image)) {
                //$data["image"] = $image->image_small;
                $data["image_mid"] = $image->image_mid;
                $data["image_small"] = $image->image_small;
                $data["image_slider"] = $image->image_slider;
            }
        endif;

        return $data;

    }
    //get post
    public function get_services($id)
    {
        $this->db->where('services.id', $id);
        $query = $this->db->get('services');
        return $query->row();
    }
    //get paginated posts
    public function get_paginated_service($per_page, $offset, $list)
    {
       // $this->filter_posts();
       // $this->filter_posts_list($list);
        // $this->db->where('services.visibility', 1);
        // $this->db->where('services.status', 1);
        $this->db->order_by('services.created_at', 'DESC');
        $this->db->limit($per_page, $offset);
        $query = $this->db->get('services');
        return $query->result();
    }

    //get paginated posts count
    public function get_paginated_service_count($list)
    {
        //$this->filter_posts();
        //$this->filter_posts_list($list);
        // $this->db->where('services.visibility', 1);
        // $this->db->where('services.status', 1);
        $query = $this->db->get('services');
        return $query->num_rows();
    }
    //delete post
    public function delete_service($id)
    {
        $post = $this->get_services($id);

        if (!empty($post)):
            $this->db->where('id', $id);
            return $this->db->delete('services');
        else:
            return false;
        endif;
    }

    //delete multi post
    public function delete_multi_services($post_ids)
    {
        if (!empty($post_ids)) {
            foreach ($post_ids as $id) {
                $post = $this->get_services($id);

                if (!empty($post)) {

                    //delete post tags
                   // $this->tag_model->delete_post_tags($id);

                    $this->db->where('id', $id);
                    $this->db->delete('services');
                }
            }
        }

    }
}