<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Product_model extends CI_Model
{
    //input values
    public function input_values()
    {
        $data = array(
            'page_title' => $this->input->post('page_title', true),
            'page_desc' => $this->input->post('page_desc', true),
            'product_title' => $this->input->post('product_title', true),
            'product_video_url' => $this->input->post('product_video_url', true),
            'product_desc' => $this->input->post('product_desc', true),
             'product_price' => $this->input->post('product_price', true),
            'category_id' => $this->input->post('category_id', true),
            'sub_category_id' => $this->input->post('sub_category_id', true),
            'featured_product_status' => $this->input->post('featured_product_status', true),
            'path_big' => $this->input->post('path_big', true),
             'sort_order' => $this->input->post('sort_order', true),
            'path_small' => $this->input->post('path_small', true)
        );
        return $data;
    }

    //add image
    public function add()
    {
        $data = $this->input_values();

        //get file
        $file = $_FILES['file'];
        if (!empty($file['name'])) {
            //upload images
            $data["path_big"] = $this->upload_model->product_big_image_upload($file);
            $data["path_small"] = $this->upload_model->product_small_image_upload($file);
        } else {
            $data['path_big'] = "";
            $data['path_small'] = "";
        }
        
       /* $additional_image = $_FILES['additional_image'];
        if (!empty($additional_image['name'])) {
            //upload images
            $data["additional_image"] = $this->upload_model->product_big_image_upload($additional_image);
        } else {
            $data['additional_image'] = "";
        }*/
        $data1 = array();
        if(!empty($_FILES['additional_image1']['name'])){
            $filesCount = count($_FILES['additional_image1']['name']);
            for($i = 0; $i < $filesCount; $i++){
                $_FILES['file']['name']     = $_FILES['additional_image1']['name'][$i];
                $_FILES['file']['type']     = $_FILES['additional_image1']['type'][$i];
                $_FILES['file']['tmp_name'] = $_FILES['additional_image1']['tmp_name'][$i];
                $_FILES['file']['error']     = $_FILES['additional_image1']['error'][$i];
                $_FILES['file']['size']     = $_FILES['additional_image1']['size'][$i];
                
                // File upload configuration
                $uploadPath = './uploads/product/';
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'jpg|jpeg|png|gif';
                
                // Load and initialize upload library
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                
                // Upload file to server
                if($this->upload->do_upload('file')){
                    // Uploaded file data
                    $fileData = $this->upload->data();
                    array_push($data1,"uploads/product/".$fileData['file_name']); 
                }
            }
            $multiple=implode('*',$data1);
            $data["additional_image1"]=$multiple;
          }

        return $this->db->insert('products', $data);
    }

     public function get_product_count()
    {
        $query = $this->db->get('products');
        return $query->num_rows();
    }  
    
    
    //get gallery images
    public function get_images()
    {
        $this->db->join('product_categories', 'products.category_id = product_categories.id');
        $this->db->select('products.* , product_categories.name as category_name');
        //$this->db->where('products.lang_id', $this->selected_lang->id);
        $this->db->order_by('products.id', 'DESC');
        $query = $this->db->get('products');
        return $query->result();
    }

    //get all gallery images
    public function get_all_products()
    {
        $this->db->join('product_categories', 'products.category_id = product_categories.id');
        $this->db->select('products.* , product_categories.name as category_name');
        $this->db->order_by('products.id', 'DESC');
        $query = $this->db->get('products');
        return $query->result();
    }

    //get gallery images by category
    public function get_images_by_category($category_id)
    {
        $this->db->join('product_categories', 'products.category_id = product_categories.id');
        $this->db->select('products.* , product_categories.name as category_name');
       // $this->db->where('photos.lang_id', $this->selected_lang->id);
        $this->db->where('category_id', $category_id);
        $this->db->order_by('products.id', 'DESC');
        $query = $this->db->get('products');
        return $query->result();
    }

    //get category image count
    public function get_category_image_count($category_id)
    {
        $this->db->where('category_id', $category_id);
     //   $this->db->where('products.lang_id', $this->selected_lang->id);
        $query = $this->db->get('products');
        return $query->num_rows();
    }

    //get image
    public function get_image($id)
    {
        $this->db->where('id', $id);
        $query = $this->db->get('products');
        return $query->row();
    }
     
     //get ajax image id,dataid
     
    
    
    
    //update image
    public function update($id)
    {
        
        $this->db->where('id', $id);
        $query = $this->db->get('products');
        $result=$query->row();
      //echo $result->additional_image1; exit;
        $data = $this->input_values();

        //get file
        $file = $_FILES['file'];

        if (!empty($file['name'])) {
            //delete old image
            $image = $this->get_image($id);

            //delete image
            delete_image_from_server($image->path_big);
            delete_image_from_server($image->path_small);

            //upload new image
            $data["path_big"] = $this->upload_model->product_big_image_upload($file);
            $data["path_small"] = $this->upload_model->product_small_image_upload($file);

            $this->db->where('id', $id);
            return $this->db->update('products', $data);
        }
        
       /* $additional_image = $_FILES['additional_image'];

        if (!empty($additional_image['name'])) {
            //delete old image
            $image = $this->get_image($id);

            //delete image
            delete_image_from_server($image->additional_image);

            //upload new image
            $data["additional_image"] = $this->upload_model->product_big_image_upload($additional_image);

            $this->db->where('id', $id);
            return $this->db->update('products', $data);
        }*/
        $data1 = array();
        if(!empty($_FILES['additional_image1']['name'])){
            
            $filesCount = count($_FILES['additional_image1']['name']);
             //echo $filesCount;exit;
            for($i = 0; $i < $filesCount; $i++){
                $_FILES['file']['name']     = $_FILES['additional_image1']['name'][$i];
                $_FILES['file']['type']     = $_FILES['additional_image1']['type'][$i];
                $_FILES['file']['tmp_name'] = $_FILES['additional_image1']['tmp_name'][$i];
                $_FILES['file']['error']     = $_FILES['additional_image1']['error'][$i];
                $_FILES['file']['size']     = $_FILES['additional_image1']['size'][$i];
                
                // File upload configuration
                $uploadPath = './uploads/product/';
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'jpg|jpeg|png|gif';
                
                // Load and initialize upload library
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                
                // Upload file to server
                if($this->upload->do_upload('file')){
                    // Uploaded file data
                    $fileData = $this->upload->data();
                    array_push($data1,"uploads/product/".$fileData['file_name']); 
                }else{
                 $explode=explode("*",$result->additional_image1);   
                 $image=isset($explode[$i]) ? $explode[$i] :''; 
                 if(!empty($image)){
                 array_push($data1,$image); 
                 }
                }
            }
            $multiple=implode('*',$data1);
            $data["additional_image1"]=$multiple;
          }

        $this->db->where('id', $id);
        return $this->db->update('products', $data);
    }


    //delete image
    public function delete($id)
    {
        $image = $this->get_image($id);

        if (!empty($image)) {
            //delete image
            delete_image_from_server($image->path_big);
            delete_image_from_server($image->path_small);

            $this->db->where('id', $id);
            return $this->db->delete('products');
        } else {
            return false;
        }

    }
}