<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Global_presence_model extends CI_Model
{
    public function input_values()
    {
        return [
            'member_name' => $this->input->post('member_name', true),
            'country'     => $this->input->post('country', true),
            'status'      => $this->input->post('status', true),
            'sort_order'  => $this->input->post('sort_order', true),
        ];
    }

    public function get_all()
    {
        $this->db->order_by("sort_order ASC, id DESC");
        return $this->db->get("global_presence_members")->result();
    }

    public function get($id)
    {
        return $this->db->where("id", $id)->get("global_presence_members")->row();
    }

    public function add()
    {
        $data = $this->input_values();

        if (!empty($_FILES['file']['name'])) {
            $data["image"] = $this->upload_model->global_presence_member_image_upload($_FILES['file']);
        }

        return $this->db->insert("global_presence_members", $data);
    }

    public function update($id)
    {
        $data = $this->input_values();

        if (!empty($_FILES['file']['name'])) {
            $item = $this->get($id);
            delete_image_from_server($item->image);
            $data["image"] = $this->upload_model->global_presence_member_image_upload($_FILES['file']);
        }

        return $this->db->where("id", $id)->update("global_presence_members", $data);
    }

    public function delete($id)
    {
        $item = $this->get($id);
        if ($item) {
            delete_image_from_server($item->image);
            return $this->db->where("id", $id)->delete("global_presence_members");
        }
        return false;
    }
}
