<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Founders_admin_model extends CI_Model
{
    // Set founder data from input
    public function set_data()
    {
        $data = [
            'name' => $this->input->post('name', true),
            'designation' => $this->input->post('designation', true),
            'bio' => $this->input->post('bio', false), // false allows HTML
            'facebook_url' => $this->input->post('facebook_url', true),
            'twitter_url' => $this->input->post('twitter_url', true),
            'instagram_url' => $this->input->post('instagram_url', true),
            'linkedin_url' => $this->input->post('linkedin_url', true),
            'status' => $this->input->post('status', true),
            'sort_order' => $this->input->post('sort_order', true),
        ];

        // Handle image upload
        $imageListId = $this->input->post('post_image_id', true);
        $imageList = $this->file_model->get_image($imageListId);
        if (!empty($imageList)) {
            $data["image_list"] = $imageList->image; // Thumbnail Image
        }

        $imageBioId = $this->input->post('post_image_id_bio', true);
        $imageBio = $this->file_model->get_image($imageBioId);
        if (!empty($imageBio)) {
            $data["image_bio"] = $imageBio->image_big; // Bio/Details Page Image
        }

        return $data;
    }

    // Add new founder
    public function add_founder()
    {
        $data = $this->set_data();
        return $this->db->insert('founders', $data);
    }

    // Update founder
    public function update_founder($id)
    {
        $data = $this->set_data();
        $this->db->where('id', $id);
        return $this->db->update('founders', $data);
    }

    // Get all founders
    public function get_all_founders()
    {
        $this->db->order_by('sort_order, id');
        $query = $this->db->get('founders');
        return $query->result();
    }

    // Get founder by id
    public function get_founder($id)
    {
        $this->db->where('id', $id);
        $query = $this->db->get('founders');
        return $query->row();
    }

    // Delete founder
    public function delete_founder($id)
    {
        $founder = $this->get_founder($id);
        if (!empty($founder)) {
            $this->db->where('id', $id);
            return $this->db->delete('founders');
        }
        return false;
    }
}