<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clients_model extends CI_Model
{
    //input values
    public function input_values()
    {
        $data = array(
            'title' => $this->input->post('title', true),
            'path_big' => $this->input->post('path_big', true),
            'path_small' => $this->input->post('path_small', true),
            'status' => $this->input->post('status', true)
        );
        return $data;
    }
 public function get_clients_count()
    {
        $query = $this->db->get('clients_logo');
        return $query->num_rows();
    }
    //add image
    public function add()
    {
        $data = $this->input_values();

        //get file
        $file = $_FILES['file'];
        if (!empty($file['name'])) {
            //upload images
            // $data["path_big"] = $this->upload_model->clients_logo_big_image_upload($file);
            $data["path_big"] = '';
            $data["path_small"] = $this->upload_model->clients_logo_small_image_upload($file);
        } else {
            $data['path_big'] = "";
            $data['path_small'] = "";
        }

        return $this->db->insert('clients_logo', $data);
    }

    //get gallery images
    public function get_images()
    {
        //$this->db->join('gallery_categories', 'photos.category_id = gallery_categories.id');
        $this->db->select('clients_logo.* ,');
       // $this->db->where('photos.lang_id', $this->selected_lang->id);
        $this->db->order_by('clients_logo.id', 'DESC');
        $query = $this->db->get('clients_logo');
        return $query->result();
    }

    //get all gallery images
    public function get_all_images()
    {
        //$this->db->join('gallery_categories', 'photos.category_id = gallery_categories.id');
        $this->db->select('clients_logo.* , ');
        $this->db->order_by('clients_logo.id', 'DESC');
        $query = $this->db->get('clients_logo');
        return $query->result();
    }

    //get gallery images by category
    public function get_images_by_category($category_id)
    {
       // $this->db->join('gallery_categories', 'photos.category_id = gallery_categories.id');
        $this->db->select('clients_logo.* ,');
        //$this->db->where('photos.lang_id', $this->selected_lang->id);
       // $this->db->where('category_id', $category_id);
        $this->db->order_by('clients_logo.id', 'DESC');
        $query = $this->db->get('clients_logo');
        return $query->result();
    }

    //get image
    public function get_image($id)
    {
        $this->db->where('id', $id);
        $query = $this->db->get('clients_logo');
        return $query->row();
    }

    //update image
    public function update($id)
    {
        $data = $this->input_values();

        //get file
        $file = $_FILES['file'];

        if (!empty($file['name'])) {
            //delete old image
            $image = $this->get_image($id);

            //delete image
            delete_image_from_server($image->path_big);
            delete_image_from_server($image->path_small);

            //upload new image
            // $data["path_big"] = $this->upload_model->clients_logo_big_image_upload($file);
            $data["path_big"] = '';
            $data["path_small"] = $this->upload_model->clients_logo_small_image_upload($file);

            $this->db->where('id', $id);
            return $this->db->update('clients_logo', $data);
        }

        $this->db->where('id', $id);
        return $this->db->update('clients_logo', $data);
    }


    //delete image
    public function delete($id)
    {
        $image = $this->get_image($id);

        if (!empty($image)) {
            //delete image
            // delete_image_from_server($image->path_big);
            delete_image_from_server($image->path_small);

            $this->db->where('id', $id);
            return $this->db->delete('clients_logo');
        } else {
            return false;
        }

    }
}