<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends Admin_Core_Controller
{

    public function __construct()
    {
        parent::__construct();

        //check auth
        if (!is_admin()) {
            redirect('login');
        }
    }


    /**
     * Gallery
     */
    public function products()
    {
        $this->load->model("product_model");
         $this->load->model("product_category_model");
        $data['title'] = "Products";
        $data['images'] = $this->product_model->get_all_products();
        $data['categories'] = $this->product_category_model->get_categories();
        $data['lang_search_column'] = 3;

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/product/products', $data);
        $this->load->view('admin/includes/_footer');
    }
    public function ajax_subcategories()
    {
        $this->load->model("category_model");
        $id = $this->input->post('id', true); 
        $subcat = $this->category_model->product_sub_category($id);
       
        foreach ($subcat as $subcategory):
            echo '<option value=' . $subcategory->id . '">' . $subcategory->name . '</option>';
                 endforeach;
    }

        //get ajax image id,dataid
  
   public function get_ajaximage() {
       
    $this->load->model("product_model");
    $id = $this->input->post('id', true);
    $this->db->where('id', $id);
    $query = $this->db->get('products');
    $result=$query->row();
    $dataid = $this->input->post('dataid', true);
    $explode=explode("*",$result->additional_image1);   
    $image=isset($explode[$dataid]) ? $explode[$dataid] :''; 
    if(!empty($image)){
       unset($explode[$dataid]);            
    }
    $imagedata=implode("*",$explode);
    $data=array('additional_image1'=>$imagedata);
    $this->db->where('id',$id);
    $this->db->update('products',$data);
    }
    
    
    
    /**
     * Add Image Post
     */
    public function add_product_image_post()
    {
        //validate inputs
         $this->load->model("product_model");
          $this->load->model("product_file_model");
         $this->load->model("product_category_model");
        $this->form_validation->set_rules('product_title', "Product Title", 'xss_clean|max_length[500]');
        //$this->form_validation->set_rules('category_id', trans("category"), 'required');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors_form', validation_errors());
            $this->session->set_flashdata('form_data', $this->product_model->input_values());
            redirect($this->agent->referrer());
        } else {
            if ($this->product_model->add()) {
                 $last_id = $this->db->insert_id();
                 $this->product_file_model->add_product_additional_images($last_id);
                $this->session->set_flashdata('success_form', "Product" . " " . trans("msg_suc_added"));
                redirect($this->agent->referrer());
            } else {
                $this->session->set_flashdata('form_data', $this->product_model->input_values());
                $this->session->set_flashdata('error_form', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Update Image
     */
    public function update_product_image($id)
    {
         $this->load->model("product_model");
         $this->load->model("product_category_model");
        $data['title'] = "Update Product";

        //get post
        $data['image'] = $this->product_model->get_image($id);

        if (empty($data['image'])) {
            redirect($this->agent->referrer());
        }

        $data['categories'] = $this->product_category_model->get_categories();
        $data['subcategories'] = $this->category_model->get_all_categories();

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/product/update', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Update Image Post
     */
    public function update_product_image_post()
    {
         $this->load->model("product_model");
         $this->load->model("product_category_model");
        //validate inputs
        $this->form_validation->set_rules('product_title', trans("title"), 'xss_clean|max_length[500]');
       // $this->form_validation->set_rules('category_id', trans("category"), 'required');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->product_model->input_values());
            redirect($this->agent->referrer());
        } else {

            $id = $this->input->post('id', true);

            if ($this->product_model->update($id)) {
                $this->session->set_flashdata('success', "Product" . " " . trans("msg_suc_updated"));
                redirect('product/products');
            } else {
                $this->session->set_flashdata('form_data', $this->product_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Delete Image Post
     */
    public function delete_product_image_post()
    {
         $this->load->model("product_model");
         $this->load->model("product_category_model");
        $id = $this->input->post('id', true);

        if ($this->product_model->delete($id)) {
            $this->session->set_flashdata('success', "Product" . " " . trans("msg_suc_deleted"));
            redirect($this->agent->referrer());
        } else {
            $this->session->set_flashdata('error', trans("msg_error"));
            redirect($this->agent->referrer());
        }
    }


}
