<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class OurWork extends Admin_Core_Controller
{
    public function __construct()
    {
        parent::__construct();

        //check auth
        if (!is_admin()) {
            redirect('login');
        }
    }


    /**
     * Add Page
     */
    public function add_ourwork()
    {
        $data['title'] = "Add Feedback";
        $data['menu_links'] = $this->navigation_model->get_menu_links();

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/ourwork/add', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Add Page Post
     */
    public function add_ourwork_post()
    {
        //validate inputs
        $this->load->model("ourwork_model");
        $this->form_validation->set_rules('title', trans("title"), 'required|xss_clean|max_length[500]');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->ourwork_model->input_values());
            redirect($this->agent->referrer());
        } else {
            if ($this->ourwork_model->add()) {
                $this->session->set_flashdata('success', "Our Work" . " " . trans("msg_suc_added"));
                redirect($this->agent->referrer());
            } else {
                $this->session->set_flashdata('form_data', $this->ourwork_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Pages
     */
    public function ourwork()
    {
        $this->load->model("ourwork_model");
        $data['title'] = "Our Work";
        $data['pages'] = $this->ourwork_model->get_all_ourwork();
        $data['lang_search_column'] = 2;

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/ourwork/ourwork', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Update Page
     */
    public function update_ourwork($id)
    {
         $this->load->model("ourwork_model");
        $data['title'] = "Update Feedback";

        //find page
        $data['page'] = $this->ourwork_model->get_ourwork_by_id($id);

        //page not found
        if (empty($data['page'])) {
            redirect($this->agent->referrer());
        }
        //$data['menu_links'] = $this->navigation_model->get_menu_links_by_lang($data['page']->lang_id);

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/ourwork/update', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Update Page Post
     */
    public function update_ourwork_post()
    {
         $this->load->model("ourwork_model");
        //validate inputs
        $this->form_validation->set_rules('title', trans("title"), 'required|xss_clean|max_length[500]');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->ourwork_model->input_values());
            redirect($this->agent->referrer());
        } else {
            //get id
            $id = $this->input->post('id', true);
            $redirect_url = $this->input->post('redirect_url', true);

            if ($this->ourwork_model->update($id)) {
                $this->session->set_flashdata('success',"Our Work" . " " . trans("msg_suc_updated"));

                if (!empty($redirect_url)) {
                    redirect($redirect_url);
                } else {
                    redirect('ourwork/ourwork');
                }
            } else {
                $this->session->set_flashdata('form_data', $this->ourwork_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Delete Page Post
     */
    public function delete_ourwork_post()
    {
       $this->load->model("ourwork_model");
        $id = $this->input->post('id', true);

        $page = $this->ourwork_model->get_ourwork_by_id($id);

        if (empty($page)) {
            redirect($this->agent->referrer());
        }

        if ($this->ourwork_model->delete($id)) {
            $this->session->set_flashdata('success', "Our Work" . " " . trans("msg_suc_deleted"));
            redirect($this->agent->referrer());
        } else {
            $this->session->set_flashdata('error', trans("msg_error"));
            redirect($this->agent->referrer());
        }
    }


}