<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Industries extends Admin_Core_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) { redirect('login'); }

        $this->load->model("industries_model");
    }

    public function industries()
    {
        $data['title'] = "Industries";
        $data['items'] = $this->industries_model->get_all();
        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/industries/list', $data);
        $this->load->view('admin/includes/_footer');
    }

    public function add_post()
    {
        $this->form_validation->set_rules('title', "Title", 'required|max_length[500]');
        $this->form_validation->set_rules('status', "Status", 'required');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('error_form', validation_errors());
            redirect($this->agent->referrer());
        }

        if ($this->industries_model->add()) {
            $this->session->set_flashdata('success_form', "Industry Added Successfully");
        }

        redirect($this->agent->referrer());
    }

    public function update($id)
    {
        $data['item'] = $this->industries_model->get($id);
        if (empty($data['item'])) redirect($this->agent->referrer());

        $data['title'] = "Update Industry";
        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/industries/update', $data);
        $this->load->view('admin/includes/_footer');
    }

    public function update_post()
    {
        $id = $this->input->post("id", true);

        if ($this->industries_model->update($id)) {
            $this->session->set_flashdata('success', "Industry Updated Successfully");
            redirect(base_url("industries/industries"));
        }

        $this->session->set_flashdata('error', "Error updating record");
        redirect($this->agent->referrer());
    }

    public function delete_post()
    {
        $id = $this->input->post("id", true);

        if ($this->industries_model->delete($id)) {
            $this->session->set_flashdata('success', "Industry Deleted Successfully");
        }

        redirect($this->agent->referrer());
    }
}
