<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Global_presence extends Admin_Core_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) { redirect('login'); }

        $this->load->model("global_presence_model");
    }

    public function members()
    {
        $data['title'] = "Global Presence Members Sliders";
        $data['items'] = $this->global_presence_model->get_all();

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/global_presence/list', $data);
        $this->load->view('admin/includes/_footer');
    }

    public function add_post()
    {
        $this->form_validation->set_rules('member_name', "Name", 'required|max_length[255]');
        $this->form_validation->set_rules('country', "Country", 'required|max_length[255]');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('error_form', validation_errors());
            redirect($this->agent->referrer());
        }

        if ($this->global_presence_model->add()) {
            $this->session->set_flashdata('success_form', "Member Added Successfully");
        }

        redirect($this->agent->referrer());
    }

    public function update($id)
    {
        $data['item'] = $this->global_presence_model->get($id);
        if (empty($data['item'])) redirect($this->agent->referrer());

        $data['title'] = "Update Global Presence Member";

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/global_presence/update', $data);
        $this->load->view('admin/includes/_footer');
    }

    public function update_post()
    {
        $id = $this->input->post("id", true);

        if ($this->global_presence_model->update($id)) {
            $this->session->set_flashdata('success', "Member Updated Successfully");
            redirect(base_url("global_presence/members"));
        }

        $this->session->set_flashdata('error', "Error updating record");
        redirect($this->agent->referrer());
    }

    public function delete_post()
    {
        $id = $this->input->post("id", true);

        if ($this->global_presence_model->delete($id)) {
            $this->session->set_flashdata('success', "Member Deleted Successfully");
        }

        redirect($this->agent->referrer());
    }
}
