<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_service extends Admin_Core_Controller
{

    public function __construct()
    {
        parent::__construct();

        //check auth
        if (!is_admin() && !is_author()) {
            redirect('login');
        }
    }


    /**
     * Add Post
     */
    public function add_service()
    {
         $this->load->model("service_model");
        $data['title'] = "Add Testimonials";
        $data['top_categories'] = $this->service_model->get_services();

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/service/add_service', $data);
        $this->load->view('admin/includes/_footer');
    }

    public function validate_service_button_url($url)
    {
        $url = trim($url);

        // Empty allowed
        if ($url === '') {
            return TRUE;
        }

        // internal URL -> /contact
        if (strpos($url, '/') === 0) {
            return TRUE;
        }

        // external URL -> https://example.com
        if (filter_var($url, FILTER_VALIDATE_URL)) {
            return TRUE;
        }

        // error message
        $this->form_validation->set_message(
            'validate_service_button_url',
            'The {field} must start with "/" or be a valid full URL.'
        );

        return FALSE;
    }

    /**
     * Add Post Post
     */
    public function add_service_service()
    {
        //validate inputs
         $this->load->model("service_admin_model");
       // $this->form_validation->set_rules('page_title', "Page Title", 'required|xss_clean|max_length[500]');
        $this->form_validation->set_rules('service_name', "Banner Name", 'required|xss_clean|max_length[5000]');
       // $this->form_validation->set_rules('designation', "Designation", 'required');
       $this->form_validation->set_rules('description', "Banner Description", 'xss_clean|max_length[7000]');

       $this->form_validation->set_rules('button_text', 'Banner Button Text', 'trim|xss_clean|max_length[255]');

       $this->form_validation->set_rules('button_url', 'Banner Button URL', 'trim|xss_clean|max_length[255]|callback_validate_service_button_url');

       $this->form_validation->set_rules('post_image_id', 'Banner Image', 'required|trim');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->service_admin_model->input_values());
            redirect($this->agent->referrer());
        } else {
            //if post added
            if ($this->service_admin_model->add_service()) {
                //last id
                $last_id = $this->db->insert_id();
                //update slug
               // $this->post_admin_model->update_slug($last_id);
                //insert post tags
               // $this->tag_model->add_post_tags($last_id);

                //$this->post_file_model->add_post_additional_images($last_id);

                $this->session->set_flashdata('success', "Banner" . " " . trans("msg_suc_added"));
                // redirect($this->agent->referrer());
                redirect('admin_service/services');
            } else {
                $this->session->set_flashdata('form_data', $this->service_admin_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Posts
     */
    public function services()
    {
        $this->load->model("service_admin_model");
        $data['title'] = "Testimonials";
        $data['authors'] = $this->auth_model->get_authors();
        $data['form_action'] = "admin_service/services";
        $data['list_type'] = "Testimonials";
        //get paginated posts
        $pagination = $this->paginate(base_url() . 'admin_service/services', $this->service_admin_model->get_paginated_service_count('services'));
        $data['testimonials'] = $this->service_admin_model->get_paginated_service($pagination['per_page'], $pagination['offset'], 'services');

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/service/services', $data);
        $this->load->view('admin/includes/_footer');
    }

    /**
     * Update Post
     */
    public function update_service($id)
    {
        
        $this->load->model("service_admin_model");
        $data['title'] = "Update Services";

        //get post
        $data['post'] = $this->service_admin_model->get_services($id);

        if (empty($data['post'])) {
            redirect($this->agent->referrer());
        }

        //check if author
        if (is_author()) {
            //check owner
            if ($data['post']->user_id != user()->id):
                redirect("admin");
            endif;
        }

        //combine post tags
        $tags = "";
        $count = 0;
        $tags_array = $this->tag_model->get_post_tags($id);
        foreach ($tags_array as $item) {
            if ($count > 0) {
                $tags .= ",";
            }
            $tags .= $item->tag;
            $count++;
        }

        $data['tags'] = $tags;
        //$data['post_images'] = $this->post_file_model->get_post_additional_images($id);
        //$data['categories'] = $this->category_model->get_categories_by_lang($data['post']->lang_id);
        //$data['subcategories'] = $this->category_model->get_subcategories_by_parent_id($data['post']->category_id);

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/service/update_service', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Update Testimonial  Testimonial
     */
    public function update_service_service()
    {
       //validate inputs
         $this->load->model("service_admin_model");

        // Get ID from form
        $id = $this->input->post('id', true);

        // Load existing data from DB
        $post = $this->service_admin_model->get_services($id);

        //VALIDATION RULES
       $this->form_validation->set_rules('service_name', "Banner Name", 'required|xss_clean|max_length[5000]');
       // $this->form_validation->set_rules('page_title', "Page Title", 'required|xss_clean|max_length[500]');
       // $this->form_validation->set_rules('designation', "Designation", 'required');
       $this->form_validation->set_rules('description', "Banner Description", 'xss_clean|max_length[7000]');

       $this->form_validation->set_rules('button_text', 'Banner Button Text', 'trim|xss_clean|max_length[255]');

       $this->form_validation->set_rules('button_url', 'Banner Button URL', 'trim|xss_clean|max_length[255]|callback_validate_service_button_url');

        // IMAGE VALIDATION
       if (empty($post->image_slider)) {
            // Old image does NOT exist -> new image required
            $this->form_validation->set_rules('post_image_id', 'Banner Imagew', 'required|trim');
       } else {
            // Old image exists -> new image optional
            $this->form_validation->set_rules('post_image_id', 'Banner Images', 'trim');
       }
        
       if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->service_admin_model->input_values());
            redirect($this->agent->referrer());
        } else {
            //post id
            $post_id = $this->input->post('id', true);

            if ($this->service_admin_model->update_service($post_id)) {

                //update slug
               // $this->post_admin_model->update_slug($post_id);

                //update post tags
                //$this->tag_model->update_post_tags($post_id);

                //$this->post_file_model->add_post_additional_images($post_id);

                $this->session->set_flashdata('success', "Banner" . " " . trans("msg_suc_updated"));

                $referrer = $this->input->post("referrer");
                if (!empty($referrer)) {
                    redirect($referrer);
                } else {
                    redirect('admin_services/services');
                }

            } else {
                $this->session->set_flashdata('form_data', $this->service_admin_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }

    /**
     * Post Options Post
     */
    public function service_options_service()
    {
         $this->load->model("service_admin_model");
        $option = $this->input->post('option', true);
        $id = $this->input->post('id', true);

        $data["post"] = $this->service_admin_model->get_services($id);

        //check if exists
        if (empty($data['post'])) {
            redirect($this->agent->referrer());
        }
        //if option delete
        if ($option == 'delete') {

            if ($this->service_admin_model->delete_service($id)) {
                //delete post tags
               // $this->tag_model->delete_post_tags($id);

                $this->session->set_flashdata('success', "Banner" . " " . trans("msg_suc_deleted"));
                redirect($this->agent->referrer());
            } else {
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }

        }
    }

    /**
     * Delete Selected Posts
     */
    public function delete_selected_services()
    {
       // $this->load->model("testimonials_admin_model");
        $post_ids = $this->input->post('post_ids', true);
        $this->service_admin_model->delete_multi_services($post_ids);
    }


    /**
     * Save Home Slider Post Order
     */
    public function home_slider_posts_order_post()
    {
        $post_id = $this->input->post('id', true);
        $order = $this->input->post('slider_order', true);
        $this->post_admin_model->save_home_slider_post_order($post_id, $order);
        redirect($this->agent->referrer());
    }


    /**
     * Delete Additional Image
     */
    public function delete_post_additional_image()
    {
        $file_id = $this->input->post('file_id', true);
        $this->post_file_model->delete_post_additional_image($file_id);
    }


    public function set_pagination_per_page($count)
    {
        $_SESSION['pagination_per_page'] = $count;
        redirect($this->agent->referrer());
    }
}
