<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_founders extends Admin_Core_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('founders_admin_model');
        //check auth
        if (!is_admin()) {
            redirect('login');
        }
    }

    /**
     * Founders List
     */
    public function founders()
    {
        $data['title'] = "Founders & Team";
        $data['founders'] = $this->founders_admin_model->get_all_founders();
        
        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/founders/founders', $data);
        $this->load->view('admin/includes/_footer');
    }

    /**
     * Add Founder
     */
    public function add_founder()
    {
        $data['title'] = "Add Founder / Team Member";
        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/founders/add_founder', $data);
        $this->load->view('admin/includes/_footer');
    }

    /**
     * Add Founder Post
     */
    public function add_founder_post()
    {
        //validate inputs
        $this->form_validation->set_rules('name', "Name", 'required|xss_clean|max_length[255]');
        $this->form_validation->set_rules('designation', "Designation", 'required|xss_clean|max_length[255]');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->founders_admin_model->input_values());
            redirect($this->agent->referrer());
        } else {
            if ($this->founders_admin_model->add_founder()) {
                $this->session->set_flashdata('success', "Founder added successfully");
                redirect('admin_founders/founders');
            } else {
                $this->session->set_flashdata('form_data', $this->founders_admin_model->input_values());
                $this->session->set_flashdata('error', "An error occurred.");
                redirect($this->agent->referrer());
            }
        }
    }

    /**
     * Update Founder
     */
    public function update_founder($id)
    {
        $data['title'] = "Update Founder / Team Member";
        $data['founder'] = $this->founders_admin_model->get_founder($id);

        if (empty($data['founder'])) {
            redirect('admin_founders/founders');
        }

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/founders/update_founder', $data);
        $this->load->view('admin/includes/_footer');
    }

    /**
     * Update Founder Post
     */
    public function update_founder_post()
    {
        $this->form_validation->set_rules('name', "Name", 'required|xss_clean|max_length[255]');
        $this->form_validation->set_rules('designation', "Designation", 'required|xss_clean|max_length[255]');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->founders_admin_model->input_values());
            redirect($this->agent->referrer());
        } else {
            $id = $this->input->post('id', true);
            if ($this->founders_admin_model->update_founder($id)) {
                $this->session->set_flashdata('success', "Founder updated successfully");
                redirect('admin_founders/founders');
            } else {
                $this->session->set_flashdata('error', "An error occurred.");
                redirect($this->agent->referrer());
            }
        }
    }

    /**
     * Delete Founder Post
     */
    public function delete_founder_post()
    {
        $id = $this->input->post('id', true);
        if ($this->founders_admin_model->delete_founder($id)) {
            $this->session->set_flashdata('success', "Founder deleted successfully");
        } else {
            $this->session->set_flashdata('error', "An error occurred.");
        }
        redirect($this->agent->referrer());
    }
}