<?php
require_once '../includes/config.php';
require_once '../includes/Database.php';
require_once '../includes/functions.php';

// Only allow POST and verify form submission
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['newsletter-subscription'])) {
    redirect_to('../');
}

// Detect referring page (go back)
$backUrl = $_SERVER['HTTP_REFERER'] ?? null;

// Fallback if no referer
if (!$backUrl) {
    $backUrl = '../';
}

// Prevent external redirects
$host = $_SERVER['HTTP_HOST'];
if (strpos($backUrl, $host) === false) {
    $backUrl = '../';
}

// Input
$email = trim($_POST['email'] ?? '');

// Validate email
if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    set_flash_message("newsletter_message", [
        "type" => "error",
        "text" => "Please enter a valid email address."
    ]);

    set_flash_message("newsletter_old_session_email", $email);

    redirect_to($backUrl);
}

$db = new Database();

// Check duplicate
$exists = $db->selectOne("SELECT email FROM newsletters WHERE email = ?", [$email]);

if ($exists) {
    set_flash_message("newsletter_message", [
        "type" => "info",
        "text" => "You are already subscribed!"
    ]);

    // set_flash_message("newsletter_old_session_email", $email);

    redirect_to($backUrl);
}

// Insert
$save = $db->execute(
    "INSERT INTO newsletters (email, created_at) VALUES (?, NOW())",
    [$email]
);

if ($save) {
    set_flash_message("newsletter_message", [
        "type" => "success",
        "text" => "Thank you! You’ve successfully subscribed."
    ]);
} else {
    set_flash_message("newsletter_message", [
        "type" => "error",
        "text" => "Something went wrong. Please try again."
    ]);

    set_flash_message("newsletter_old_session_email", $email);
}

// Final GO BACK redirect
redirect_to($backUrl);
