<?php
// Override page title and description (enable only if needed for SEO purposes)
// $pageTitle = 'About Us - ASPPL';
// $pageDescription = 'About ASPPL - Associated Search Professionals Pvt Ltd';

// Set current page url name(Note: Don't change this name as it is used in header.php)
$currentPageUrlName = 'about';

$headerCssAndScriptFiles = [
    'css' => ["assets/css/aboutpage-custom-styles.css"],
];

$footerScriptFiles = ['js'  => []];

include 'includes/header.php';
?>
    <!-- main-area -->
    <main class="main-area fix">


        <!-- breadcrumb-area -->
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">About Us</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">About us</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

        <!-- about-area -->
        <section class="about__area section-py-130">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-6 col-md-9">
                        <div class="about__img-wrap">
                            <div class="about__images">
                                <img src="assets/img/images/about_img01.jpg" alt="img">
                                <img src="assets/img/images/about_img02.jpg" alt="img" data-aos="fade-up" data-aos-delay="200">
                            </div>
                            <div class="experience__wrap" data-aos="fade-left" data-aos-delay="200">
                                <h2 class="count">15+</h2>
                                <span>Years of <br> Experience</span>
                            </div>
                            <div class="profit__wrap" data-parallax='{"x" : 50 }'>
                                <div class="thumb">
                                    <img src="assets/img/images/profit_grap.svg" alt="img">
                                </div>
                                <div class="content">
                                    <h5 class="title">500+</h5>
                                    <span>Active Clients</span>
                                </div>
                            </div>
                            <div class="shape">
                                <img src="assets/img/images/about_shape01.svg" alt="shape" data-aos="fade-up-right" data-aos-delay="600">
                                <img src="assets/img/images/about_shape02.svg" alt="shape" class="alltuchtopdown">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="about__content">
                            <div class="section__title mb-15">
                                <span class="sub-title">Behind Our History</span>
                                <h2 class="title">Empowering organizations through leadership excellence.</h2>
                            </div>
                            <p>Associated Search Professionals Private Limited., (short form: ASPPL) founded by team of Passionate recruiters in the year 2010, a company incorporated under the Companies Act 1956, having registration number (CIN: U74140KA2010PTC053637) with registered office at No 623, HMT Main Road, Mathikere, Bangalore – 560 054., India</p>
                            <div class="about__inner-wrap">
                                <div class="about__list-box">
                                    <div class="about__list-box-item">
                                        <!--<div class="icon">-->
                                        <!--    <i class="flaticon-growth"></i>-->
                                        <!--</div>-->
                                        <div class="content">
                                            <h4 class="title">10000+ <br> Fitment to date</h4>
                                        </div>
                                    </div>
                                    <div class="about__list-box-item">
                                        <!--<div class="icon">-->
                                        <!--    <i class="flaticon-pie-chart-1"></i>-->
                                        <!--</div>-->
                                        <div class="content">
                                            <h4 class="title">250+ <br> CXO Searches</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="about__inner-content">
                                    <p>in the past 15+ years ASPPL has made a benchmark in the industry by recruiting over 10000+ professionals across 400+ clients, our team of 40+ consultants spans across 10+ industry verticals with offices across 6 regions within the country brings in enormous knowledge and expertise and creating huge value proposition to the clients.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="core-business mt-4">
    <h6 class="title mb-2" style="font-weight: 700;">Our Core Business:</h6>
    <ul style="list-style-type: disc; padding-left: 20px; margin-bottom: 20px;">
        <li style="margin-bottom: 5px;">Executive Search & Selection</li>
        <li style="margin-bottom: 5px;">Contingent Hiring</li>
        <li style="margin-bottom: 5px;">Turn Key Recruitment Services (RPO)</li>
    </ul>
</div>
                            <p> 

ASPPL Global Network: ASPPL ‘a Member of Global Executive Search Network Consortium’ Lens & Lumen Advisory Group.</p>
<p>ASPPL is also a partner member of Lens & Lumen Advisory A global executive search network based in Europe having presence in USA, Australia, Africa and Asia, with partner members across countries like Belgium, Czech Republic, China, Denmark, France, Germany, Italy, the Netherlands, Norway, South Africa, Spain, Sweden, Switzerland, the UK, and the USA. </p>

<p>Through our global network, ASPPL supports clients across the world for their key talent needs. Each partner member in the respective country carries immense knowledge and expertise in the local geography and have proven track record of leading searches for C- level positions and assisting companies in their international expansion for several years. </p>

<p>Lense & Lumen Advisory Group will provide seamless Executive Search and HR & Leadership Consulting services for clients around the Globe with a strong professional and ambitious spirit!

                            </p>
                        </div>
                </div>
            </div>
        </section>
        <!-- about-area-end -->
        
        <!-- services-area -->
        <section class="services__area fix section-py-130 services__bg" data-background="assets/img/bg/services_bg.png">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-8">
                        <div class="section__title text-center mb-50">
                            <!--<span class="sub-title">Our Dedicated Services</span>-->
                            <h2 class="title">Our Services</h2>
                        </div>
                    </div>
                </div>
                <div class="swiper-container services-active fix">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="services__item shine__animate-item">
                                <div class="services__thumb shine__animate-link">
                                    <a href="retained-search"><img src="assets/img/homepage/retainer-search-hp.jpg" alt="img"></a>
                                    <!--<div class="services__icon">-->
                                    <!--    <i class="flaticon-investment"></i>-->
                                    <!--</div>-->
                                </div>
                                <div class="services__content">
                                    <h3 class="title"><a href="retained-search">Retained Search(Executive Search/ C Suit/ Board Hire) </br><br>  </a></h3>
                                    <p>Secure transformative C-suite leaders through a bespoke, research-backed methodology designed for your most critical strategic mandates.</p>
                                    <a href="#" class="link-btn">Read More <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                                </div>
                                <div class="services__item-shape">
                                    <img src="assets/img/services/services_item_shape.svg" alt="shape">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="services__item shine__animate-item">
                                <div class="services__thumb shine__animate-link">
                                    <a href="contingent-search"><img src="assets/img/homepage/contingent-search-hp.jpg" alt="img"></a>
                                    <!--<div class="services__icon">-->
                                    <!--    <i class="flaticon-report"></i>-->
                                    <!--</div>-->
                                </div>
                                <div class="services__content">
                                    <h3 class="title"><a href="contingent-search"> Contingent Search(Succuss Based mid to Senior/ Commitment & Exclusivity) </a></h3>
                                    <p>Accelerate hiring for mid-to-senior roles with our risk-free, success-based model that prioritizes speed without compromising on quality.</p>
                                    <a href="#" class="link-btn">Read More <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                                </div>
                                <div class="services__item-shape">
                                    <img src="assets/img/services/services_item_shape.svg" alt="shape">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="services__item shine__animate-item">
                                <div class="services__thumb shine__animate-link">
                                    <a href="rpo"><img src="assets/img/homepage/rpo-hp.jpg" alt="img"></a>
                                    <!--<div class="services__icon">-->
                                    <!--    <i class="flaticon-target"></i>-->
                                    <!--</div>-->
                                </div>
                                <div class="services__content">
                                    <h3 class="title"><a href="rpo"> Recruitment Process Outsourcing(RPO)<br></a></h3>
                                    <p>We act as an extension of your HR team, managing the entire acquisition lifecycle to reduce cost-per-hire and improve scalability.</p> </br>
                                    <a href="#" class="link-btn">Read More <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                                </div>
                                <div class="services__item-shape">
                                    <img src="assets/img/services/services_item_shape.svg" alt="shape">
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="services__item shine__animate-item">
                                <div class="services__thumb shine__animate-link">
                                    <a href="staffing"><img src="assets/img/homepage/staffing-hp-1.jpg" alt="img"></a>
                                    <!--<div class="services__icon">-->
                                    <!--    <i class="flaticon-accountant"></i>-->
                                    <!--</div>-->
                                </div>
                                <div class="services__content">
                                    <h3 class="title"><a href="staffing">Staffing<br><br><br></a></h3>
                                    <p>lexible workforce solutions providing immediate access to pre-vetted professionals for project-based needs and seasonal peaks.</p>
                                    <a href="#" class="link-btn">Read More <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                                </div>
                                <div class="services__item-shape">
                                    <img src="assets/img/services/services_item_shape.svg" alt="shape">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="services__shape-wrap">
                <img src="assets/img/services/services_shape01.svg" alt="shape" data-aos="fade-down-left" data-aos-delay="400">
                <img src="assets/img/services/services_shape02.svg" alt="shape" data-aos="fade-up-right" data-aos-delay="400">
            </div>
        </section>
        <!-- services-area-end -->
        
        
        <!-- industries-area -->
        <?php
            $industries = $db->select("SELECT title, image FROM industries WHERE status='1' ORDER BY sort_order ASC, id DESC");
            if (!empty($industries)):
        ?>
            <section class="industries__area mb-5 mt-1">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-7 col-lg-9">
                        <div class="section__title text-center mb-50">
                            <span class="sub-title">WE PROVIDE EXPERTS IN ALMOST EVERY FIELD</span>
                            <h2 class="title">Industries We Have Expertise In</h2>
                        </div>
                    </div>
                </div>
        
                <div class="slider-mask">
                    <div class="swiper-container industries-active">
                        <div class="swiper-wrapper">
        
                            <?php foreach ($industries as $industry): ?>
        
                                <?php
                                    $industryTitle = !empty($industry['title'])
                                        ? escape_html($industry['title'])
                                        : 'Industry';
        
                                    $industryImage = !empty($industry['image'])
                                        ? "admin/" . escape_html($industry['image'])
                                        : ""; // fallback
                                ?>
        
                                <div class="swiper-slide">
                                    <div class="industries__item">
                                        <div class="industries__thumb">
                                            <img src="<?= $industryImage ?>" alt="<?= $industryTitle ?>">
                                        </div>
                                        <div class="industries__bottom"><p><?= $industryTitle ?></p></div>
                                    </div>
                                </div>
        
                            <?php endforeach; ?>
        
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php endif; ?>
        <!-- industries-area-end -->
        
        <!-- timeline-area -->
       <section id="full-timeline" class="attractive-timeline-section section-py-130">
    <style>
        /* --- CSS STYLES --- */
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');

        :root {
            --timeline-gradient: linear-gradient(180deg, #d55bad 0%, #6866e9 50%, #2db7da 100%);
            --text-main: #333;
            --text-sub: #555;
            --card-bg: #f8f9fa;
        }

        .section-py-130 {
            padding: 80px 0;
            background: #fff;
            font-family: 'Poppins', sans-serif;
            overflow: hidden; 
        }

        .section__title .title {
            font-size: 2.5rem;
            color: #333;
            font-weight: 700;
        }
        .section__title .sub-title {
            color: #6866e9;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
            display: block;
            margin-bottom: 10px;
        }

        /* --- THE WAVY TIMELINE CONTAINER --- */
        .wavy-timeline-container {
            position: relative;
            max-width: 1000px;
            margin: 50px auto 0;
            padding-bottom: 50px;
            /* Establish stacking context for children */
            z-index: 1;
        }

        /* The SVG Background Line */
        .timeline-svg {
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 200px; 
            height: 100%;
            /* Put SVG behind content using negative z-index relative to container */
            z-index: -1;
            pointer-events: none;
        }

        /* The Gradient Path Style */
        .timeline-path {
            fill: none;
            stroke: url(#timelineGrad); 
            stroke-width: 15px;
            stroke-linecap: round;
        }

        /* --- TIMELINE ITEMS --- */
        .timeline-row {
            display: flex;
            align-items: center;
            position: relative;
            margin-bottom: 75px;
            min-height: 120px;
            /* Ensure rows are above the SVG line */
            z-index: 2; 
        }

        .timeline-row.left { justify-content: flex-start; }
        .timeline-row.right { justify-content: flex-end; }
        
        /* The Card Area */
        .timeline-content {
            width: 42%;
            position: relative;
        }
        
        .timeline-row.left .timeline-content { text-align: right; padding-right: 65px; }
        .timeline-row.right .timeline-content { text-align: left; padding-left: 65px; }

        /* The Card Design */
        .content-card {
            background: #f4f6f8;
            padding: 20px 25px;
            border-radius: 40px; 
            box-shadow: 0 5px 20px rgba(0,0,0,0.05);
            transition: transform 0.3s ease;
            border: 1px solid #eee;
        }

        .content-card:hover {
            transform: scale(1.03);
            background: #fff;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border-color: #d55bad;
        }

        .content-card p {
            margin: 0;
            color: var(--text-sub);
            font-size: 14px;
            line-height: 1.5;
        }

        /* --- THE CENTRAL CIRCLE (YEAR) --- */
        .year-circle {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 100px;
            /* Ensure background is solid white to cover the line */
            background: #fff;
            border-radius: 50%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.15);
            /* Ensure z-index is high enough to sit on top */
            z-index: 3;
            border: 4px solid #fff;
        }

        .year-circle h5 {
            margin: 0;
            font-weight: 700;
            color: #444;
            font-size: 16px;
            text-align: center;
            line-height: 1.1;
        }

        .year-circle span {
            display: block;
            font-size: 12px;
            color: #888;
            font-weight: 500;
            margin-top: 3px;
            text-transform: uppercase;
        }

        /* --- MOBILE RESPONSIVENESS --- */
        @media (max-width: 768px) {
            .timeline-svg { display: none; } 
            
            .wavy-timeline-container::before {
                content: '';
                position: absolute;
                left: 30px;
                top: 0;
                bottom: 0;
                width: 4px;
                background: #e0e0e0;
                z-index: 0;
            }

            .timeline-row {
                flex-direction: column;
                align-items: flex-start;
                margin-bottom: 40px;
                min-height: auto;
            }

            .year-circle {
                position: static;
                transform: none;
                width: 70px;
                height: 70px;
                margin-left: 0;
                margin-bottom: 15px;
                box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            }
            
            .year-circle h5 { font-size: 13px; }
            .year-circle span { font-size: 10px; }

            .timeline-content {
                width: 100%;
                padding: 0 0 0 20px !important;
                text-align: left !important;
            }

            .content-card {
                border-radius: 15px;
            }
        }
    </style>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <div class="section__title text-center mb-60">
                    <span class="sub-title">Our Journey of Growth</span>
                    <h2 class="title">History & Milestones</h2>
                </div>
            </div>
        </div>

        <div class="wavy-timeline-container">
            
            <svg class="timeline-svg" viewBox="0 0 200 2000" preserveAspectRatio="none">
                <defs>
                    <linearGradient id="timelineGrad" x1="0%" y1="0%" x2="0%" y2="100%">
                        <stop offset="0%" style="stop-color:#d55bad" />
                        <stop offset="50%" style="stop-color:#6866e9" />
                        <stop offset="100%" style="stop-color:#2db7da" />
                    </linearGradient>
                </defs>
                <path class="timeline-path" d="
                        M100,0 
                        C100,50 200,100 200,180 
                        C200,260 0,260 0,370 
                        C0,480 200,480 200,560 
                        C200,640 0,640 0,750 
                        C0,860 200,860 200,940
                        C200,1020 0,1020 0,1130
                        C0,1240 200,1240 200,1320
                        C200,1400 0,1400 0,1510
                        C0,1620 200,1620 200,1700
                        C200,1780 100,1790 100,1800
                        C100,1850 0,1880 0,1900
                        C0,1950 100,1990 100,2000" />
            </svg>

            <div class="timeline-row left">
                <div class="year-circle">
                    <h5>Aug<br><span>2010</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Started in 2 locations with 5 consultants and 2 founders.</p>
                    </div>
                </div>
            </div>

            <div class="timeline-row right">
                <div class="year-circle">
                    <h5>FY<br><span>2011</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Achieved operational breakeven in 08 months, Made firm profitable, within one year reached to 12 Consultants.</p>
                    </div>
                </div>
            </div>

            <div class="timeline-row left">
                <div class="year-circle">
                    <h5>FY<br><span>2011</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Done our first annual conference in Sri Lanka in the FY 2011.</p>
                    </div>
                </div>
            </div>

            <div class="timeline-row right">
                <div class="year-circle">
                    <h5>2012<br><span>2014</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Set up office in Mumbai in 2012 and in Delhi in 2014.</p>
                    </div>
                </div>
            </div>

            <div class="timeline-row left">
                <div class="year-circle">
                    <h5>April<br><span>2014</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Reached 500th Fitment in 2014 April.</p>
                    </div>
                </div>
            </div>

            <div class="timeline-row right">
                <div class="year-circle">
                    <h5>Top<br><span>Rewards</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Sponsored Top Performers to international tour destinations to Sri Lanka, Paris, Greece, Kenya, Dubai, Malaysia, Vietnam, Hong Kong, Thailand, andSingapore.</p>
                    </div>
                </div>
            </div>

             <div class="timeline-row left">
                <div class="year-circle">
                    <h5>2018<br><span>RPO</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Started RPO in 2018 with Ather, 2W EV OEM.</p>
                    </div>
                </div>
            </div>

            <div class="timeline-row right">
                <div class="year-circle">
                    <h5>2019<br><span>CII</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Became Member of CII (Confederation of Indian Industry) in 2019.</p>
                    </div>
                </div>
            </div>

            <div class="timeline-row left">
                <div class="year-circle">
                    <h5>2020<br><span>2021</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Achieved Pan India Presence with 6 Regional offices and 40+ full time associates</p>
                    </div>
                </div>
            </div>

            <div class="timeline-row right">
                <div class="year-circle">
                    <h5>2025<br><span>Partner</span></h5>
                </div>
                <div class="timeline-content">
                    <div class="content-card">
                        <p>Became Global with L&L Alliance in 2025.</p>
                    </div>
                </div>
            </div>

            <div class="timeline-row left">
                <div class="year-circle" style="border-color: #2db7da;">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#2db7da" stroke-width="3" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="19" x2="12" y2="5"></line>
                        <polyline points="5 12 12 5 19 12"></polyline>
                    </svg>
                    <span style="color: #2db7da; margin-top: 5px;">Future</span>
                </div>
                <div class="timeline-content">
                    <div class="content-card" style="border-bottom: 4px solid #2db7da;">
                        <h6 style="color: #333; font-weight: 700; margin-bottom: 5px;">The Journey Continues...</h6>
                        <p>And many more milestones to achieve. We are committed to continuous growth, innovation, and expanding our global footprint.</p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>
        <!-- timeline-area-end -->

        <!-- cta-area -->
        <section class="cta__area-two">
            <div class="container">
                <div class="cta__inner-wrap-two">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="cta__content-three">
                                <h2 class="title">To know more</h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="cta__content-right">
                                <div class="cta__contact">
                                    <div class="icon">
                                        <i class="flaticon-email"></i>
                                    </div>
                                    <div class="content">
                                        <!--<span>Call For More Info</span>-->
                                        <a href="mailto:connect@asppl.in">connect@asppl.in</a>
                                    </div>
                                </div>
                                <a href="<?php echo isset($projectBasePath)? htmlspecialchars($projectBasePath, ENT_QUOTES, 'UTF-8') : ""; ?>/contact" class="tg-btn tg-border-btn ">Reach Us <img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></a>
                            </div>
                        </div>
                    </div>
                    <div class="cta__shape-three">
                        <img src="assets/img/images/h2_cta_shape.svg" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- cta-area-end -->

        <!-- founders-area -->
        <?php
            $aboutFounders = $db->select("
                SELECT id, name, designation, image_list, 
                       facebook_url, twitter_url, instagram_url, linkedin_url
                FROM founders 
                WHERE status = '1' 
                ORDER BY sort_order ASC, id DESC
            ");
        ?>
        <?php if (!empty($aboutFounders)): ?>
            <section class="team__area-three section-py-130">
            <div class="container">
        
                <!-- Section Header -->
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="section__title mb-50 mb-md-30">
                            <h2 class="title">Meet Our <br> Founders</h2>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="section__content mb-50">
                            <p>Our founders are the pillars behind ASPPL’s vision and growth. Meet the leaders who built the foundation of excellence.</p>
                        </div>
                    </div>
                </div>
        
                <!-- Dynamic Founders -->
                <div class="row gutter-y-30 justify-content-center">
        
                    <?php foreach ($aboutFounders as $f): ?>
        
                        <?php
                            $fid  = (int) $f['id'];
                            $name = escape_html($f['name']);
                            $designation = escape_html($f['designation']);
        
                            // Founder Image
                            $image = !empty($f['image_list'])
                                ? "admin/" . escape_html($f['image_list'])
                                : "assets/img/team/default-founder.jpg";
        
                            // Founder details URL
                            $detailsUrl = (isset($projectBasePath) ? escape_html($projectBasePath) : "") 
                                          . "/founder-details?id=" . $fid;
        
                            // Social links
                            $socialLinks = [
                                "facebook"  => trim($f["facebook_url"]),
                                "twitter"   => trim($f["twitter_url"]),
                                "instagram" => trim($f["instagram_url"]),
                                "linkedin"  => trim($f["linkedin_url"])
                            ];
        
                            // Matching icon files (same as homepage)
                            $socialIcons = [
                                "facebook"  => "assets/img/icons/facebook.svg",
                                "twitter"   => "assets/img/icons/twitter.svg",
                                "instagram" => "assets/img/icons/instagram.svg",
                                "linkedin"  => "assets/img/icons/linkedin.svg",
                            ];
                        ?>
        
                        <div class="col-xl-3 col-lg-4 col-sm-6">
                            <div class="team__item-three">
        
                                <!-- Image -->
                                <div class="team__thumb-three">
                                    <img src="<?= $image ?>" alt="<?= $name ?>">
                                </div>
        
                                <!-- Content -->
                                <div class="team__content-three">
                                    <h2 class="title">
                                        <a href="<?= $detailsUrl ?>"><?= $name ?></a>
                                    </h2>
        
                                    <span><?= $designation ?></span>
        
                                    <!-- Social Icons -->
                                    <div class="team__social-three">
                                        <ul class="list-wrap">
                                            <?php foreach ($socialLinks as $key => $url): ?>
                                                <?php if (!empty($url)): ?>
                                                    <li>
                                                        <a href="<?= escape_html($url) ?>" target="_blank" rel="noopener noreferrer">
                                                            <img src="<?= $socialIcons[$key] ?>" class="injectable" alt="<?= $key ?>">
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
        
                                </div>
        
                            </div>
                        </div>
        
                    <?php endforeach; ?>
        
                </div>
            </div>
        </section>
        <?php endif; ?>
        <!-- founders-area-end -->

        <!-- testimonial-area -->
        <!--<section class="testimonial__area testimonial__area-six fix">-->
        <!--    <div class="container">-->
        <!--        <div class="row justify-content-center">-->
        <!--            <div class="col-xl-10">-->
        <!--                <div class="testimonial__wrap">-->
        <!--                    <div class="swiper-container fix testimonial-active">-->
        <!--                        <div class="swiper-wrapper">-->
        <!--                            <div class="swiper-slide">-->
        <!--                                <div class="testimonial__item">-->
        <!--                                    <div class="testimonial__icon">-->
        <!--                                        <img src="assets/img/icons/quote.svg" alt="icon" class="injectable">-->
        <!--                                    </div>-->
        <!--                                    <div class="testimonial__content">-->
        <!--                                        <p>“Excellent content and a real sense of community among the participant-->
        <!--                                        all curated in a wonderful setting. It is clear effort goes into the organization and planning of the gatherings. ”</p>-->
        <!--                                        <div class="testimonial__rating">-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                        </div>-->
        <!--                                        <div class="testimonial__content-bottom">-->
        <!--                                            <h4 class="title">Mr.Robey Alexa</h4>-->
        <!--                                            <span>CEO, Beeko Agency</span>-->
        <!--                                        </div>-->
        <!--                                    </div>-->
        <!--                                </div>-->
        <!--                            </div>-->
        <!--                            <div class="swiper-slide">-->
        <!--                                <div class="testimonial__item">-->
        <!--                                    <div class="testimonial__icon">-->
        <!--                                        <img src="assets/img/icons/quote.svg" alt="icon" class="injectable">-->
        <!--                                    </div>-->
        <!--                                    <div class="testimonial__content">-->
        <!--                                        <p>“Excellent content and a real sense of community among the participant-->
        <!--                                        all curated in a wonderful setting. It is clear effort goes into the organization and planning of the gatherings. ”</p>-->
        <!--                                        <div class="testimonial__rating">-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                        </div>-->
        <!--                                        <div class="testimonial__content-bottom">-->
        <!--                                            <h4 class="title">Mr.Robey Alexa</h4>-->
        <!--                                            <span>CEO, Beeko Agency</span>-->
        <!--                                        </div>-->
        <!--                                    </div>-->
        <!--                                </div>-->
        <!--                            </div>-->
        <!--                            <div class="swiper-slide">-->
        <!--                                <div class="testimonial__item">-->
        <!--                                    <div class="testimonial__icon">-->
        <!--                                        <img src="assets/img/icons/quote.svg" alt="icon" class="injectable">-->
        <!--                                    </div>-->
        <!--                                    <div class="testimonial__content">-->
        <!--                                        <p>“Excellent content and a real sense of community among the participant-->
        <!--                                        all curated in a wonderful setting. It is clear effort goes into the organization and planning of the gatherings. ”</p>-->
        <!--                                        <div class="testimonial__rating">-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                        </div>-->
        <!--                                        <div class="testimonial__content-bottom">-->
        <!--                                            <h4 class="title">Mr.Robey Alexa</h4>-->
        <!--                                            <span>CEO, Beeko Agency</span>-->
        <!--                                        </div>-->
        <!--                                    </div>-->
        <!--                                </div>-->
        <!--                            </div>-->
        <!--                            <div class="swiper-slide">-->
        <!--                                <div class="testimonial__item">-->
        <!--                                    <div class="testimonial__icon">-->
        <!--                                        <img src="assets/img/icons/quote.svg" alt="icon" class="injectable">-->
        <!--                                    </div>-->
        <!--                                    <div class="testimonial__content">-->
        <!--                                        <p>“Excellent content and a real sense of community among the participant-->
        <!--                                        all curated in a wonderful setting. It is clear effort goes into the organization and planning of the gatherings. ”</p>-->
        <!--                                        <div class="testimonial__rating">-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                            <i class="fas fa-star"></i>-->
        <!--                                        </div>-->
        <!--                                        <div class="testimonial__content-bottom">-->
        <!--                                            <h4 class="title">Mr.Robey Alexa</h4>-->
        <!--                                            <span>CEO, Beeko Agency</span>-->
        <!--                                        </div>-->
        <!--                                    </div>-->
        <!--                                </div>-->
        <!--                            </div>-->
        <!--                        </div>-->
        <!--                        <div class="swiper testimonial__nav">-->
        <!--                            <div class="swiper-wrapper">-->
        <!--                                <div class="swiper-slide">-->
        <!--                                    <button><img src="assets/img/images/testi_avatar01.png" alt="img"></button>-->
        <!--                                </div>-->
        <!--                                <div class="swiper-slide">-->
        <!--                                    <button><img src="assets/img/images/testi_avatar02.png" alt="img"></button>-->
        <!--                                </div>-->
        <!--                                <div class="swiper-slide">-->
        <!--                                    <button><img src="assets/img/images/testi_avatar03.png" alt="img"></button>-->
        <!--                                </div>-->
        <!--                                <div class="swiper-slide">-->
        <!--                                    <button><img src="assets/img/images/testi_avatar04.png" alt="img"></button>-->
        <!--                                </div>-->
        <!--                            </div>-->
        <!--                        </div>-->
        <!--                        <div class="testimonial__nav-two">-->
        <!--                            <button class="testimonial-button-prev"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></button>-->
        <!--                            <button class="testimonial-button-next"><img src="assets/img/icons/right_arrow.svg" alt="" class="injectable"></button>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="testimonial__shape-wrap">-->
        <!--        <img src="assets/img/images/testi_shape01.svg" alt="shape">-->
        <!--        <img src="assets/img/images/testi_shape02.svg" alt="shape">-->
        <!--        <img src="assets/img/images/testi_shape03.svg" alt="shape" data-aos="fade-up-right" data-aos-delay="400">-->
        <!--        <img src="assets/img/images/testi_shape04.svg" alt="shape">-->
        <!--        <img src="assets/img/images/testi_shape05.svg" alt="shape">-->
        <!--        <img src="assets/img/images/map.svg" alt="shape" class="big-shape">-->
        <!--    </div>-->
        <!--</section>-->
        <!-- testimonial-area-end -->

        <!-- brand-area -->
        <!--<div class="brand__area-two brand__area-four">-->
        <!--    <div class="container">-->
        <!--        <div class="swiper-container brand-active fix">-->
        <!--            <div class="swiper-wrapper">-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="brand-item">-->
        <!--                        <img src="assets/img/brand/brand_img01.png" alt="img">-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="brand-item">-->
        <!--                        <img src="assets/img/brand/brand_img02.png" alt="img">-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="brand-item">-->
        <!--                        <img src="assets/img/brand/brand_img03.png" alt="img">-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="brand-item">-->
        <!--                        <img src="assets/img/brand/brand_img04.png" alt="img">-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="brand-item">-->
        <!--                        <img src="assets/img/brand/brand_img05.png" alt="img">-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="brand-item">-->
        <!--                        <img src="assets/img/brand/brand_img06.png" alt="img">-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="brand-item">-->
        <!--                        <img src="assets/img/brand/brand_img04.png" alt="img">-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
        <!-- brand-area-end -->


    </main>
    <!-- main-area-end -->

<?php
include 'includes/footer.php';
?>
